//
//  AppICEKonyPlugin.h
//  libkonywrapper
//
//  Created by Arthe Rajesh on 09/05/24.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@class appICEUserDetails;

@interface AppICEKonyPlugin : NSObject

+ (instancetype)sharedInstance;
/*================
 Initialising SDK
 =================*/
+(void)startContext;

+(void) setupKeysWithDid:(NSString *)appKey :(NSString *)apiKey :(NSString *)appId :(NSString*)deviceId;
+(void) setupKeysWithRegion:(NSString *)appKey :(NSString *)apiKey :(NSString *)appId :(NSString*)deviceId :(NSString *)region :(NSString *)baseUrl :(NSArray *)certficates;
+(void) setupKeys:(NSString *)appKey :(NSString *)apiKey :(NSString *)appId;



/*================
 Validate Integration
 =================*/

+(BOOL)validateIntegration;

/*===================
 To set custom events
 ====================*/
+ (void)recordEvent:(NSString *)key;
+(void)recordEvent:(NSString *)key segmentation:(NSDictionary *)segmentation;

/*===================
 To set custom variable
 ====================*/
+(void) setCustomVariableString:(NSString*) key :(NSString*)value;

+ (void)setCustomVariable:(NSString *)key :(id)value;

//+(void) setCustomVariableBool:(NSString*) key :(BOOL)value;
//
//+(void) setCustomVariableLong:(NSString*)key :(int64_t) value;
//
//+(void) setCustomVariableInt:(NSString*) key :(int32_t) value;
//
//+ (void) setCustomVariable:(NSString*) key :(NSString*)value;

/*===================
 To get getSdkVersion
 ====================*/
//To check appice sdkversion
+(NSString*) getSdkVersion;

/*===================
 To get getInternalId
 ====================*/
// to get the device id:
+(NSString *)getInternalId;

/*===================
 To set unique userId
 ====================*/
+(void)setUserId:(NSArray*) userIdArray;

/*===================
 To set userDetails:
 ====================*/
+(void) setUserDetail:(appICEUserDetails*) userdetail;

/*===================
 To get userDetails:
 ====================*/
+(appICEUserDetails*)getUserDetail;

/*===================
 For camp-clicked
 ====================*/
+ (void)pushNotificationClickedEvent:(NSString *)notificationData;

/*===================
 For camp-received
 ====================*/
+ (BOOL)isSilentPush:(NSString*) payload;
+ (void)handleAppICENotification:(NSString*)notificationData;

/*=====================================
 To check if push payload is for appice:
 =====================================*/
+(BOOL)isAppICENotification:(NSString *)userInfo;

/*=====================
 Push token generation
 ======================*/
+(void) setTokenInPushNotification:(NSString*) appPushToken;

/*=====================
 Push Deeplink
 ======================*/

+(void) handleClickOnPush:(NSString *)data :(BOOL)openDeepLink;


/*=====================
  AppInbox
 ======================*/

+(NSString*)getInboxMessages:(int)status :(NSArray*)userId :(NSString*)key :(NSString*)value;

+(BOOL)updateInboxMessage:(int)status :(NSString *)messageId :(NSString *)userId;

+(int)getMessageCount:(int)status :(NSArray*)userId :(NSString*)key :(NSString*)value;

+(NSString*)getInboxMessageForId :(NSString*)messageId :(NSArray *)userId;

 
/*=====================
  AppInbox Callback
 ======================*/
typedef void (^AppICECallBackSyncInbox)(NSArray *cData);
+(void)synchronizeInbox:(AppICECallBackSyncInbox)successCallback :(int)timeoutinSec;

typedef void (^AppICEInboxSuccessBlock)(BOOL success);
+ (void)synchronizeAppInbox:(AppICEInboxSuccessBlock)CallBack :(int)timeoutinSec;


/*===============
  InApp CallBack
 ===============*/
typedef void (^AppiceCallBackDelegate)(NSArray *cData);
+(void)sendClickCallback:(AppiceCallBackDelegate)callbackValue;

typedef void (^AppiceClickDelegate)(NSDictionary *cData);
+ (void)setClickCallback:(AppiceClickDelegate)CallBack;

/*===============
  INApp States
 ===============*/
+(void)resumeInApp;
+(void)suspendInApp;
+(void)discardInApp;
+(void)dismissInApp;

@end

NS_ASSUME_NONNULL_END
