/*
 * Decompiled with CFR 0.152.
 */
package com.appice.libkonywrapper;

import android.app.PendingIntent;
import android.content.Context;
import android.os.Handler;
import androidx.annotation.RequiresApi;
import com.appice.libkonywrapper.AlertActionCallback;
import com.appice.libkonywrapper.ClickCallback;
import com.appice.libkonywrapper.PushActionCallback;
import com.appice.libkonywrapper.PushCallback;
import com.appice.libkonywrapper.Utils;
import com.appice.libkonywrapper.campaignCampsReceiver;
import com.google.firebase.FirebaseApp;
import com.google.firebase.messaging.RemoteMessage;
import com.konylabs.android.KonyMain;
import com.konylabs.vm.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONObject;
import semusi.activitysdk.Api;
import semusi.activitysdk.ContextSdk;
import semusi.activitysdk.IAppICEDataCallback;
import semusi.activitysdk.SdkConfig;
import semusi.context.counthandler.CampaignActionHelper;
import semusi.context.counthandler.DataSyncReceiver;
import semusi.context.ui.AlertPopupData;
import semusi.context.ui.appInbox.AppICEInboxMessage;
import semusi.context.ui.appInbox.IAppICESuccessCallback;
import semusi.context.utility.Utility;
import semusi.geofencing.AIGeofenceController;
import semusi.model.campaign.Campaign;
import semusi.model.user.User;

public class AppICEKonyPlugin {
    public static void startContext(String appId, String appKey, String apiKey, boolean setAnalyticsTrackingAllowedState) {
        AppICEKonyPlugin.startContext(appId, appKey, apiKey, false, setAnalyticsTrackingAllowedState);
    }

    public static void startContext(String appId, String appKey, String apiKey, boolean setPinning, boolean setAnalyticsTrackingAllowedState) {
        FirebaseApp.initializeApp((Context)KonyMain.getAppContext().getApplicationContext());
        SdkConfig config = new SdkConfig();
        config.setAnalyticsTrackingAllowedState(setAnalyticsTrackingAllowedState);
        config.setSSLPinning(setPinning);
        Api.initSdk((String)appId, (String)appKey, (String)apiKey, (Context)KonyMain.getAppContext().getApplicationContext());
        Api.startContext((Context)KonyMain.getAppContext().getApplicationContext(), (SdkConfig)config, (boolean)false);
    }

    public static void startContext(String appId, String appKey, String apiKey, String deviceId, String region, String baseUrl, Vector<String> vectorCerts) {
        List<String> certs = null;
        FirebaseApp.initializeApp((Context)KonyMain.getAppContext().getApplicationContext());
        SdkConfig config = new SdkConfig();
        try {
            if (vectorCerts != null) {
                String[] array = vectorCerts.toArray(new String[vectorCerts.size()]);
                certs = Arrays.asList(array);
            }
        }
        catch (Throwable t) {
            Utility.loginfo((String)("error in vectorCerts " + t));
        }
        Api.initSdk((String)appId, (String)appKey, (String)apiKey, (String)region, (String)baseUrl, certs, (Context)KonyMain.getAppContext().getApplicationContext());
        Api.startContext((Context)KonyMain.getAppContext().getApplicationContext(), (SdkConfig)config, (boolean)false);
    }

    @RequiresApi(api=21)
    public static boolean validateIntegration() {
        boolean checkAppIdEntryExist = true;
        boolean checkAppKeyExist = true;
        boolean checkApiKeyExist = true;
        boolean sdkIsInstalledProperly = true;
        try {
            Context ctx = KonyMain.getAppContext().getApplicationContext();
            ContextSdk sdk = new ContextSdk(ctx);
            if (sdk.getAppId() == null || sdk.getAppId().length() <= 0 || sdk.getAppId().trim().length() <= 0) {
                Utility.loginfo((String)"Missing Meta-data entry : AppID");
                checkAppIdEntryExist = false;
            }
            if (sdk.getAppKey() == null || sdk.getAppKey().length() <= 0 || sdk.getAppKey().trim().length() <= 0) {
                Utility.loginfo((String)"Missing Meta-data entry : AppKey");
                checkAppKeyExist = false;
            }
            if (sdk.getApiKey() == null || sdk.getApiKey().length() <= 0 || sdk.getApiKey().trim().length() <= 0) {
                Utility.loginfo((String)"Missing Meta-data entry : ApiKey");
                checkApiKeyExist = false;
            }
            if (!(checkAppIdEntryExist || checkAppKeyExist || checkApiKeyExist)) {
                sdkIsInstalledProperly = false;
            }
        }
        catch (Throwable e) {
            Utility.loginfo((String)("exception in validate integration : " + e));
            sdkIsInstalledProperly = false;
        }
        return sdkIsInstalledProperly;
    }

    public static void tagEventObj(String eventName, String map) {
        Utility.loginfo((String)("tagEventObj eventName = " + eventName + ", map = " + map));
        try {
            JSONObject jsonObject;
            if (map != null && map.length() > 0 && (jsonObject = new JSONObject(map)) != null) {
                Map<String, Object> attr = AppICEKonyPlugin.toMap(jsonObject);
                Utility.loginfo((String)("tagEventObj eventName = " + eventName + ", attr = " + attr));
                if (attr != null) {
                    ContextSdk.tagEventObj((String)eventName, attr, (Context)KonyMain.getAppContext().getApplicationContext());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void tagEvent(String eventName, Map<String, String> map) {
        ContextSdk.tagEvent((String)eventName, map, (Context)KonyMain.getAppContext().getApplicationContext());
    }

    public static void setCustomVariable(String key, Object value) {
        if (value instanceof Integer) {
            ContextSdk.setCustomVariable((String)key, (Integer)((Integer)value), (Context)KonyMain.getAppContext().getApplicationContext());
        }
        if (value instanceof String) {
            ContextSdk.setCustomVariable((String)key, (String)((String)value), (Context)KonyMain.getAppContext().getApplicationContext());
        }
        if (value instanceof Long) {
            ContextSdk.setCustomVariable((String)key, (Long)((Long)value), (Context)KonyMain.getAppContext().getApplicationContext());
        }
        if (value instanceof Float) {
            ContextSdk.setCustomVariable((String)key, (Float)Float.valueOf(((Float)value).floatValue()), (Context)KonyMain.getAppContext().getApplicationContext());
        }
        if (value instanceof Boolean) {
            ContextSdk.setCustomVariable((String)key, (Boolean)((Boolean)value), (Context)KonyMain.getAppContext().getApplicationContext());
        }
    }

    public static Object getCustomVariable(String key) {
        return ContextSdk.getCustomVariable((String)key, (Context)KonyMain.getAppContext().getApplicationContext());
    }

    public static String getSdkVersion() {
        return ContextSdk.getSdkVersion();
    }

    public static String getInternalId() {
        return ContextSdk.getInternalId((Context)KonyMain.getAppContext().getApplicationContext());
    }

    public static int getMessageCount(int type, Vector<String> users, String key, String value) {
        int count = 0;
        try {
            List<Object> inboxMessagesList = new ArrayList();
            if (users != null) {
                if (key != null && key.length() > 0 && value != null && value.length() > 0) {
                    inboxMessagesList = AppICEKonyPlugin.getInternalInboxList(type, users, key, value);
                    if (inboxMessagesList != null) {
                        count = inboxMessagesList.size();
                    }
                } else if (users != null && users.size() > 0) {
                    String[] array = users.toArray(new String[users.size()]);
                    count = ContextSdk.getMessageCount((int)type, (String[])array, (Context)KonyMain.getAppContext());
                } else {
                    count = ContextSdk.getMessageCount((int)type, (Context)KonyMain.getAppContext());
                }
            }
            Utility.loginfo((String)("getMessageCount " + count));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return count;
    }

    public static String getInboxMessage(int type, Vector<String> users, String key, String value) {
        String messageList = "";
        List<Object> inboxMessagesList = new ArrayList();
        JSONArray messages = new JSONArray();
        try {
            if (key != null && key.length() > 0 && value != null && value.length() > 0) {
                inboxMessagesList = AppICEKonyPlugin.getInternalInboxList(type, users, key, value);
            } else if (users != null && users.size() > 0) {
                String[] array = users.toArray(new String[users.size()]);
                inboxMessagesList = ContextSdk.getInboxMessage((int)type, (String[])array, (Context)KonyMain.getAppContext().getApplicationContext());
            } else {
                inboxMessagesList = ContextSdk.getInboxMessage((int)type, (Context)KonyMain.getAppContext().getApplicationContext());
            }
            if (inboxMessagesList != null) {
                for (int i = 0; i < inboxMessagesList.size(); ++i) {
                    AppICEInboxMessage message = (AppICEInboxMessage)inboxMessagesList.get(i);
                    messages.put((Object)message.toJson());
                }
            }
        }
        catch (Throwable e) {
            messageList = "";
        }
        if (messages != null) {
            messageList = messages.toString();
        }
        Utility.loginfo((String)("getInboxMessage " + messageList));
        return messageList;
    }

    public static String getInboxMessageForId(String messageID, String user) {
        String messageList = "";
        try {
            if (messageID != null && messageID.length() > 0) {
                JSONObject messageObj;
                AppICEInboxMessage inboxMessages = null;
                inboxMessages = user != null && user.length() > 0 ? ContextSdk.getInboxMessageForId((String)messageID, (String)user, (Context)KonyMain.getAppContext().getApplicationContext()) : ContextSdk.getInboxMessageForId((String)messageID, (Context)KonyMain.getAppContext().getApplicationContext());
                if (inboxMessages != null && (messageObj = inboxMessages.toJson()) != null) {
                    messageList = messageObj.toString();
                }
            }
            Utility.loginfo((String)("getInboxMessageForId " + messageList));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return messageList;
    }

    public static boolean updatedInboxMessage(String mid, int type, String userId) {
        boolean isStatusChanged = false;
        try {
            isStatusChanged = mid != null && mid.length() > 0 ? (userId != null && userId.length() > 0 ? ContextSdk.updatedInboxMessage((String)mid, (int)type, (String)userId, (Context)KonyMain.getAppContext().getApplicationContext()) : ContextSdk.updateInboxMessage((String)mid, (int)type, (Context)KonyMain.getAppContext().getApplicationContext())) : false;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return isStatusChanged;
    }

    public static void synchronizeInbox(final int timeout, final Function callback) {
        final Context context = KonyMain.getAppContext().getApplicationContext();
        try {
            Handler handler = new Handler(context.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    ContextSdk.synchronizeInbox((IAppICESuccessCallback)new IAppICESuccessCallback(){

                        public void callback(boolean b) {
                            if (callback != null) {
                                try {
                                    callback.execute((Object[])new Boolean[]{b});
                                }
                                catch (Throwable e) {
                                    Utility.loginfo((String)("LibKonyWrapper: execute " + e));
                                }
                            }
                        }
                    }, (int)timeout, (Context)context);
                }
            });
        }
        catch (Throwable throwable) {
            Utility.loginfo((String)("synchronizeInbox : exception " + throwable));
        }
    }

    public static String getUser() {
        User user = ContextSdk.getUser((Context)KonyMain.getAppContext().getApplicationContext());
        if (user != null) {
            Utility.loginfo((String)("user name " + user.getName()));
            return user.toString();
        }
        return "";
    }

    public static String getUser(Vector<String> userId) {
        ArrayList<String> arrayList;
        ArrayList user;
        JSONArray jsonArray = new JSONArray();
        if (!userId.isEmpty() && (user = ContextSdk.getUser(arrayList = new ArrayList<String>(userId), (Context)KonyMain.getAppContext().getApplicationContext())) != null) {
            for (int i = 0; i < user.size(); ++i) {
                jsonArray.put((Object)((User)user.get(i)).toString());
            }
            Utility.loginfo((String)("getUser with userid " + jsonArray));
            return jsonArray.toString();
        }
        return "";
    }

    public static void setUser(String userStr) {
        try {
            Utility.loginfo((String)("userStr " + userStr));
            if (Utility.isValidObject((Object)userStr)) {
                JSONObject userObject = new JSONObject(userStr);
                User user = new User(userObject);
                Utility.loginfo((String)("user name" + user.getName()));
                ContextSdk.setUser((User)user, (Context)KonyMain.getAppContext().getApplicationContext());
            }
        }
        catch (Throwable t) {
            Utility.loginfo((String)("setUser exception t " + t));
        }
    }

    public static void synchronizeData(final int timeout, final Function successBlock, final Function failureBlock) {
        final Context context = KonyMain.getAppContext().getApplicationContext();
        try {
            Handler handler = new Handler(context.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    ContextSdk.synchronizeData((IAppICEDataCallback)new IAppICEDataCallback(){

                        public void onSuccess() {
                            if (successBlock != null) {
                                try {
                                    successBlock.execute((Object[])new Boolean[]{true});
                                }
                                catch (Throwable e) {
                                    Utility.loginfo((String)("LibKonyWrapper: execute " + e));
                                }
                            }
                        }

                        public void onFailure(String message) {
                            if (failureBlock != null) {
                                try {
                                    failureBlock.execute((Object[])new String[]{message});
                                }
                                catch (Throwable e) {
                                    Utility.loginfo((String)("LibKonyWrapper: execute " + e));
                                }
                            }
                        }
                    }, (int)timeout, (Context)context);
                }
            });
        }
        catch (Throwable throwable) {
            Utility.loginfo((String)("synchronizeData : exception " + throwable));
        }
    }

    public static void sendClickCallback(final Function callback) {
        Context context = KonyMain.getAppContext().getApplicationContext();
        Handler handler = new Handler(context.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                ClickCallback clickCallback = new ClickCallback(){

                    @Override
                    public void clickPayload(String obj) {
                        if (obj != null && obj.length() > 0 && callback != null) {
                            try {
                                Utility.loginfo((String)("AppICEKonyPlugin : sendClickCallback : " + obj));
                                callback.execute((Object[])new String[]{obj});
                            }
                            catch (Throwable e) {
                                Utility.loginfo((String)("AppICEKonyPlugin : sendClickCallback : error " + e));
                            }
                        }
                    }
                };
                campaignCampsReceiver campaignCampsReceiver2 = new campaignCampsReceiver(clickCallback);
            }
        });
    }

    public static void sendPushClickCallback(final Function callback) {
        Context context = KonyMain.getAppContext().getApplicationContext();
        Handler handler = new Handler(context.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                PushCallback clickCallback = new PushCallback(){

                    @Override
                    public void pushPayload(String obj) {
                        if (obj != null && obj.length() > 0 && callback != null) {
                            try {
                                Utility.loginfo((String)("AppICEKonyPlugin : sendClickCallback : " + obj));
                                callback.execute((Object[])new String[]{obj});
                            }
                            catch (Throwable e) {
                                Utility.loginfo((String)("AppICEKonyPlugin : sendClickCallback : error " + e));
                            }
                        }
                    }
                };
                campaignCampsReceiver campaignCampsReceiver2 = new campaignCampsReceiver(clickCallback);
            }
        });
    }

    public static void sendPushActionClickCallback(final Function callback) {
        Context context = KonyMain.getAppContext().getApplicationContext();
        Handler handler = new Handler(context.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                PushActionCallback clickCallback = new PushActionCallback(){

                    @Override
                    public void pushActionPayload(String obj) {
                        if (Utility.isValidObject((Object)obj) && callback != null) {
                            try {
                                Utility.loginfo((String)("AppICEKonyPlugin : sendPushActionClickCallback : " + obj));
                                callback.execute((Object[])new String[]{obj});
                            }
                            catch (Throwable e) {
                                Utility.loginfo((String)("AppICEKonyPlugin : sendPushActionClickCallback : error " + e));
                            }
                        }
                    }
                };
                campaignCampsReceiver campaignCampsReceiver2 = new campaignCampsReceiver(clickCallback);
            }
        });
    }

    public static void pushNotificationReceived(RemoteMessage message) {
        try {
            ContextSdk.pushNotificationReceived((RemoteMessage)message, (Context)KonyMain.getAppContext().getApplicationContext());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void pushNotificationViewed(RemoteMessage message) {
        try {
            ContextSdk.pushNotificationViewed((RemoteMessage)message, (Context)KonyMain.getAppContext().getApplicationContext());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void pushNotificationClicked(Map<String, String> message) {
        try {
            ContextSdk.pushNotificationClicked(message, (Context)KonyMain.getAppContext().getApplicationContext());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void pushNotificationClicked(String message) {
        try {
            ContextSdk.pushNotificationClicked((String)message, (Context)KonyMain.getAppContext().getApplicationContext());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void handleAppICENotification(String message) {
        try {
            int uniqueId = Utils.generatePushMessageNotificationId(KonyMain.getAppContext().getApplicationContext());
            ArrayList<PendingIntent> pendingIntents = Utils.createNotificationPendingIntentsFromMap((Context)KonyMain.getActivityContext(), message, uniqueId);
            ContextSdk.handleAppICEPush((String)message, (PendingIntent)Utils.createPendingIntent(message, (Context)KonyMain.getActivityContext()), (PendingIntent)Utils.deletePendingIntent((Context)KonyMain.getActivityContext()), (Context)KonyMain.getActivityContext(), pendingIntents, (int)uniqueId);
        }
        catch (Throwable e) {
            Utility.loginfo((String)("exception in handleAppICENotification " + e));
        }
    }

    public static boolean isAppICENotification(String payload) {
        boolean isAppICE = false;
        try {
            isAppICE = ContextSdk.isAppICENotification((String)payload);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return isAppICE;
    }

    public static boolean isAppICENotification(RemoteMessage remoteMessage) {
        boolean isAppICE = false;
        try {
            isAppICE = ContextSdk.isAppICENotification((RemoteMessage)remoteMessage);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return isAppICE;
    }

    public static void setUserId(Vector<String> userId) {
        try {
            if (!userId.isEmpty()) {
                String[] array = userId.toArray(new String[userId.size()]);
                ContextSdk.setUser((String[])array, (Context)KonyMain.getAppContext().getApplicationContext());
            }
        }
        catch (Throwable e) {
            Utility.loginfo((String)("exception : in setUserId : " + e));
        }
    }

    public static String getUserId() {
        String result = "";
        JSONArray resultArray = new JSONArray();
        try {
            String userIdsStr = ContextSdk.getUserId((Context)KonyMain.getAppContext().getApplicationContext());
            if (userIdsStr != null && userIdsStr.length() > 0) {
                JSONArray userIdArray = new JSONArray(userIdsStr);
                if (userIdArray != null && userIdArray.length() > 0) {
                    for (int i = 0; i < userIdArray.length(); ++i) {
                        resultArray.put(userIdArray.get(i));
                    }
                } else {
                    Utility.loginfo((String)"User id list is empty");
                }
            } else {
                Utility.loginfo((String)"User id list is empty");
            }
            if (resultArray != null && resultArray.length() > 0) {
                return resultArray.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public static boolean isSilentPush(String payload) {
        boolean isSilentPush = false;
        try {
            boolean isAppICE = ContextSdk.isAppICENotification((String)payload);
            if (isAppICE) {
                JSONObject root = new JSONObject(payload);
                isSilentPush = root.has("sp") ? root.optBoolean("sp") : false;
            }
        }
        catch (Throwable e) {
            Utility.loginfo((String)("exception in Silent push parsing : " + e));
            isSilentPush = false;
        }
        return isSilentPush;
    }

    public static void handleClickOnPush(String payload) {
        try {
            ContextSdk.handleOpenLinkUrl((String)payload, (Context)KonyMain.getAppContext().getApplicationContext());
        }
        catch (Throwable e) {
            Utility.loginfo((String)("exception in handleClickOnPush : " + e));
        }
    }

    private static Map<String, Object> toMap(JSONObject jsonobj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Iterator keys = jsonobj.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                List<Object> value = jsonobj.get(key);
                if (value instanceof JSONArray) {
                    value = AppICEKonyPlugin.toList((JSONArray)value);
                } else if (value instanceof JSONObject) {
                    value = AppICEKonyPlugin.toMap((JSONObject)value);
                }
                map.put(key, value);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return map;
    }

    private static List<Object> toList(JSONArray array) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            for (int i = 0; i < array.length(); ++i) {
                List<Object> value = array.get(i);
                if (value instanceof JSONArray) {
                    value = AppICEKonyPlugin.toList((JSONArray)value);
                } else if (value instanceof JSONObject) {
                    value = AppICEKonyPlugin.toMap((JSONObject)value);
                }
                list.add(value);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return list;
    }

    private static List<AppICEInboxMessage> getInternalInboxList(int type, Vector<String> users, String key, String value) {
        ArrayList<AppICEInboxMessage> inboxMessagesList = new ArrayList<AppICEInboxMessage>();
        try {
            if (users != null) {
                String[] array = users.toArray(new String[users.size()]);
                if (key != null && key.length() > 0 && value != null && value.length() > 0) {
                    List inboxMessages = ContextSdk.getInboxMessage((int)type, (String[])array, (Context)KonyMain.getAppContext().getApplicationContext());
                    if (inboxMessages != null) {
                        for (int i = 0; i < inboxMessages.size(); ++i) {
                            String objValStr;
                            Object objVal;
                            AppICEInboxMessage appICEInboxMessage = (AppICEInboxMessage)inboxMessages.get(i);
                            Map objectMap = appICEInboxMessage.getCustomData();
                            boolean objBool = objectMap.containsKey(key);
                            if (!objBool || (objVal = objectMap.get(key)) == null || (objValStr = objVal.toString()) == null || objValStr.length() <= 0 || !objValStr.equalsIgnoreCase(value)) continue;
                            inboxMessagesList.add(appICEInboxMessage);
                        }
                    } else {
                        Utility.loginfo((String)"There is no data attached for this userid");
                    }
                }
            } else {
                Utility.loginfo((String)"Users is null");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return inboxMessagesList;
    }

    public static void CallInternalApis() {
        try {
            DataSyncReceiver.doCombineGetRequest((Context)KonyMain.getAppContext().getApplicationContext());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void resumeInApp() {
        ContextSdk.resumeInApp((Context)KonyMain.getAppContext().getApplicationContext());
    }

    public static void suspendInApp() {
        ContextSdk.suspendInApp((Context)KonyMain.getAppContext().getApplicationContext());
    }

    public static void discardInApp() {
        ContextSdk.discardInApp((Context)KonyMain.getAppContext().getApplicationContext());
    }

    public static void dismissInAppUI() {
        ContextSdk.dismissInApp();
    }

    public static void checkLocationSettings(String title, String message) {
        boolean isLocationOn = Utils.isLocationEnabled((Context)KonyMain.getActivityContext());
        if (!isLocationOn) {
            Utils.showAlert(title, message, (Context)KonyMain.getActivityContext());
        }
    }

    public static void addCampaignActionButtonClickCallback(Function callback) {
        Context context = KonyMain.getAppContext().getApplicationContext();
        CampaignActionHelper listener = CampaignActionHelper.getInstance();
        listener.setCampaignActionListener(campaign -> {
            try {
                JSONObject jsonObject = campaign.toJson();
                String campaignText = jsonObject.toString();
                callback.execute((Object[])new String[]{campaignText});
            }
            catch (Exception e) {
                Utility.loginfo((String)("exception in addCampaignActionButtonClickCallback : " + e));
            }
        });
    }

    public static void scheduleCampaign(String cmpId, int durationInSec, String userId) {
        try {
            ContextSdk.scheduleCampaign((String)cmpId, (int)durationInSec, (String)userId);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void sendCampaignClickEvent(String campId, String actionText) {
        try {
            ContextSdk.sendCampaignClickedActionButton((String)campId, (String)actionText);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String handlePush(String payload) {
        Context context = KonyMain.getAppContext().getApplicationContext();
        try {
            Campaign campaign = ContextSdk.handlePush((String)payload, (Context)context);
            JSONObject tempObj = campaign.toJson();
            return tempObj.toString();
        }
        catch (Throwable e) {
            Utility.loginfo((String)("exception in handlePush " + e));
            return "";
        }
    }

    public static void dismissNotification(int id) {
        ContextSdk.cancelNotification((int)id, (Context)KonyMain.getActivityContext());
    }

    public static void registerGeofence() {
        Context context = KonyMain.getAppContext().getApplicationContext();
        AIGeofenceController.getInstance().register(context);
    }

    public static void showCustomAlert(String title, String message, String url, String backgroundColor, String textColor, String buttonColor) {
        try {
            Context context = KonyMain.getAppContext().getApplicationContext();
            AlertPopupData alertPopupData = new AlertPopupData();
            alertPopupData.setTitle(title);
            alertPopupData.setMessage(message);
            alertPopupData.setUrl(url);
            alertPopupData.setBackgroundColor(backgroundColor);
            alertPopupData.setTextColor(textColor);
            alertPopupData.setButtonBGColor(buttonColor);
            Utility.showAlertPopup((Context)context, (AlertPopupData)alertPopupData);
        }
        catch (Throwable t) {
            Utility.loginfo((String)("exception in showCustomAlert " + t));
        }
    }

    public static void showCustomAlertWithCallback(String title, String message, String url, String payload, String backgroundColor, String textColor, String buttonTextColor, String buttonBGColor, String buttonText, String crossIconColor, final Function positiveCallback) {
        try {
            Context context = KonyMain.getAppContext().getApplicationContext();
            AlertPopupData alertData = new AlertPopupData();
            alertData.setUrl(url);
            alertData.setTitle(title);
            alertData.setMessage(message);
            alertData.setBackgroundColor(backgroundColor);
            alertData.setTextColor(textColor);
            alertData.setButtonTextColor(buttonTextColor);
            alertData.setButtonBGColor(buttonBGColor);
            alertData.setButtonText(buttonText);
            alertData.setCrossIconColor(crossIconColor);
            alertData.setCampaignData(payload);
            Utility.showCustomAlertPopup((Context)context, (AlertPopupData)alertData);
            AlertActionCallback clickCallback = new AlertActionCallback(){

                @Override
                public void onPositiveCallback(String payload) {
                    try {
                        System.out.println("wrapper callback triggered for positive callback");
                        positiveCallback.execute((Object[])new String[]{payload});
                    }
                    catch (Exception e) {
                        Utility.loginfo((String)("exception in positiveButton " + e));
                    }
                }
            };
            campaignCampsReceiver campaignCampsReceiver2 = new campaignCampsReceiver(clickCallback);
        }
        catch (Throwable t) {
            Utility.loginfo((String)("exception in showCustomAlert " + t));
        }
    }

    public static boolean hasBackgroundLocationPermission() {
        Context context = KonyMain.getActivityContext().getApplicationContext();
        return Utility.hasBackgroundLocationPermission((Context)context);
    }
}

