/*
 * Decompiled with CFR 0.152.
 */
package com.appice.libkonywrapper;

import com.appice.libkonywrapper.PluginResult;
import org.json.JSONArray;
import org.json.JSONObject;

public class CallbackContext {
    private static final String LOG_TAG = "KonyPlugin";
    private String callbackId;
    protected boolean finished;
    private int changingThreads;

    public CallbackContext(String callbackId) {
        this.callbackId = callbackId;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isChangingThreads() {
        return this.changingThreads > 0;
    }

    public String getCallbackId() {
        return this.callbackId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPluginResult(PluginResult pluginResult) {
        CallbackContext callbackContext = this;
        synchronized (callbackContext) {
            if (this.finished) {
                System.out.println("KonyPlugin Attempted to send a second callback for ID: " + this.callbackId + "\nResult was: " + pluginResult.getMessage());
                return;
            }
            this.finished = !pluginResult.getKeepCallback();
        }
    }

    public void success(JSONObject message) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.OK, message));
    }

    public void success(String message) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.OK, message));
    }

    public void success(JSONArray message) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.OK, message));
    }

    public void success(byte[] message) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.OK, message));
    }

    public void success(int message) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.OK, message));
    }

    public void success() {
        this.sendPluginResult(new PluginResult(PluginResult.Status.OK));
    }

    public void error(JSONObject message) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, message));
    }

    public void error(String message) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, message));
    }

    public void error(int message) {
        this.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, message));
    }
}

