/*
 * Decompiled with CFR 0.152.
 */
package com.appice.libkonywrapper;

import android.app.ActivityManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import com.appice.libkonywrapper.CampaignCampReceiver;
import com.google.firebase.messaging.RemoteMessage;
import com.konylabs.android.KonyMain;
import com.konylabs.fcm.KonyFCMService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import semusi.activitysdk.ContextSdk;
import semusi.context.utility.Utility;

public class FirebaseCustomListener
extends KonyFCMService {
    public static int getMaxCount = 100;
    private static int sdkNotificationId = 10342;

    public void handlePush(Map<String, String> data, Context context) {
        sdkNotificationId = Utility.next();
        int notificationId = this.generatePushMessageNotificationId(context);
        FirebaseCustomListener.saveIntPreferences("pushMsgNotificationId", notificationId, context);
        data.put("source", "appicepushwrapper");
        PendingIntent contentIntent = this.createNotificationPendingIntent(context, data, notificationId);
        String msg = data.get("message");
        ArrayList<PendingIntent> pendingIntents = this.createNotificationPendingIntentsFromMap((Context)this, data, sdkNotificationId);
        boolean payloadHaveExternalUrl = ContextSdk.isPayloadHaveExternalUrl((String)msg);
        if (payloadHaveExternalUrl) {
            ContextSdk.handleAppICEPush((String)msg, (PendingIntent)null, (PendingIntent)null, (Context)context, pendingIntents, (int)sdkNotificationId);
        } else {
            ContextSdk.handleAppICEPush((String)msg, (PendingIntent)contentIntent, (PendingIntent)this.deletePendingIntent(context), (Context)context, pendingIntents, (int)sdkNotificationId);
        }
    }

    public boolean isAppInForeground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return false;
        }
        String packageName = context.getPackageName();
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (appProcess.importance != 100 || !appProcess.processName.equals(packageName)) continue;
            return true;
        }
        return false;
    }

    public void onMessageReceived(RemoteMessage remoteMessage) {
        boolean isAppICEPush = ContextSdk.isAppICENotification((RemoteMessage)remoteMessage);
        if (this.isAppInForeground(this.getApplicationContext()) && isAppICEPush) {
            Map data = remoteMessage.getData();
            this.handlePush(data, this.getApplicationContext());
        } else {
            super.onMessageReceived(remoteMessage);
        }
    }

    public void showPushMessageNotification(Context context, Map<String, String> data) {
        try {
            this.handlePush(data, context);
        }
        catch (Throwable t) {
            Utility.loginfo((String)("exception in showPushMessageNotification : " + t));
        }
    }

    public ArrayList<PendingIntent> createNotificationPendingIntentsFromMap(Context context, Map<String, String> data, int sdkNotificationId) {
        ArrayList<PendingIntent> pendingIntents = new ArrayList<PendingIntent>();
        try {
            String messageData = data.get("message");
            if (messageData != null) {
                JSONObject baseMessageObject = new JSONObject(messageData);
                if (baseMessageObject.has("actions") && baseMessageObject.getJSONArray("actions").length() > 0) {
                    JSONArray actionsArray = baseMessageObject.getJSONArray("actions");
                    int size = actionsArray.length();
                    for (int i = 0; i < size; ++i) {
                        JSONObject actionObject = actionsArray.getJSONObject(i);
                        String actValue = actionObject.optString("act");
                        int actionUniqueId = this.generatePushMessageNotificationId(context);
                        JSONObject actionMessageObject = new JSONObject(baseMessageObject.toString());
                        actionMessageObject.put("selectedIndex", i);
                        actionMessageObject.put("notificationId", sdkNotificationId);
                        actionMessageObject.put("source", (Object)"appicepushwrapper");
                        HashMap<String, String> actionMap = new HashMap<String, String>();
                        actionMap.put("message", actionMessageObject.toString());
                        PendingIntent pendingIntent = null;
                        if (actValue.equalsIgnoreCase("dl") || actValue.equalsIgnoreCase("rml") || actValue.equalsIgnoreCase("cus")) {
                            pendingIntent = this.createNotificationPendingIntentForAction(context, actionMap, actValue, actionUniqueId);
                        } else if (actValue.equalsIgnoreCase("rly")) {
                            pendingIntent = this.createNotificationPendingIntentForActionWithRemoteInput(context, actionMap, actValue, actionUniqueId);
                        } else {
                            Log.d((String)"AppICE PushWrapper", (String)(actValue + " Will be handled by SDK"));
                        }
                        pendingIntents.add(pendingIntent);
                    }
                } else {
                    Log.d((String)"AppICE PushWrapper", (String)"AppiceLog No actions found in the message data.");
                }
            } else {
                Log.d((String)"AppICE PushWrapper", (String)"AppiceLog message key not found in the data map.");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return pendingIntents;
    }

    private final int generatePushMessageNotificationId(Context context) {
        int pushMsgNotificationId = FirebaseCustomListener.loadIntSavedPreferences("pushMsgNotificationId", context);
        if (++pushMsgNotificationId > getMaxCount) {
            pushMsgNotificationId = 1;
        }
        return pushMsgNotificationId;
    }

    private final int getMaxNotificationsCount(Context context) {
        int maxNoti = 1;
        String pkgName = context.getPackageName();
        int resId = context.getResources().getIdentifier("notify_push_msg_notifications_count", "string", pkgName);
        if (resId != 0) {
            String maxNotificationsStr = context.getString(resId);
            try {
                maxNoti = Integer.parseInt(maxNotificationsStr);
                if (maxNoti > 50) {
                    maxNoti = 50;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return maxNoti;
    }

    private PendingIntent deletePendingIntent(Context mContext) {
        Intent clickIntent = new Intent(mContext, CampaignCampReceiver.class);
        Bundle bundle = new Bundle();
        bundle.putBoolean("d", true);
        clickIntent.putExtras(bundle);
        int notificationId = this.generatePushMessageNotificationId(mContext);
        FirebaseCustomListener.saveIntPreferences("pushMsgNotificationId", notificationId, mContext);
        Utility.loginfo((String)("deletePendingIntent " + notificationId));
        PendingIntent pendingIntent = Build.VERSION.SDK_INT >= 23 ? PendingIntent.getBroadcast((Context)mContext, (int)notificationId, (Intent)clickIntent, (int)0x4000000) : PendingIntent.getBroadcast((Context)mContext, (int)notificationId, (Intent)clickIntent, (int)0x4000000);
        return pendingIntent;
    }

    public void onNewToken(String s) {
        super.onNewToken(s);
        ContextSdk.updateToken((String)s, (Context)KonyMain.getAppContext().getApplicationContext());
    }

    public static void saveIntPreferences(String key, int value, Context ctx) {
        try {
            SharedPreferences sp = ctx.getSharedPreferences("AppICEFCMWrapper", 0);
            SharedPreferences.Editor edit = sp.edit();
            edit.putInt(key, value);
            edit.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int loadIntSavedPreferences(String key, Context ctx) {
        int name = 0;
        try {
            SharedPreferences sp = ctx.getSharedPreferences("AppICEFCMWrapper", 0);
            name = sp.getInt(key, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    protected final PendingIntent createNotificationPendingIntentForActionWithRemoteInput(Context context, Map<String, String> dataMap, String actionId, int requestCode) {
        try {
            int uniqueId;
            ArrayList<String[]> keyValueArrays = this.convertMapToKeyValueArrays(dataMap);
            String[] keys = keyValueArrays.get(0);
            String[] values = keyValueArrays.get(1);
            Bundle bundle = new Bundle();
            bundle.putStringArray("push-msg-keys", keys);
            bundle.putStringArray("push-msg-values", values);
            Intent intent = new Intent();
            intent.putExtra("push-notification-msg", bundle);
            String packageName = context.getPackageName();
            intent.setClassName(packageName, KonyMain.getMainActivityClassName());
            intent.putExtra("actionId", actionId);
            int finalRequestCode = uniqueId = this.generateUniqueId();
            intent.putExtra("requestCode", requestCode);
            intent.setPackage(packageName);
            int flags = FirebaseCustomListener.getPendingIntentFlags();
            return PendingIntent.getActivity((Context)context, (int)finalRequestCode, (Intent)intent, (int)flags);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static int getPendingIntentFlags() {
        int flag = 0;
        flag = Build.VERSION.SDK_INT >= 31 ? 0xA000000 : 0x8000000;
        return flag;
    }

    private ArrayList<String[]> convertMapToKeyValueArrays(Map<String, String> map) {
        try {
            String[] keys = map.keySet().toArray(new String[0]);
            String[] values = map.values().toArray(new String[0]);
            ArrayList<String[]> keyValueArrays = new ArrayList<String[]>();
            keyValueArrays.add(keys);
            keyValueArrays.add(values);
            return keyValueArrays;
        }
        catch (Throwable e) {
            ArrayList<String[]> emptyKeyValueArrays = new ArrayList<String[]>();
            emptyKeyValueArrays.add(new String[0]);
            emptyKeyValueArrays.add(new String[0]);
            return emptyKeyValueArrays;
        }
    }

    private int generateUniqueId() {
        try {
            return (int)System.currentTimeMillis();
        }
        catch (Throwable e) {
            return 0;
        }
    }
}

