/*
 * Decompiled with CFR 0.152.
 */
package com.appice.libkonywrapper;

import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import com.appice.libkonywrapper.CampaignCampReceiver;
import com.appice.libkonywrapper.FirebaseCustomListener;
import com.konylabs.android.KonyMain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import semusi.context.utility.Utility;

public class Utils {
    private static final String sharedPrefsFile = "AppICEKonyPref";
    public static final String cDataKey = "cdata";
    public static final String RESULT = "result";
    public static final String STATUS = "status";
    public static final int SUCCESS = 0;
    public static final int ERROR = -1;

    public static boolean isPayloadHaveExternalUrl(String messageStr) {
        try {
            if (messageStr != null && messageStr.length() > 0) {
                JSONObject messageObj = new JSONObject(messageStr);
                String type = messageObj.optString("et");
                if (type.equalsIgnoreCase("dl")) {
                    return false;
                }
                if (type.equalsIgnoreCase("lp")) {
                    return true;
                }
            }
        }
        catch (Throwable t) {
            Utility.loginfo((String)("exception in isPayloadHaveExternalUrl " + t));
        }
        return false;
    }

    public static void showAlert(final String title, final String message, final Context context) {
        try {
            AlertDialog.Builder builder = new AlertDialog.Builder(context);
            builder.setTitle((CharSequence)title).setMessage((CharSequence)message).setCancelable(false).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
                    context.startActivity(intent);
                }
            }).setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Utils.showAlert(title, message, context);
                }
            });
            AlertDialog alertDialog = builder.create();
            alertDialog.show();
        }
        catch (Throwable t) {
            Utility.loginfo((String)("exception in showAlert " + t));
        }
    }

    public static boolean isLocationEnabled(Context context) {
        try {
            LocationManager locationManager = (LocationManager)context.getSystemService("location");
            return locationManager.isProviderEnabled("gps") || locationManager.isProviderEnabled("network");
        }
        catch (Throwable t) {
            Utility.loginfo((String)("exception in isLocationEnabled " + t));
            return false;
        }
    }

    public static PendingIntent deletePendingIntent(Context mContext) {
        Intent clickIntent = new Intent(mContext, CampaignCampReceiver.class);
        Bundle bundle = new Bundle();
        bundle.putBoolean("d", true);
        bundle.putBoolean("ai_push", true);
        bundle.putString("type", "HMS");
        clickIntent.putExtras(bundle);
        PendingIntent pendingIntent = Build.VERSION.SDK_INT >= 23 ? PendingIntent.getBroadcast((Context)mContext, (int)123, (Intent)clickIntent, (int)0x4000000) : PendingIntent.getBroadcast((Context)mContext, (int)123, (Intent)clickIntent, (int)0x4000000);
        return pendingIntent;
    }

    public static PendingIntent createPendingIntent(String payload, Context mContext) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("ai_push", true);
        bundle.putString("ai_content", payload);
        return Utils.getActivityPendingIntent(mContext, bundle);
    }

    public static ArrayList<PendingIntent> createNotificationPendingIntentsFromMap(Context context, String messageData, int sdkNotificationId) {
        ArrayList<PendingIntent> pendingIntents = new ArrayList<PendingIntent>();
        try {
            if (messageData != null) {
                JSONObject baseMessageObject = new JSONObject(messageData);
                if (baseMessageObject.has("actions") && baseMessageObject.getJSONArray("actions").length() > 0) {
                    JSONArray actionsArray = baseMessageObject.getJSONArray("actions");
                    int size = actionsArray.length();
                    for (int i = 0; i < size; ++i) {
                        JSONObject actionObject = actionsArray.getJSONObject(i);
                        String actValue = actionObject.optString("act");
                        JSONObject actionMessageObject = new JSONObject(baseMessageObject.toString());
                        actionMessageObject.put("selectedIndex", i);
                        actionMessageObject.put("notificationId", sdkNotificationId);
                        actionMessageObject.put("source", (Object)"appicepushwrapper");
                        HashMap<String, String> actionMap = new HashMap<String, String>();
                        actionMap.put("message", actionMessageObject.toString());
                        PendingIntent pendingIntent = null;
                        if (actValue.equalsIgnoreCase("dl") || actValue.equalsIgnoreCase("cus")) {
                            Bundle bundle = new Bundle();
                            bundle.putBoolean("ai_push_action", true);
                            bundle.putString("ai_action_type", "cus");
                            bundle.putString("actionMap", ((Object)actionMap).toString());
                            bundle.putString("actValue", actValue);
                            bundle.putInt("actionUniqueId", sdkNotificationId);
                            pendingIntent = Utils.getActivityPendingIntent(context, bundle);
                        } else if (actValue.equalsIgnoreCase("rly")) {
                            pendingIntent = Utils.createNotificationPendingIntentForActionWithRemoteInput(context, actionMap, actValue, sdkNotificationId);
                        } else {
                            Log.d((String)"AppICE PushWrapper", (String)(actValue + " Will be handled by SDK"));
                        }
                        pendingIntents.add(pendingIntent);
                    }
                } else {
                    Log.d((String)"AppICE PushWrapper", (String)"AppiceLog No actions found in the message data.");
                }
            } else {
                Log.d((String)"AppICE PushWrapper", (String)"AppiceLog message key not found in the data map.");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return pendingIntents;
    }

    public static PendingIntent createNotificationPendingIntentForActionWithRemoteInput(Context context, Map<String, String> dataMap, String actionId, int requestCode) {
        try {
            ArrayList<String[]> keyValueArrays = Utils.convertMapToKeyValueArrays(dataMap);
            String[] keys = keyValueArrays.get(0);
            String[] values = keyValueArrays.get(1);
            Bundle bundle = new Bundle();
            bundle.putStringArray("push-msg-keys", keys);
            bundle.putStringArray("push-msg-values", values);
            Intent intent = new Intent();
            intent.putExtra("push-notification-msg", bundle);
            String packageName = context.getPackageName();
            intent.setClassName(packageName, KonyMain.getMainActivityClassName());
            intent.putExtra("actionId", actionId);
            int uniqueId = Utility.next();
            intent.putExtra("requestCode", requestCode);
            intent.setPackage(packageName);
            int flags = Utility.getPendingIntentFlags();
            return PendingIntent.getActivity((Context)context, (int)uniqueId, (Intent)intent, (int)flags);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static ArrayList<String[]> convertMapToKeyValueArrays(Map<String, String> map) {
        try {
            String[] keys = map.keySet().toArray(new String[0]);
            String[] values = map.values().toArray(new String[0]);
            ArrayList<String[]> keyValueArrays = new ArrayList<String[]>();
            keyValueArrays.add(keys);
            keyValueArrays.add(values);
            return keyValueArrays;
        }
        catch (Throwable e) {
            ArrayList<String[]> emptyKeyValueArrays = new ArrayList<String[]>();
            emptyKeyValueArrays.add(new String[0]);
            emptyKeyValueArrays.add(new String[0]);
            return emptyKeyValueArrays;
        }
    }

    public static int generatePushMessageNotificationId(Context context) {
        int pushMsgNotificationId = FirebaseCustomListener.loadIntSavedPreferences("pushMsgNotificationId", context);
        if (++pushMsgNotificationId > FirebaseCustomListener.getMaxCount) {
            pushMsgNotificationId = 1;
        }
        return pushMsgNotificationId;
    }

    public static PendingIntent getActivityPendingIntent(Context mContext, Bundle bundle) {
        PackageManager packageManager = mContext.getPackageManager();
        String launcherActivityClassName = "";
        String launcherPackageName = "";
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.setPackage(mContext.getPackageName());
        List activities = packageManager.queryIntentActivities(intent, 0);
        if (!activities.isEmpty()) {
            ResolveInfo launcherActivityInfo = (ResolveInfo)activities.get(0);
            launcherActivityClassName = launcherActivityInfo.activityInfo.name;
            launcherPackageName = launcherActivityInfo.activityInfo.packageName;
            Log.d((String)"LauncherActivity", (String)("Launcher Activity: " + launcherActivityClassName));
            Log.d((String)"LauncherActivity", (String)("Package Name: " + launcherPackageName));
        } else {
            Log.e((String)"LauncherActivity", (String)("No launcher activity found for package: " + mContext.getPackageName()));
        }
        Intent clickIntent = new Intent();
        clickIntent.setClassName(launcherPackageName, launcherActivityClassName);
        clickIntent.setFlags(0x10008000);
        clickIntent.putExtras(bundle);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)mContext, (int)Utility.next(), (Intent)clickIntent, (int)Utility.getPendingIntentFlags());
        return pendingIntent;
    }
}

