
    var Sequelize = require('sequelize');
    require('dotenv').config();


    sequelize = new Sequelize(process.env.citusHostProd,process.env.citusUserProd,process.env.citusDatabaseProd, {
        host: process.env.citusHostProd,
        dialect: "postgres",
        port: process.env.citusPortProd,
        ssl: false,
        dialectOptions: {
            application_name: "appice panel"
        },
        pool: {
            max: 5,
            min: 1,
            acquire: "60000",
            idle: "30000"
        }, 
       retry :{
            match: [
                Sequelize.ConnectionError,
                Sequelize.ConnectionTimedOutError,
                Sequelize.TimeoutError,
                Sequelize.ConnectionAcquireTimeoutError,
                Sequelize.ConnectionRefusedError,
                /Deadlock/i,
                'SQLITE_BUSY'],
            max: 3
        }
    });
    


    // run citus query
 var citusQuery = function(query){
    return new Promise((resolve, reject) =>{
        try{
            console.log("query ",query)
            sequelize.query(query)
              .then(rows => {
                console.log("rows ",rows)
                  //return resolve(rows);
              })
              .catch((error) =>{
                console.log("error ",error)
                  //return reject(error);
              })
        }
        catch(e) {
            console.log("error ",e)
            //return reject(e.message);
        }
    });
}
// this query for example only
citusQuery("select device_lang from app_users_5efc235b22ab3a69da580e69 where did='2C0081A8-6C03-4869-94E0-14188BE28F6C' LIMIT 1;");
