appice.directive('bsSwitch',function($routeParams){
    return{
        restrict:'A',
        scope:{
            state:'=',
        },  
        link:function(scope, element, attrs){
          element.ready(function(){

            element.bootstrapSwitch('state', scope.state);
            element.css("background","#f5f5f5");
            element.on('switchChange.bootstrapSwitch', function (event, state) { 
                if(state){
                  element.bootstrapSwitch('labelText',attrs.offText);
                }
                else{
                  element.bootstrapSwitch('labelText',attrs.onText);
                }

               //scope.onChangefun(state);
                scope.$apply(function() { 
                    scope.$emit(attrs.onswitchchange,state); 
                });

            });

            scope.$watch('state',function(newVal, oldVal){
                if($routeParams.id){
                  if(newVal){
                    element.bootstrapSwitch('labelText',attrs.offText);
                  }
                  else{
                    element.bootstrapSwitch('labelText',attrs.onText);
                  }
                }
                
                element.bootstrapSwitch('state', scope.state);
            });
            
          });
        }
    }
});