(function(semusiCampaigns, $, undefined) {

    //Private Properties
    var _activeAppId = 0,
        _activeAppKey = 0,
        _initialized = false
        _campaignsDb = {};

    //Public Methods
    semusiCampaigns.initialize = function() {
      if (_initialized && _activeAppKey == semusiCommon.ACTIVE_APP_KEY) {
            return semusiCampaigns.refresh();
        }

        if (!semusiCommon.DEBUG) {
            _activeAppKey = semusiCommon.ACTIVE_APP_KEY;
            _initialized = true;

            return $.ajax({
                type:"GET",
                url:semusiCommon.API_PARTS.campaigns.r+"/all",
                data:{
                    "api_key":semusiCommon.getActiveUser.api_key,
                    "app_key":semusiCommon.ACTIVE_APP_KEY,
                     args:JSON.stringify({
                        app_id:semusiCommon.ACTIVE_APP_ID                    
                    })
                },
                success:function (json) {
                    _campaignsDb = json;                   
                }
            });
        } else {
            _campaignsDb = [];
            return true;
        }
    };

    semusiCampaigns.refresh = function() {      
        if (!semusiCommon.DEBUG) {
            _activeAppKey = semusiCommon.ACTIVE_APP_KEY;
            _initialized = true;

            return $.ajax({
                type:"GET",
                url:semusiCommon.API_PARTS.campaigns.r+"/all",
                data:{
                    "api_key":semusiCommon.getActiveUser.api_key,
                    "app_key":semusiCommon.ACTIVE_APP_KEY,
                     args:JSON.stringify({
                        app_id:semusiCommon.ACTIVE_APP_ID                    
                    })
                },
                success:function (json) {
                    _campaignsDb = json;                   
                }
            });
        } else {
            _campaignsDb = [];
            return true;
        }
    };

    semusiCampaigns.getCampaignsData= function()
    {
        return _campaignsDb;
    };

    semusiCampaigns.saveCampaign = function(campaignObj,callback)
    {
      _activeAppKey = semusiCommon.ACTIVE_APP_KEY;
      $.ajax({
                type:"GET",
                url:semusiCommon.API_PARTS.campaigns.w+"/create",
                data:{
                    "api_key":semusiCommon.getActiveUser.api_key,
                    "app_key":semusiCommon.ACTIVE_APP_KEY,
                    "app_id":semusiCommon.ACTIVE_APP_ID,                    
                     args:JSON.stringify(campaignObj)
                },
                success:function (json) {
                     
                     
                    callback();
                }
            });

      return true;
    };

     semusiCampaigns.updateCampaign = function(campaignObj,callback)
    {
      _activeAppKey = semusiCommon.ACTIVE_APP_KEY;
      $.ajax({
                type:"GET",
                url:semusiCommon.API_PARTS.campaigns.w+"/update",
                data:{
                    "api_key":semusiCommon.getActiveUser.api_key,
                    "app_key":semusiCommon.ACTIVE_APP_KEY,
                    "app_id":semusiCommon.ACTIVE_APP_ID,                    
                     args:JSON.stringify(campaignObj)
                },
                success:function (json) {
                     
                     
                    callback();
                }
            });

      return true;
    };

  semusiCampaigns.deleteCampaign = function(campaignid,callback)
    {
      _activeAppKey = semusiCommon.ACTIVE_APP_KEY;
      $.ajax({
                type:"GET",
                url:semusiCommon.API_PARTS.campaigns.w+"/delete",
                data:{
                    "api_key":semusiCommon.getActiveUser.api_key,
                    "app_key":semusiCommon.ACTIVE_APP_KEY,
                    "app_id":semusiCommon.ACTIVE_APP_ID,                    
                     args:JSON.stringify({
                        "app_id":semusiCommon.ACTIVE_APP_ID,  
                        "campaignid":campaignid
                    })
                },
                success:function (json) {
                     
                     
                    callback();
                }
            });

      return true;
    };

    semusiCampaigns.runCampaign = function(campaignid,callback)
    {
      _activeAppKey = semusiCommon.ACTIVE_APP_KEY;
      $.ajax({
                type:"GET",
                url:semusiCommon.API_PARTS.campaigns.w+"/run",
                data:{
                    "api_key":semusiCommon.getActiveUser.api_key,
                    "app_key":semusiCommon.ACTIVE_APP_KEY,
                    "app_id":semusiCommon.ACTIVE_APP_ID,                    
                     args:JSON.stringify({
                        "app_id":semusiCommon.ACTIVE_APP_ID,  
                        "campaignid":campaignid
                    })
                },
                success:function (json) {
                     
                     
                    callback();
                }
            });

      return true;
    };

}(window.semusiCampaigns = window.semusiCampaigns || {}, jQuery));