appice.service('appIceService', function ($http) {

    //////////Funnels///////////
    this.funnelData = {};
    this.isFunnel = false;
    this.JourneyEdited = {};
    this.isJourney = false;
    this.journeyView = {};
    this.isView = false;
    this.tempType ="";
        // generateObjectID in backend
        this.getObjectId = function () {
            return $http({
                method: 'get',
                url: semusiCommon.API_PARTS.metrices.r + '/getObjectId',
                params: {
                     api_key: semusiCommon.getActiveUser.api_key,
                     app_id: semusiCommon.ACTIVE_APP_ID,
                     "uniqueNumber": semusiCommon.randomNumber(),
                }
            })
            .then(function(response) {
                return response.data;
            })
            .catch(function(error) {
            });
        }


    // Journey code 
    this.getJourneysList = function () {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.metrices.r + '/getJourneyList',
            params: {
                 api_key: semusiCommon.getActiveUser.api_key,
                 app_id: semusiCommon.ACTIVE_APP_ID,
                 "uniqueNumber": semusiCommon.randomNumber(),
            }
        })
        .then(function(response) {
            return response.data;
        })
        .catch(function(error) {
             
        });
    }
    this.deleteJourney = function(id) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.metrices.r + '/deleteJourney',
            params: {
              
                 api_key: semusiCommon.getActiveUser.api_key,
                 "uniqueNumber": semusiCommon.randomNumber(),

                id : id,
                 app_id: semusiCommon.ACTIVE_APP_ID,
            }
        })
        .then(function(response) {
            $("#messageboxsucess").text("Journey Successfully Deleted")
            $("#messagesucess").show(); 
            $("#messagesucess").delay(3000).fadeOut(300);
            return response.data;
        })
        .catch(function(error) {
             
        });
    }
    this.getJourneyById = function(id) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.metrices.r + '/getJourney',
            params: {
               
                 api_key: semusiCommon.getActiveUser.api_key,
                 "uniqueNumber": semusiCommon.randomNumber(),

                id : id,
                app_id: semusiCommon.ACTIVE_APP_ID,
            }
        })
        .then(function(response) {
             
            return response.data;
        })
        .catch(function(error) {
             
        });
    }
    this.updateJourney = function(ob) {
         
       
        return $http({
            method: 'post',
            url: semusiCommon.API_PARTS.metrices.r + '/updateJourney',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
            },
            data: {
               
                api_key: semusiCommon.getActiveUser.api_key,
                app_id : semusiCommon.ACTIVE_APP_ID,

                args: angular.toJson(ob)
            },
            headers: {
                'csrf-token': appiceCookies.getCookie('_csrf') 
            }
        })
        .then(function(response) {
            semusiCommon.getCsrfToken();
            return response.data;
        })
        .catch(function(error) {
             
        });
    }
    this.saveJourneyData = function(ob) {
        return $http({
            method: 'post',
            url: semusiCommon.API_PARTS.metrices.r + '/saveJourney',
            params: {
                 api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
            },
            data: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id : semusiCommon.ACTIVE_APP_ID,

                args : ob
            },
            headers: {
                'csrf-token': appiceCookies.getCookie('_csrf') 
            }
        })
        .then(function(response) {
            semusiCommon.getCsrfToken();
            return response.data;
        })
        .catch(function(error) {
             
        });
    }


    this.copyJourney = function(id){
        return $http({
        method: 'get',
        url:  semusiCommon.API_PARTS.metrices.r + '/copyJourney',
        params: {
            api_key: semusiCommon.getActiveUser.api_key,
              app_id: semusiCommon.ACTIVE_APP_ID,
              "uniqueNumber": semusiCommon.randomNumber(),
              id: id,
        }
    })
    .then(function(response) {
        return response;
    })
    .catch(function(error) {
        return error;
    });
    }


    this.setJourneyView = function(journey){
        this.journeyView.journey = this.deepcopy_helper(journey);
        this.isJourney = false;
        this.isView = true;
    }
    this.getJourneyView = function() {
        return this.journeyView.journey;
    }
    this.removeJourneyView = function(){
        this.isView = false;
    }
    this.setJourney = function(journey){
        this.JourneyEdited.journey = this.deepcopy_helper(journey);
        this.isView = false;
        this.isJourney = true;
    }
    this.getJourneyEdited = function() {
        return this.JourneyEdited.journey;
    }
    this.removeJourneyEdited = function() {
        this.isJourney = false;
    }
    //End journey code 
    this.deepcopy_helper = function (src) {
        let target = Array.isArray(src) ? [] : {};
        for (let key in src) {
            let v = src[key];
            if (v) {
                if (typeof v === "object") {
                    target[key] = this.deepcopy_helper(v);
                } else {
                    target[key] = v;
                }
            } else {
                target[key] = v;
            }
        }
        return target;
    }
    this.setFunnel = function (funnel) {
        this.funnelData.funnel = this.deepcopy_helper(funnel);
        this.isFunnel = true;
    }
    this.getFunnel = function () {
        return this.funnelData.funnel;
    }
    this.removeFunnel = function () {
        this.isFunnel = false;
    }

    this.getEventList = function () {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.metrices.r + '/getEventList',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                d: (new Date()).getTime(),
                "uniqueNumber": semusiCommon.randomNumber(),
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.createFunnel = function (data) {
        return $http({
            method: 'post',
            url: semusiCommon.API_PARTS.data.w + '/funnels/create',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                args: angular.toJson(data),
                "uniqueNumber": semusiCommon.randomNumber(),
            },
            data: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
            },
            headers: {
                'csrf-token': appiceCookies.getCookie('_csrf') 
            }
        })
            .then(function (response) {
                semusiCommon.getCsrfToken();
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }
    /**
    * @description Copy funnels By Id
    */
    this.copyFunnel = function (id) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.data.w + '/funnels/copy',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                id: id,
                "uniqueNumber": semusiCommon.randomNumber(),
            }
        })
            .then(function (response) {
                return response;
            })
            .catch(function (error) {
                return error;
            });
    }

    /**
    * @description Get funnels By Id
    */
    this.getFunnelById = function (id) {

        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.data.w + '/funnels/getFunnel',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                id: id,
                "uniqueNumber": semusiCommon.randomNumber(),
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }



    this.updateFunnel = function (data, id) {
        return $http({
            method: 'post',
            url: semusiCommon.API_PARTS.data.w + '/funnels/update',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                id: id,
                args: angular.toJson(data),
                "uniqueNumber": semusiCommon.randomNumber(),
            },
            data: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
            },
            headers: {
                'csrf-token': appiceCookies.getCookie('_csrf') 
            }
        })
            .then(function (response) {
                semusiCommon.getCsrfToken();
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.deleteFunnel = function (id) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.data.w + '/funnels/delete',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                id: id,
                "uniqueNumber": semusiCommon.randomNumber(),
            }
        })
            .then(function (response) {
                $("#messageboxsucess").text("Funnel Successfully Deleted")
                $("#messagesucess").show();
                $("#messagesucess").delay(3000).fadeOut(300);
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }
    
    this.hideDisabledFeature = function (){
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.apps.r + '/getFeaturesSettings',
            params: {
                args: JSON.stringify({
                    app_id: semusiCommon.ACTIVE_APP_ID,
                }),
                app_id: semusiCommon.ACTIVE_APP_ID,
                api_key: semusiCommon.getActiveUser.api_key,
                uniqueNumber : semusiCommon.randomNumber(),
                d: (new Date()).getTime()
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.getEventFunnels = function () {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.data.r + '/funnels/getEventFunnels',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                d: (new Date()).getTime()
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.getEventFunnelStats = function (data, actor_property, platfrom, offset) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.data.r + '/funnels/stats',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                actor_property: actor_property,
                platfrom: platfrom,
                args: angular.toJson(data),
                d: (new Date()).getTime(),
                offset: offset
            }
        })
            .then(function (response) {
                 
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    /**
     * @description Download EventAttribute file
     */
    this.downloadEventAttributeCSV = function (queryString) {
        return $http({
            method: 'get',
            url: queryString,
            
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
                return error;
            });

    }



    this.validateFunnelName = function (funnelName) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.data.r + '/funnels/validateFunnelName',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                funnelName: funnelName
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.validateTemplateName = function (type, template_name) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.templates.w + '/validateTemplateName',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                template_name: template_name,
                type:type
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.getEventAttributeStats = function (eventName, attributeName) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.data.r + '/metrices/getEventAttributeStats',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: JSON.stringify({
                    startDate: semusiCommon.dateRange.currentStartDate,
                    endDate: semusiCommon.dateRange.currentEndDate,
                    startDateNew: semusiCommon.dateRange.currentStartDateNew,
                    endDateNew: semusiCommon.dateRange.currentEndDateNew,
                    eventName: eventName,
                    attributeName: attributeName,
                    startDateNew: semusiCommon.dateRange.currentStartDateNew,
                    endDateNew: semusiCommon.dateRange.currentEndDateNew
                }),
                d: (new Date()).getTime()
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }
    //////////Funnels///////////

    //////////Audience segments///////////
    this.getAttributeValues = function (variableName) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.audienceSegment.r+"/get_metavariables",
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                method: "get_metavariables",
                args: JSON.stringify({
                    variablename: variableName
                }),
                d: (new Date()).getTime()
            }
        })
            .then(function (response) {
                return response.data.result;
            })
            .catch(function (error) {
                 
            });
    }

    //////////get competing apps ///////////
    this.getCompetingApps = function () {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.apps.r + "/getCompetingApps",
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                d: (new Date()).getTime()
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    /// Show competing apps list app wise///

    this.getCompetingAppsAppWise = function (competingAppsIdArr) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.apps.r + "/getCompetingAppsAppWise",
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                apps_arr: competingAppsIdArr,
                d: (new Date()).getTime()
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.getAudienceSegments = function () {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.audienceSegment.r+"/getAudienceSegments",
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                method: "getAudienceSegments",
                "uniqueNumber": semusiCommon.randomNumber(),
                d: (new Date()).getTime()
            }
        })
            .then(function (response) {
                return response.data.result;
            })
            .catch(function (error) {
                 
            });
    }

    this.getAudienceSegmentById = function (id) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.audienceSegment.r+"/getAudienceSegmentById",
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                method: "getAudienceSegmentById",
                "aud_id": id,
                d: (new Date()).getTime()
            }
        })
            .then(function (response) {
                return response.data.result;
            })
            .catch(function (error) {
                 
            });
    }

    this.createAudienceSegment = function (ObjectId,range, name, description, segmentInfo,uploadDetailsObj) {
        var formData = new FormData();

        if (!_.isEmpty(uploadDetailsObj)) {

            formData.append('customUpload', true);
            formData.append('file', uploadDetailsObj.file);
            formData.append('datatype', uploadDetailsObj.datatype);
            formData.append('fileheader', uploadDetailsObj.fileheader);
            formData.append('csvFile_id', uploadDetailsObj.csvFile_id);
            formData.append('audid', uploadDetailsObj.audid)
            formData.append('email', uploadDetailsObj.email)
            formData.append('clientid', uploadDetailsObj.clientid)
            formData.append('did', uploadDetailsObj.did)
        }

        formData.append('objectid', ObjectId);
        formData.append('name', name);
        formData.append('description', description);
        formData.append('range', range);
        formData.append('segmentinfo', JSON.stringify(segmentInfo));
        formData.append('api_key', semusiCommon.getActiveUser.api_key)
        formData.append('app_id', semusiCommon.ACTIVE_APP_ID)
        return $http({
            method: 'POST',
            url: semusiCommon.API_PARTS.audienceSegment.w + '/create',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
            },
            data: formData,
            transformRequest: angular.identity,
            headers: {
                'Content-Type': undefined,
                'csrf-token': appiceCookies.getCookie('_csrf') 
            }
        })
            .then(function (response) {
                semusiCommon.getCsrfToken();
                return response.data;
            })
            .catch(function (error) {
                 return error;
            });
    }

    this.updateAudienceSegment = function (ObjectId,range, name, description, segmentInfo,uploadDetailsObj) {
        var formData = new FormData();

        if (!_.isEmpty(uploadDetailsObj)) {

            formData.append('customUpload', true);
            formData.append('file', uploadDetailsObj.file);
            formData.append('datatype', uploadDetailsObj.datatype);
            formData.append('fileheader', uploadDetailsObj.fileheader);
            formData.append('csvFile_id', uploadDetailsObj.csvFile_id);
            formData.append('audid', uploadDetailsObj.audid)
            formData.append('email', uploadDetailsObj.email)
            formData.append('clientid', uploadDetailsObj.clientid)
            formData.append('did', uploadDetailsObj.did)
        }

        formData.append('objectid', ObjectId);
        formData.append('name', name);
        formData.append('description', description);
        formData.append('range', range);
        formData.append('segmentinfo', JSON.stringify(segmentInfo));
        formData.append('api_key', semusiCommon.getActiveUser.api_key)
        formData.append('app_id', semusiCommon.ACTIVE_APP_ID)
        return $http({
            method: 'POST',
            url: semusiCommon.API_PARTS.audienceSegment.w + '/update',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
            },
            data: formData,
            transformRequest: angular.identity,
            headers: {
                'Content-Type': undefined,
                'csrf-token': appiceCookies.getCookie('_csrf') 
            }
        })
            .then(function (response) {
                semusiCommon.getCsrfToken();
                return response.data;
            })
            .catch(function (error) {
                return error;
            });
    }

    this.deleteAudienceSegment = function (id) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.audienceSegment.w + '/delete',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: JSON.stringify({ _id: id })
            }
        })
            .then(function (response) {
                $("#messageboxsucess").text("Audience Segment Successfully Deleted")
                $("#messagesucess").show();
               $("#messagesucess").delay(3000).fadeOut(300);
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.getAudienceReach = function (criteria,selectors) {
        return $http({
            method: 'post',
            url: semusiCommon.API_PARTS.audienceSegment.r+"/countAudienceReach",
            data: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                "method": "countAudienceReach",
                "criteria": criteria,
                "selectors": selectors,
            },
            headers: {
                'csrf-token': appiceCookies.getCookie('_csrf') 
            }
        })
        .then(function (response) {
            semusiCommon.getCsrfToken();
            return response.data.result;
        })
        .catch(function (error) {
                
        });
    }

    this.getCustomVariables = function (criteria) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.audienceSegment.r+"/get_metacustomvariables",
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                "method": "get_metacustomvariables"
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }
    
    this.getGeoFencing = function () {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.audienceSegment.r+"/getGeoFencing",
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                "method": "getGeoFencing"
            }
        })
        .then(function (response) {
            return response.data;
        })
        .catch(function (error) {
             
        });
    }
    /*delete Geo fence data */
    this.delGeoFencing = function (geoId) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.audienceSegment.r+"/delGeoFencing",
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                "geo_id": geoId,
                "method": "delGeoFencing"
            }
        })
        .then(function (response) {
            return response.data;
        })
        .catch(function (error) {
             
        });
    }

    /*save Geo fence data */
    this.saveGeoFencing = function (obj) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.audienceSegment.r+"/saveGeoFencing",
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                "method": "saveGeoFencing",
                "args": obj
            }
        })
        .then(function (response) {
            return response.data.result;
        })
        .catch(function (error) {
             
        });
    }
    
    /**
     * Get Segment validation information From server
     * @Author Manish Yadav
     **/
    this.validateSegmentName = function (segmentName) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.audienceSegment.r+"/validateSegmentName",
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                "segmentName": segmentName,
                "method": "validateSegmentName"
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    //////////Audience segments///////////

    //////App Modules /////////
    this.getGlobalAppModules = function (criteria) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.apps.r + '/getGlobalAppModules',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "uniqueNumber": semusiCommon.randomNumber(),
                "app_id": semusiCommon.ACTIVE_APP_ID,
                d: (new Date()).getTime()
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.saveModule = function (module) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.apps.w + '/saveModule',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "uniqueNumber": semusiCommon.randomNumber(),
                "app_id": semusiCommon.ACTIVE_APP_ID,
                args: JSON.stringify(module)
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.updateModule = function (module, id) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.apps.w + '/updateModule',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "uniqueNumber": semusiCommon.randomNumber(),
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "id": id,
                args: module
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.deleteModule = function (id) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.apps.w + '/deleteModule',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "uniqueNumber": semusiCommon.randomNumber(),
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "id": id,
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.getAppModules = function () {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.apps.r + '/getAppModules',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "uniqueNumber": semusiCommon.randomNumber(),
                "app_id": semusiCommon.ACTIVE_APP_ID,
                d: (new Date()).getTime()
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.saveAppModules = function (modules, app_id) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.apps.w + '/saveAppModules',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "uniqueNumber": semusiCommon.randomNumber(),
                "app_id": app_id,
                args: JSON.stringify(modules)
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }
    //////App Modules /////////



    //////Other App Groups//////////
    this.getOtherAppGroups = function (criteria) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.apps.r + '/getOtherAppGroups',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                d: (new Date()).getTime()
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.saveOtherAppGroup = function (group) {
        return $http({
            method: 'POST',
            url: semusiCommon.API_PARTS.apps.w + '/saveOtherAppGroup',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: JSON.stringify(group)
            },
            data: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID
            },
            headers: {
                'csrf-token': appiceCookies.getCookie('_csrf') 
            }
        })
            .then(function (response) {
                semusiCommon.getCsrfToken();
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.updateOtherAppGroup = function (group, id) {
        return $http({
            method: 'POST',
            url: semusiCommon.API_PARTS.apps.w + '/updateOtherAppGroup',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                "id": id,
                args: JSON.stringify(group)
            },
            data: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID
            },
            headers: {
                'csrf-token': appiceCookies.getCookie('_csrf') 
            }
        })
            .then(function (response) {
                semusiCommon.getCsrfToken();
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.deleteOtherAppGroup = function (id) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.apps.w + '/deleteOtherAppGroup',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                "id": id
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.addAppToGroup = function (app, id) {
        return $http({
            method: 'POST',
            url: semusiCommon.API_PARTS.apps.w + '/addAppToGroup',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                "id": id,
                args: JSON.stringify(app)
            },
            data: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
            },
            headers: {
                'csrf-token': appiceCookies.getCookie('_csrf') 
            }
        })
            .then(function (response) {
                semusiCommon.getCsrfToken();
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.updateAppToGroup = function (app, groupid) {
        return $http({
            method: 'POST',
            url: semusiCommon.API_PARTS.apps.w + '/updateAppToGroup',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                "id": groupid,
                args: JSON.stringify(app)
            },
            data: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID
            },
            headers: {
                'csrf-token': appiceCookies.getCookie('_csrf') 
            }
        })
            .then(function (response) {
                semusiCommon.getCsrfToken();
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.deleteAppFromGroup = function (_id, groupid) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.apps.w + '/deleteAppFromGroup',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                "id": groupid,
                "_id": _id
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    //////Other App Groups//////////
    // Competing Apps and Main App get data of average session starts///
    this.getAppsAverageSession = function (competingAppsIdArr) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.apps.w + '/getAppsAverageSession',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                "args": JSON.stringify({
                    startDate_C: semusiCommon.dateRange.currentStartDate,
                    endDate_C: semusiCommon.dateRange.currentEndDate,
                    startDate_P: semusiCommon.dateRange.previousStartDate,
                    endDate_P: semusiCommon.dateRange.previousEndDate,
                    competingAppsIdArr: competingAppsIdArr
                }),
                d: (new Date()).getTime()
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }
    // Competing Apps and Main App get data of average session end///
    ///////////Manage child apps///////////

    this.getChildApps = function (criteria) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.apps.r + '/getChildApps',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                d: (new Date()).getTime()
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.getAppDetails = function (criteria) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.apps.r + '/getAppDetails',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                d: (new Date()).getTime()
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.saveChildApp = function (childApp) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.apps.w + '/saveChildApp',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: JSON.stringify(childApp)
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.updateChildApp = function (childApp, id) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.apps.w + '/updateChildApp',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                "id": id,
                args: JSON.stringify(childApp)
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.deleteChildApp = function (id) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.apps.w + '/deleteChildApp',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                "id": id
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.updateLinkingField = function (linkingField) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.apps.w + '/updateLinkingField',
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "uniqueNumber": semusiCommon.randomNumber(),
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "linkingField": linkingField
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    ///////////Manage child apps///////////

    /////////// Manage App user information ///////////
    /**
     * get app users information
     * @Author Manish Yadav
     **/
    this.getAppUsers = function (type, platform) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.users.r + "/getAppUsers",
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                "type": type,
                "platform": platform
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    /**
     * @author Pranay P.
     * @params {*}
     * @description this is the api wich will call the main business logic written in metrices.js and will bet called in controller function of front end
     */
    this.getDauWauMauWithPlatform = function (dateArgs) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.metrices.r + '/getDauWauMauWithPlatform',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: dateArgs
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
                return false;
            })
    }


    /**
     * get app user details
     * @Author Manish Yadav
     **/
    this.getUserDetails = function (did) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.users.r + "/getUserDetails",
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                "did": did,
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    /**
     * get app user recent activity
     * @Author Manish Yadav
     **/
    this.getUserRecentActivity = function (did) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.users.r + "/getUserRecentActivity",
            params: {
                "api_key": semusiCommon.getActiveUser.api_key,
                "app_id": semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                "did": did
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    /////////// END Manage App user information ///////////

    //////////// Start campagin code //////////////////////
    this.getAppTemplatesByType = function (type) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.templates.r + '/getTemplatesByType',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                template_type: type
            }
        }).then(function (response) {
            return response.data;
        })
            .catch(function (error) {
                 
            });
    }

    this.getShortUrls = function () {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.templates.r + '/getShortUrls',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
            }
        }).then(function (response) {
            return response.data;
        })
            .catch(function (error) {
                 
            });
    }
    
    this.getPushCharLimit = function () {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.apps.r + '/getPushCharLimit',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
            }
        }).then(function (response) {
            // console.log("response", response)
            return response.data;
        })
            .catch(function (error) {
                 
            });
    }

    this.getAllAppTemplates = function (type) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.templates.r + '/getAllAppTemplates',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                template_type: type
            }
        }).then(function (response) {
            return response.data;
        })
            .catch(function (error) {
            });
    }
    //Get template by templateId///
    this.getAppTemplatesById = function (templateId) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.templates.r + '/getTemplatesById',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                template_id: templateId
            }
        }).then(function (response) {
            return response.data;
        })
            .catch(function (error) {
                 
            });
    }
    /// campaign image uploading on S3 ///
    this.uploadCampaignImage = function (fd) {
        return $http.post('campaignFiles/campaignimages', fd, {
            transformRequest: angular.identity,
            headers: { 'Content-Type': undefined, 'csrf-token': appiceCookies.getCookie('_csrf') }
        }).then(function (response) {
            semusiCommon.getCsrfToken();
            return response.data;
        })
            .catch(function (error) {
                 
            });
    }



    this.saveSettingsTools = function (data) {
        return $http({
            method: 'post',
            url: semusiCommon.API_PARTS.templates.w + '/create',
            data: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                args: angular.toJson(data),
                "uniqueNumber": semusiCommon.randomNumber(),
            },
            headers: {
                'csrf-token': appiceCookies.getCookie('_csrf')
            }
        })
            .then(function (response) {
                semusiCommon.getCsrfToken();
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.getIEmailEditor = function () {
        return $http({
            method: 'post',
            url: semusiCommon.API_PARTS.templates.w + '/getIEmailEditor',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
            },
            data: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
            },
            headers: {
                'csrf-token': appiceCookies.getCookie('_csrf')
            }
        })
            .then(function (response) {
                semusiCommon.getCsrfToken();
                return JSON.parse(response.data);
            })
            .catch(function (error) {
                 
            });
    }

    this.getRequestId  = function(searchQuery) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.templates.r + '/getRequestId',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                requestId: searchQuery,
                "uniqueNumber": semusiCommon.randomNumber(),
            }
        })
        .then(data=>{
            return data;
        }).catch(error=>{
             
        })
    }

    this.getCampaignStatsDateWise = function (params) {
        return $http({
            method: 'get',
            url:semusiCommon.API_PARTS.templates.r + '/getCampaignStatsDateWise',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                startDate : params.startDate,
                endDate : params.endDate,
                cid: params.camp_id.toString()
        }
        }).then(function(response) {
            return response;
        })
        .catch(function(error) {
             
        });
    }

    ///Get Audience segment data///
    this.getCampaignById = function (cid, data) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.templates.r + '/getCampaignById',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                cid: cid,
                args: angular.toJson(data)
            }
        }).then(function (response) {
            return response.data;
        })
            .catch(function (error) {
                 
            });
    }
    ///Create campaign///
    this.createCampaign = function (data) {
        return $http({
            method: 'post',
            url: semusiCommon.API_PARTS.templates.w + '/createCampaign',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: angular.toJson(data)
            },
            data: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID
            },
            headers: {
                'csrf-token': appiceCookies.getCookie('_csrf')
            }
        })
            .then(function (response) {
                semusiCommon.getCsrfToken();
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    ///Update template setting tools by template Id///
    this.updateTemplateSettingsTools = function (id, data) {
        return $http({
            method: 'post',
            url: semusiCommon.API_PARTS.templates.w + '/update',
            // params: {
            //     api_key: semusiCommon.getActiveUser.api_key,
            //     app_id: semusiCommon.ACTIVE_APP_ID,
            //     template_id: id,
            //     args:angular.toJson(data)
            // }
            data: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                template_id: id,
                args: angular.toJson(data)
            },
            headers: {
                'csrf-token': appiceCookies.getCookie('_csrf')
            }
        })
            .then(function (response) {
                semusiCommon.getCsrfToken();
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    ///Update campaign by campaign Id///
    this.updateCampaign = function (id, data) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.templates.w + '/updateCampaign',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                cid: id,
                args: angular.toJson(data)
            },
            d: (new Date()).getTime()
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                return error
            });
    }


    /// Save InApp Data Service///
    this.saveInAppSettings = function (data) {
        return $http({
            method: 'post',
            url: semusiCommon.API_PARTS.templates.w + '/create',
            data: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: angular.toJson(data)
            },
            headers: {
                'csrf-token': appiceCookies.getCookie('_csrf')
            }
        })
            .then(function (response) {
                semusiCommon.getCsrfToken();
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    // function for updating the inapp template//
    this.updateInAppSettingsTools = function (id, data) {
        return $http({
            method: 'post',
            url: semusiCommon.API_PARTS.templates.w + '/update',
            data: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                template_id: id,
                args: angular.toJson(data)
            },
            headers: {
                'csrf-token': appiceCookies.getCookie('_csrf')
            }
        })
            .then(function (response) {
                semusiCommon.getCsrfToken();
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }
    ///////////Manage child apps///////////

    // campaign survey
    this.createSurvey = function (data) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.templates.w + '/create',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: angular.toJson(data)
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    // update survey
    this.updateSurvey = function (data, _id) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.templates.w + '/update',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                template_id: _id,
                args: angular.toJson(data)
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    // campaign rating
    this.createRating = function (data) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.templates.w + '/create',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: angular.toJson(data)
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    // update survey
    this.updateRating = function (data, _id) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.templates.w + '/update',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                template_id: _id,
                args: angular.toJson(data)
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    // create new chatbot setup
    this.createChatbot = function (data) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.apps.w + '/createChatBot',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: JSON.stringify({
                    name: data.name,
                    platforms: data.platforms
                })
            },
            data: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID
            },
            headers: {
                'csrf-token': appiceCookies.getCookie('_csrf')
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    // get chat bot session information
    this.getChatBotSession = function (app_id, args) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.metrices.r + '/getChatBotSession',
            params: {
                app_id: semusiCommon.ACTIVE_APP_ID,
                api_key: semusiCommon.getActiveUser.api_key,
                "uniqueNumber": semusiCommon.randomNumber(),
                app_id: app_id,
                args: args
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    // get chat bot session information
    this.getChatBotEvents = function (app_id, args) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.metrices.r + '/getEventsStats',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                app_id: app_id,
                isChat: true,
                args: args
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    this.getEventsStats = function (dates) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.metrices.r + '/getEventsStats',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: JSON.stringify(dates)
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    // get chat bot session information
    this.getChatBotCohort = function (app_id, args) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.metrices.r + '/getChatBotCohort',
            params: {
                args: args,
                api_key: semusiCommon.getActiveUser.api_key,
                "uniqueNumber": semusiCommon.randomNumber(),
                app_id: app_id,
                actor_property: 'user_id'
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    //To Get Journey Event Data 

    this.getJourneyEventData = function (dates) {
         
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.metrices.r + '/getJourneyEventData',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: JSON.stringify(dates)
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }


    // get campaign details
    this.getCampaignDetails = function (campid, type) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.templates.w + '/getCampaignDetails',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                campid: campid,
                type: type,
                offset: semusiCommon.addOffset(0)
                /*args    :JSON.stringify({
                            startDate : semusiCommon.dateRange.currentStartDate,
                            endDate : semusiCommon.dateRange.currentEndDate,
                            offset : semusiCommon.addOffset(0)
                        })*/
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }

    // get explore data
    this.getEventExploreData = function (explore) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.metrices.r + '/getEventExploreData',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: JSON.stringify(explore)
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
                return false;
            });
    }

    // get event schema details
    this.getEventSchema = function (event) {
        return $http({
            method: 'GET',
            url: semusiCommon.API_PARTS.metrices.r + '/getEventSchema',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                eventName: event
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
                return false;
            });
    }

    // get tables
    this.getTables = function () {
        return $http({
            method: 'GET',
            url: semusiCommon.API_PARTS.metrices.r + '/getTables',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
                return false;
            });
    }

    // get raw data
    this.getEventRawData = function (explore) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.metrices.r + '/getEventRawData',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: JSON.stringify(explore)
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
                return false;
            });
    }

    // get explore data
    this.getDauWauMau = function (dateArgs) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.metrices.r + '/getDauWauMau',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: dateArgs
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
                return false;
            });
    }

    // get current screenshot users details
    this.getCurrentScreeshotUsers = function (dateArgs) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.screenshot.r + '/currentUsers',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: dateArgs
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
                return false;
            });
    }


    // get users session details
    this.getScreenshotUserSession = function (id) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.data.r + '/userSession',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: {
                    id: id
                }
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
                return false;
            });
    }


    // get active users sessions stats
    this.getActiveUserSessionStats = function (dates, platfrom) {
        return $http({
            method: 'GET',
            url: semusiCommon.API_PARTS.metrices.r + '/getActiveUserSessionStats',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                platfrom: platfrom,
                args: JSON.stringify(dates)
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
                return false;
            });
    }

    // get active users sessions
    this.getActiveUserTimelySessions = function (dates) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.metrices.r + '/getActiveUserTimelySessions',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: JSON.stringify(dates)
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
                return false;
            });
    }

    // submit screen playback audience
    this.getScreenPlaybackSettings = function () {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.screenshot.r + '/getScreenPlaybackSettings',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
                return error;
            });
    }

    // submit screen playback audience
    this.saveScreenPlaybackSetting = function (audience) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.screenshot.w + '/saveScreenPlaybackSetting',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: JSON.stringify(audience)
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
                return error;
            });
    }

    // submit screen playback audience
    this.deleteScreenPlaybackSetting = function (id) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.screenshot.w + '/deleteScreenPlaybackSetting',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: JSON.stringify({ id: id })
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
                return error;
            });
    }

    // submit screen playback audience
    this.changeScreenPlaybackSetting = function (id, st) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.screenshot.w + '/changeScreenPlaybackSetting',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: JSON.stringify({ id: id, st: st })
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
                return error;
            });
    }


    // Download Event CSV File
    this.downloadEventCSV = function (queringString) {
        return $http({
            method: 'get',
            url: queringString,
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
                return error;
            });
    }

    // Download Journey CSV File
    this.downloadJourneyCsv = function (queringString) {
        return $http({
            method: 'get',
            url: queringString,
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
                return error;
            });
    }

    this.getdisplayPreference = function () {
        return $http({
            method: 'get',
            url: window.location.origin + '/getDisplayPref',
        })
            .then((response) => {
                return response
            })
            .catch((err) => {
                 
            });
    }

    this.updateDisplayPreference = function (data) {
        return $http.patch(window.location.origin + '/updateDisplayPref', { prefData: data }, {
        }).then(function (response) {
            return response;
        })
            .catch(function (error) {
                 
            });
    }

    this.saveVariant = function (data) {
        return $http({
            method: 'POST',
            url: semusiCommon.API_PARTS.templates.w + '/saveVariant',
            data: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: angular.toJson(data)
            },
            headers: {
                'csrf-token': appiceCookies.getCookie('_csrf')
            }
        })
        .then(function (response) {
            semusiCommon.getCsrfToken();
            return response;
        })
        .catch(function (error) {
             
        });
    }
    this.getTemplateMetaData = function () {
        return $http({
            method: 'POST',
            url: semusiCommon.API_PARTS.templates.w + '/getTemplateMetaData',
            data: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args:{}
            }
        })
        .then(function (response) {
            semusiCommon.getCsrfToken();
            return response;
        })
        .catch(function (error) {
             
        });
    }
    /* get downloaded CSV from mongo with status */
    this.getCsvList = function () {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.data.r + '/csv/getList',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                d: (new Date()).getTime()
            }
        })
        .then(function (response) {
            return response.data;
        })
        .catch(function (error) {
                
        });
    }
    /* delete csv */

    this.deleteCsv = function (id) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.data.w + '/csv/delete',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                id: id
            }
        })
            .then(function (response) {
                return response.data;
            })
            .catch(function (error) {
                 
            });
    }
    /* get downloaded CSV from mongo with status */
    this.startExports = function (q) {
        return $http({
            method: 'get',
            url: semusiCommon.API_PARTS.data.w + '/startExports',
            params: {
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                "uniqueNumber": semusiCommon.randomNumber(),
                args: q,
            }
        }).then(function (response) {
            return response.data;
        })
        .catch(function (error) {
             
        });
    }
});
