appice.controller('templatesController',function ($scope,appIceService,$routeParams,$location, $timeout, $window) {
    
    init();

    function init(){

        getAppTemplates();

    }
    // this function generates the templates
    function getAppTemplates(){
        var type = appIceService.tempType;
        appIceService.getAllAppTemplates(type).then(function(data){
            if(data.result.length > 0){

                 $('#overlay').hide();
                        $('#tblTemplates').dataTable({
                            "order": [],
                            'bAutoWidth': false ,
                            "bProcessing": true,
                            "dom":' <"search"f><"top"l>rt<"bottom"ip><"clear">', // Allign Search
                            bDestroy:true,
                            "aaData": data.result,// <-- Data source
                            "fnDrawCallback": function( oSettings ) {
                                $(".deleteTemplate").click(function(){
                                    var template_id = $(this).val();
                                  deleteTemplate(template_id);
                                });
               // CODE TO BE IMPLEMENTED LATER FOR COPY AND EDIT FUNCTIONALITY 
                                // $(".copyTemplate").click(function(){
                                //     var template_id = $(this).val();
                                //     copyTemplate(template_id);
                                // });
                                // $(".editTemplate").click(function(){
                                //     var template_id = $(this).val();
                                //      editTemplate(template_id);
                                // });
                              },
                            "aoColumns": [
                                { "mData": 'template_type',
                                "sWidth": '25%'  
                                 },
                                {
                                  "mData": 'template_name',
                                  "sWidth": '50%',
                                  "defaultContent": ""
                                }
                              ],
                      
                                "aoColumnDefs":  [{
                                    "aTargets": [2],
                                    "orderable": false,
                                    "mData": "st",
                                    "mRender": function (data, type, full) {

                     //  CODE FOR ALL THREE EDIT  COPY AND DELTE
                                    //   return "<button id='" + full._id + "' type='button'style='background: #49b6d6; border-color: #49b6d6 !important' class='copyTemplate copybtn btn btn-primary editable-submit m-r-5 m-b-5' value='"+full._id +"' ><i class='fa fa-copy'></i>"
                                    //     +
                                    //     "<button id='" + full._id + "' type='button' class='editTemplate btn btn-primary  editable-submit m-r-5 m-b-5' title='Edit'  value='"+full._id +"' ><i class='fa fa-edit'></i>"
                                    //     +
                                    //     "<button type='button' class='deleteTemplate btn btn-danger editable-submit m-r-5 m-b-5' title='Delete' id='" + full._id + "'  value='"+full._id +"'><i class='fa fa-minus'></i>"
                          
                                  return "<button type='button' class='deleteTemplate btn btn-danger editable-submit m-r-5 m-b-5' title='Delete' id='" + full._id + "'  value='"+full._id +"'><i class='fa fa-minus'></i>"

                                    }
                                  }]
                          
                        });
            }
        })
        
    }

// function for deleting templates 
deleteTemplate =  function(id){
    if(confirm("Are you sure you want to delete this Template.?")) {
        $.ajax({
            type:"GET",
            url:semusiCommon.API_PARTS.templates.w + '/deleteTemplate',
            data:{
                args:JSON.stringify({
                    isTemplateDeleted:true,
                    ud:semusiCommon.getCurrentEpoch(),
                    t_id: id,
                }),
                api_key: semusiCommon.getActiveUser.api_key,
                app_id: semusiCommon.ACTIVE_APP_ID,
                uniqueNumber : semusiCommon.randomNumber(),
            },
            success:function (data) {
                $("#messageboxsucess").text("Template Successfully Deleted")
                $("#messagesucess").show();
                $("#messagesucess").delay(3000).fadeOut(300);
                getAppTemplates();
                // Updating token before Requesting again on the same page
                semusiCommon.getCsrfToken();
            }
        });
    }
 }

})
