appice.controller("displayPref", function($scope, appIceService) {
  $scope.init = function() {
    var promise = appIceService.getdisplayPreference();
    promise.then(function(response) {
      $scope.data = response.data.data;
    });
  };

  $scope.showList = function(node) {
    node.expand = !node.expand;
  };

  $scope.updatePref = function(){
    appIceService.updateDisplayPreference($scope.data)
    .then(response=>{
      if(response.data.status === true){
        $("#messageboxsucess").text("Preference Changed Successfully")
        $("#messagesucess").show();
      }
      else{
        $("#messagebox").text("Something went wrong! Please try again");
        $("#message").show();
      }
    })
  }

  $scope.treeOptions = {
    accept: function(sourceNodeScope, destNodesScope, destIndex) {
      var srctype = sourceNodeScope.$element.attr("parent-data");
      var dsttype = destNodesScope.$element.attr("parent-data");
      if (srctype === dsttype && srctype !== undefined) {
        return true;
      } else {
        return false;
      }
    }
  };
  $scope.init();


});
