appice.controller('screenshotController', function($scope, appIceService, $routeParams, $compile, $route, $timeout) {
  
  // Deleting Screenshot session
  $scope.deleteAction = function(id, st) {
    // check playback setting
    if(st === "true"){
        // stop active palyback setting
        $scope.changeScreenPlaybackSetting(id, st, true);
    }
    // delete screen playback setting
    var promise = appIceService.deleteScreenPlaybackSetting(id);
    promise.then(function(data) {
      if (data) {
        $scope.getScreenPlaybackSettings();
      } else {
         
      }
    });
  }
  $scope.changeScreenPlaybackSetting = function(id, st, isDeletedCall) {
    st = !JSON.parse(st);
    // change playback setting based on st (active/stop)
    var promise = appIceService.changeScreenPlaybackSetting(id, st);
    promise.then(function(data) {
      if(data) {
        if(!isDeletedCall){
          $scope.getScreenPlaybackSettings();
        }
      }
      else {
         
      }
    })
  }

  // Getting Current Session
  $scope.getScreenPlaybackSettings = function() {
    var promise = appIceService.getScreenPlaybackSettings();
    promise.then(function(data) {
        if (data) {
            $('#playbackSetting').dataTable({
              "order": [],
              'bAutoWidth': false,
              "bProcessing": true,
              "dom": ' <"search"f><"top"l>rt<"bottom"ip><"clear">', // Allign Search
              bDestroy: true,
              "aaData": data,
              "aoColumns": [{
                  "mData": 'name'
                },
                {
                  "mData": 'createdAt',
                  "mRender": function ( data, type, full ) {
                      return '<label value="'+ data +'">'+semusiCommon.getDateFromEpoch( semusiCommon.addOffset(data) )+'</label>';
                  }
                }
              ],
              "aoColumnDefs": [{
                "aTargets": [2],
                "orderable": true,
                "mData": "createdAt",
                "mRender": function(data, type, full) {
                  var button = "<button type='button' class='btn btn-success changeStatus m-r-5 m-b-5' id='" + full._id + "' name='"+ full.st +"' title='" + full.name + "' ><i class='fa fa-check'></i></button>";
                  if(full.st){
                    button = "<button type='button' class='btn btn-success changeStatus m-r-5 m-b-5' id='" + full._id + "' name='"+ full.st +"' title='" + full.name + "' ><i class='fa fa-stop'></i></button>";
                  }
                  return button + "<button type='button' class='btn btn-danger delete m-r-5 m-b-5' id='" + full._id + "' name='"+ full.st +"' title='" + full.name + "' ><i class='fa fa-trash-o'></i></button>";
                }
              }]
            });
            
            $('.delete').bind('click', function() {
                var $this = $(this);
                var msg = "You want to delete " + $this.attr('title')+ " playback setting";
                if($this.attr('name') === "true"){
                  msg = "You want to stop and delete " + $this.attr('title')+ " playback setting";
                }
                swal({
                    title: "Are you sure?",
                    text: msg,
                    type: "error",
                    showCancelButton: !0,
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Delete"
                },
                function(isConfirm){
                    if (isConfirm){
                        angular.element('#' + $this.attr('id')).scope().deleteAction( $this.attr('id'), $this.attr('name'));
                    }
                });
            });

            $('.changeStatus').bind('click', function() {
                var status = "Stop", $this = $(this);
                if($this.attr('name') === "false"){
                  status = "Active"
                }

                swal({
                    title: "Are you sure?",
                    text: "You want to " +status.toLowerCase() +" "+ $this.attr('title')+ " playback setting",
                    type: "info",
                    showCancelButton: !0,
                    confirmButtonClass: "btn-info",
                    confirmButtonText: status
                },function(isConfirm){
                  if (isConfirm){
                      angular.element('#' + $this.attr('id')).scope().changeScreenPlaybackSetting($this.attr('id'), $this.attr('name'), false);
                  }
                });
            });
        }
    });
  }

  $scope.getScreenPlaybackSettings();

});
