appice.controller('rawDataController',function ($scope, $timeout, appIceService) {
	$scope.action = 'Submit';
	$scope.isRun = false;
	$scope.explore = {};
	$scope.eventList = [];
	$scope.eventSchema = [];
	$scope.clumCount = 1;
	$scope.areEvents = false;
	// getting events
	$scope.getEvents = function(){
		var promise = appIceService.getEventList();
		promise.then(function(events) {
        	$scope.eventList = events.data;
					 
    	});
	}
	//$scope.getEvents();

	// getting tables
	$scope.getTables = function() {
		var promise = appIceService.getTables();
		promise.then(function(tables) {
			$scope.tables = tables;
			 
		});
	}
	$scope.getTables();
	// getting event Schema
	$scope.getEventSchema = function(table){
		$scope.clumCount = 1;
		$scope.isRun = false;
		if(!$('#'+table).is(":visible")){
				var promise = appIceService.getEventSchema(table);
				promise.then(function(eventsSchema) {
					$scope.isRun = true;
					$scope.eventSchema = eventsSchema;
					});
		}
	}

	$scope.closeModel = function(){
			$('.columns').hide();
			$scope.eventSchema = [];
	}

	$scope.manageEvent = function(table) {
		if($('#'+table).is(":visible")){
				$('.'+table).text('Show Column');
				$('.columns').hide();
		}
		else{
				$('.columns').hide();
				$('#'+table).show();
				$('.'+table).text('Hide Column');
		}
	}
	// getting column action
	// $scope.columnAction = function(index){
	// 	$scope.eventSchema[index].selected = ($scope.eventSchema[index].selected)? false : true;
	// 	return;
	// }

	$scope.execute = function(){
		if($scope.explore.query) {
			$scope.isRun = true;
		}
		$scope.isError = false;
		$scope.error = "";

		/*
		$scope.eventSchema.forEach(function(select){
			if(select.selected){
				$scope.explore.selectedSchema.push(select.name);
			}
		});
		*/
		// put all schema column if not selected
	/*	if($scope.explore.selectedSchema.length == 0 ){
			$scope.eventSchema.forEach(function(select){
				$scope.explore.selectedSchema.push(select.name);
			});
		}

		if($scope.explore.event == undefined || $scope.explore.event == ''){
			$scope.isError = true;
			$scope.error = "Please select table";
			return false;
		}

		if($scope.explore.startDate == undefined || $scope.explore.startDate == ''){
			$scope.isError = true;
			$scope.error = "Please select start date";
			return false;
		}

		if($scope.explore.endDate == undefined || $scope.explore.endDate == ''){
			$scope.isError = true;
			$scope.error = "Please select end date";
			return false;
		}
		*/
		// change date to epoch
		//$scope.explore.startDate = parseInt(moment.utc($scope.explore.startDate, "DD-MM-YYYY").startOf('day').valueOf()/1000);
		//$scope.explore.endDate = parseInt(moment.utc($scope.explore.endDate, "DD-MM-YYYY").endOf('day').valueOf()/1000);

		if($scope.isRun){
			$('#exploreData').html('');
			$scope.isRun = false;
			$scope.action = "Searching.....";
			var promise = appIceService.getEventRawData($scope.explore);
			promise.then(function(exploreData) {
				$scope.isRun = true;
				$scope.action = "Submit";
				if(exploreData && exploreData.length > 0){
					$scope.isDownload = true;
					$scope.dataObj = JSON.stringify(exploreData);
					//$scope.dataObj['data'] = JSON.stringify(exploreData);
					$('#exploreData').jsonView($scope.dataObj);
				}
				else{
					$scope.dataObj = {};
					$scope.dataObj['error'] = "Data not found!"
					$('#exploreData').jsonView($scope.dataObj);
				}
		   	}, function(){
		   		$scope.isDownload = false;
		   		$scope.isRun = true;
				$scope.action = "Submit";
		   	});
		}
	}

	$scope.download = function(){
		var dataStr = "data:text/json;charset=utf-8," + encodeURIComponent(JSON.stringify($scope.dataObj));
		var dlAnchorElem = document.getElementById('downloadAnchorElem');
		dlAnchorElem.setAttribute("href",     dataStr     );
		dlAnchorElem.setAttribute("download", "raw-data"+moment.utc().valueOf()+".json");
		//dlAnchorElem.click();
	}

	$timeout(function(){
		$(".event_lists").select2();
		$(".start_time_list").select2();
		$(".end_time_list").select2();
		$('#start_date').datepicker({
		      todayHighlight: true
		});
		$('#end_date').datepicker({
		      todayHighlight: true
		});
    }, 200);
});
