appice.controller('newScreenshotSettingController', function ($scope, appIceService, $routeParams, $window) {
  $scope.audienceSegment = {}
  // select audience segment
  $scope.audienceSegmentId = '';
  $scope.selectAudienceSegment = function(index, id, name){
    if($scope.audienceSegments[index]._id == id){
        $scope.audienceSegment = {
          audid: id,
          name: name
        };
      }
      else{
          $scope.audienceSegment = {};
      }
  }

  // Get Audience Segment listing ////
  $scope.audienceSegments = [];
  $scope.getAudienceSegments =  function(){
      var promise = appIceService.getAudienceSegments();
      promise.then(function(audienceSegments){
          if(audienceSegments){
            $scope.audienceSegments = audienceSegments;
              if( $scope.audienceSegment.audid == undefined || $scope.audienceSegment.audid == '' ){
                  // default select all aud segments
                  $scope.audienceSegments.forEach(function(value){
                      if(value.name == 'All Audience'){
                          $scope.audienceSegment = {
                            audid: value._id,
                            name: value.name
                          };
                          return false;
                      }
                  });
              }
          }
      });
  }

  $scope.getAudienceSegments();

  $scope.submit = function(){
     
    if($scope.audienceSegment.audid && $scope.audienceSegment.name){
        var promise = appIceService.saveScreenPlaybackSetting($scope.audienceSegment);
        promise.then(function(response){
            $window.location.href = appiceEncode.encodePayload('dashboard?action=sessionSetting#/screenshotSettings');
        })
        .catch(function(error){
        });
    }
  }

  $scope.cancel = function(){
      $window.location.href = appiceEncode.encodePayload('dashboard?action=sessionSetting#/screenshotSettings');
  }

});
