appice.controller('insidesController',function ($scope,appIceService,$routeParams,$location) {
    var initDateRange = function(){
        semusiCommon.setDateRange(null,null);

        $('#advance-daterange span').html(moment().subtract('days', 29).format(semusiCommon.getDateFormatt()) + ' - ' + moment().format(semusiCommon.getDateFormatt()));
        
        var _period = [moment(semusiCommon.dateRange.currentStartDate*1000).format(semusiCommon.getDateFormatt()),moment(semusiCommon.dateRange.currentEndDate*1000).format(semusiCommon.getDateFormatt())];
        semusiCommon.setPeriod(_period);

        $('#advance-daterange').daterangepicker({
            format: semusiCommon.getDateFormatt(),
            startDate: moment().subtract(29, 'days'),
            endDate: moment(),
            minDate: '01/01/2012',
            maxDate: new Date(),
            dateLimit: { days: 365 },
            showDropdowns: true,
            showWeekNumbers: false,
            timePicker: false,
            timePickerIncrement: 1,
            timePicker12Hour: true,
            ranges: {
               'Today': [moment(), moment()],
               'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
               'Last 7 Days': [moment().subtract(6, 'days'), moment()],
               'Last 30 Days': [moment().subtract(29, 'days'), moment()],
               'This Month': [moment().startOf('month'), moment().endOf('month')],
               'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            },
            opens: 'left',
            drops: 'down',
            buttonClasses: ['btn', 'btn-sm'],
            applyClass: 'btn-primary',
            cancelClass: 'btn-default',
            separator: ' to ',
            locale: {
                applyLabel: 'Submit',
                cancelLabel: 'Cancel',
                fromLabel: 'From',
                toLabel: 'To',
                customRangeLabel: 'Custom',
                daysOfWeek: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr','Sa'],
                monthNames: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
                firstDay: 1
            }
        }, function(start, end, label) {
            semusiCommon.setDateRange(start,end);
            $('#advance-daterange span').html(start.format(semusiCommon.getDateFormatt()) + ' - ' + end.format(semusiCommon.getDateFormatt()));
            calStartDate = start.format(semusiCommon.getDateFormatt());
            calEndDate = end.format(semusiCommon.getDateFormatt());

            i_maxInstallValue=0;
            u_maxInstallValue=0;
            
            var _period = [moment(semusiCommon.dateRange.currentStartDate*1000).format(semusiCommon.getDateFormatt()),moment(semusiCommon.dateRange.currentEndDate*1000).format(semusiCommon.getDateFormatt())];
            semusiCommon.setPeriod(_period);
        });
    }
    initDateRange();
});	