appice.controller('audienceViewController',function ($scope,appIceService,$routeParams,$location) {
    
    init();
    
    function init(){
        if(semusiCommon.ACTIVE_APP_ID == undefined || semusiCommon.ACTIVE_APP_ID==""){
            showMessage("You need to select an app to view audience segments.");
            return;
        }
        
        $scope.currentPage = 1;
        $scope.startFrom = 0;
        $scope.pageSize = 7;
        $scope.audienceSegments = [];
        getAudienceSegments();
        
    }
    
    $scope.numberOfPages=function(){
        if($scope.audienceSegments){
            var totalPages = Math.ceil($scope.audienceSegments.length/$scope.pageSize);                   
            return (totalPages == 0)?1:totalPages;
        }        
    }
    $scope.formatDate = function(data) {
        return semusiCommon.getDateFromEpoch(data);
    }

    $scope.deleteSegment = function(id){
        if(confirm("Are you sure to delete this Audience Segment?")) {
            promise = appIceService.deleteAudienceSegment(id);
            promise.then(function(data) {
               getAudienceSegments();                    
            });            
        }
    }

    function getAudienceSegments(){
        promise = appIceService.getAudienceSegments();
        promise.then(function(segments) {
            $scope.audienceSegments = segments;                     
        });
    }
});