appice.controller('audienceController',function ($scope,appIceService,$routeParams,$location,$timeout) {

	init();
	
	function init(){
		if(semusiCommon.ACTIVE_APP_ID == undefined || semusiCommon.ACTIVE_APP_ID==""){
		window.location =  "/dashboard";
	      	return;
		}
		// default way of audience Export is false 
		$scope.isAudienceExportEnabled = false
	    $scope.fromCustomDashboard = false;
		$scope._id = $routeParams.id;
		$scope.hide_cSegPhoneEmail = "";
		$scope.audience = getContextConfig();
		$scope.categories = getCategoryContextConfig();
	    //for enable/disable through app settings 
	    promise = appIceService.hideDisabledFeature();
		promise.then(function(data) {
			if (data && data[0] && data[0].features) {
			  const features = data[0].features;
			  // Show options based on competing apps
			  if (features.hidegranularMonetaryCACLTV && !features.competingApps) {
				$scope.showOption = [true, true, false, true, false];
			  } else if (features.competingApps && !features.hidegranularMonetaryCACLTV ) {
				$scope.showOption = [true, true, true, false, true];
			  } else if (features.competingApps && features.hidegranularMonetaryCACLTV) {
				$scope.showOption = [true, true, false, false, false];
			  } else {
				$scope.showOption = [true, true, true, true, true];
			  }
		  
			  // Show audience options
			  if (features.whowhatwherewhen) {
				$scope.showAud = [true, true, false, false];
				$scope.showAudLabel = [true, false, false];
			  } else {
				$scope.showAud = [true, true, true, true];
				$scope.showAudLabel = [true, true, true];
			  }
			  // if audience is enable then show it 
			  if (features.audience_exports !== undefined) {
				$scope.isAudienceExportEnabled = !features.audience_exports;
			  }

			  if (features.cSegPhoneEmail) {
				$scope.hide_cSegPhoneEmail = features.cSegPhoneEmail ;
			  }
			  if (features.deviceAttributes) {
				if ($scope.categories && $scope.categories[0] && $scope.categories[0].attributes) {

					$scope.categories[0].attributes.splice(7, 1);
					$scope.categories[0].attributes.splice(6, 1);
					$scope.categories[0].attributes.splice(5, 1);
					$scope.categories[0].attributes.splice(4, 1);
					$scope.categories[0].attributes.splice(3, 1);
					$scope.categories[0].attributes.splice(1, 1);
				}
			 }

			 if (features.appUsageAttributes) {
				if ($scope.categories && $scope.categories[4] && $scope.categories[4].attributes) {

					$scope.categories[4].attributes.splice(4, 1);
					$scope.categories[4].attributes.splice(3, 1);
					$scope.categories[4].attributes.splice(2, 1);
				}
			 }
			
			} else {
			  // Default options when data or features are not available
			  $scope.showOption = [true, true, true, true, true];
			  $scope.showAud = [true, true, true, true];
			  $scope.showAudLabel = [true, true, true];
			}
		  });
		$scope.context = "N/A";			
		$scope.segmentOldName = '';		
		$scope.editMode = false;
		$scope.isWho = false;
		$scope.isWhat = false;
		$scope.isWhere = false;
		$scope.isWhen = false;
		$scope.isMultiEdit = false;
		$scope.eventsArray=[];
		$scope.units =["Seconds","Minutes","Hours","Days","Months"];		
		$scope.timeunit =[{"text":"Minutes Ago","label":"minutes"},{"text":"Hours Ago","label":"hours"},{"text":"Days ago","label":"days"}];		
		$scope.platformList = [{"text":"Android","label":"Android"},{"text":"iOS","label":"IOS"}, {"text":"web","label":"Web"}];
		$scope.genderList = [{"text":"Male","label":"Male"},{"text":"Female","label":"Female"}];
		$scope.booleanList = [{"text":"True","label":"true"},{"text":"False","label":"false"}];
		$scope.interestList = ['MovieBuff','Foodie','Traveller','Religious','NightOwl','FitnessFreak','HealthConscious','MusicLover','Tech Lover','PhotographyLover','SportsLover','NewsJunkie','NewsFollower','Culinarian','Shopaholic','Shopper','Gamer','CasualGamer','PetLover','Fashionista','Inquisitive','ComicsLover','Puzzleteir','HomeSeeker'];
		$scope.timeList = [{"text": "Morning(6-11Hrs)","label":"6-11"},{"text": "Afternoon(11-16Hrs)","label":"11-16"},{"text": "Evening(16-21Hrs)","label":"16-21"},{"text": "Night(21-24Hrs)","label":"21-24"},{"text": "Past Midnight(0-6Hrs)","label":"0-6"}];
		$scope.placeList = ['Home','Office','In-Vehicle','Train Station','Airport','other'];
		$scope.numericOperators = [{"text":"Equals","label":"eq"},{"text":"Greater Than","label":"gt"},{"text":"Less Than","label":"lt"},{"text":"Not Equals","label":"neq"},{"text":"Is Between","label":"isb"},{"text":"Is Not Between","label":"isnb"},
		{"text":"Less Than or Equal to ","label":"lte"},{"text":"Greater Than or Equal to ","label":"gte"},{"text":"In (Set Operator) ","label":"in"},{"text":"Not in (Set Operator) ","label":"nin"}];
		$scope.stringOperators = [{"text":"Equals","label":"eq"},{"text":"Not Equals","label":"ne"},{"text":"Contains","label":"contains"},{"text":"In (Set operator","label":"in"},{"text":"Not in (Set Operator)","label":"nin"}];	
		$scope.booleanOperators = [{"text":"Equals","label":"eq"},{"text":"Not Equals","label":"neq"}];
		$scope.networkList = ["WIFI", "2G", "3G", "4G"];
		$scope.carrierList = [];
		$scope.competingApps = [];
		$scope.appVersionList =[];
		$scope.e_operator = {};
		$scope.arr = [];
		$scope.platformVersionList =[];
		$scope.deviceList =[];
		$scope.devicemakeList=[];
		$scope.deviceLanguageList = [];
		$scope.selectedItems = [];
		$scope.connectiontypeList=[];
		$scope.audienceSegment = getAudienceSchema();
		$scope.isError = false;
		$scope.elist = [];
		$scope.journeysArray = [];
		$scope.allEvents = [];
		$scope.selectedJourney = '';
		$scope.journeyKey      = false;
		$scope.objectId = objectId();
		$scope.customSegment = false;
		$scope.query = '';
		$scope.userQ = ''
		$scope.selectOptions = ["Mobile","Office","Home"];
		$scope.choices = [{"id": 1,"type":"Mobile"}];
		$scope.index = $scope.choices.length;

		$scope.addNewChoice = function() {
			var newItemNo = ++$scope.index;
			$scope.choices.push({'id':newItemNo, "type":"Mobile","name":""});
		};
		if( $routeParams && $routeParams.fromcampaign && $routeParams.fromcampaign !== true &&  $routeParams.fromcampaign !== "funnel=true" 
		&& $routeParams.fromcampaign.split('=')[0] == "custom" ){
			$scope.fromCustomDashboard = true;
		}
		$scope.removeChoice = function(id) {

			if($scope.choices.length<=1){
				alert("input cannot be less than 1");
				return;
			}

			var index = -1;
			var comArr = eval( $scope.choices );
			for( var i = 0; i < comArr.length; i++ ) {
				if( comArr[i].id === id) {
					index = i;
					break;
					}
			}
			if( index === -1 ) {
				alert( "Something gone wrong" );
			}
			$scope.choices.splice( index, 1 );
		};

		$scope.getSinceEvent = function(event, type, index){
			if(type == 'Events'){
				let selectEvent = $(".events-select_since_"+index).val();
				var eventData = $scope.eventsArray[selectEvent];
				$scope.audienceSegment[$scope.context][$scope.category][index].since.event = eventData.text;
			}
		}

		// ************* Start Manage event segment data *********//
		$scope.getEventAttributes = function(event, type,index){
			if(type == 'Events'){
			let selectEvent = $(".events-select_"+index).val();
			var eventData = $scope.eventsArray[selectEvent];

			$scope.audienceSegment[$scope.context][$scope.category][index].selectedAttribute = eventData;
			}else{
			$scope.elist = [];
			if(event.elist && event.elist.length > 0){
				event.elist.forEach(function(list){
					if(list.type == 'string'){
						$scope.elist.push(list);
					}
				});
				event.multiple = false;
				event.operators = $scope.booleanOperators;
				event.type = "bool";
			}
			createDropDown(event,[], index);
		 }
		}

	
		$scope.getSegementValueBox = function(segData, item){
			if(segData.multiple != undefined){
				delete segData.multiple;
				segData.operators = $scope.stringOperators;
				segData.type = "string";
			}
		}
		// ************* End Manage event segment data *********//

		if($scope._id!=undefined && $scope._id !=""){
			$scope.editMode = true;
			$scope.isMultiEdit = true;
			var promise = appIceService.getAudienceSegmentById($scope._id);
			promise.then(function(segment) {
				//Populate $scope.categories with custom vars.
				populateCustomVariables(function(){
					//Popuilate Events
					populateEvents(function(){
				        parseSavedObject(segment.segmentinfo);
				 		$scope.audienceSegment.name = segment.name;
						$scope.audienceSegment.description = segment.description;
						$scope.audienceSegment.id=segment._id;	 
						$scope.range = (segment.range) ? segment.range: 0; 
						$scope.segmentOldName = $scope.audienceSegment.name;   	
						animateCounter();		
					}); 	
				});									
	    	});
		}
		else{
			//Populate $scope.categories with custom vars.
			populateCustomVariables();
		}		    		
	}

	$scope.fileUpload = function(){
		document.getElementById('customFile').value = "";

		angular.element(document.getElementById('customFile')).on('change', function() {
			$scope.uploadCustomFile();
		});
	}

	function createDropDown(event,list, index){
		 var optionList = [];
		 var html = '';
		 event?.list?.forEach(function (v, key) {
						 html += '<option value="' + v + '">' + v + '</option>';
							  if(list && list.length>0){
								list.forEach(function(li){
									if(v===li){
										optionList.push(v);
								   }
								 })
							  }
							});
		setTimeout(function(){
			$('.ms-drop').find("ul").remove();
		 $(`#ddlEventList_${index}`).html(html);
		 $(`#ddlEventList_${index}`).multipleSelect();
		 $(`#ddlEventList_${index}`).multipleSelect("setSelects", optionList);
		}, 1000)

	}

	$scope.isDisabled = function(context) {
		if($scope.fromCustomDashboard && context.Context != "what"){
			return true;
		}
		return false;
	}
	

	$scope.addToAudienceSegment_old = function(){
		$scope.isError = false;
		var len = $scope.audienceSegment[$scope.context][$scope.category].length;
		if($scope.audienceSegment[$scope.context][$scope.category][len-1].selectedAttribute==undefined ||
			$scope.audienceSegment[$scope.context][$scope.category][len-1].operator==undefined ||
			$scope.audienceSegment[$scope.context][$scope.category][len-1].value == undefined){
			$scope.isError=true;
			$scope.errorMessage = "Criteria row is missing information."
			return;
		}
		//Add to selected items, to validate on further selection.
		var label = $scope.audienceSegment[$scope.context][$scope.category][len-1].selectedAttribute.label;
		var selectedIndex = $.inArray(label, $scope.selectedItems);
		if (selectedIndex == -1) {
			$scope.selectedItems.push(label);
		}
		
		$scope.audienceSegment[$scope.context][$scope.category].push({})
	}

	$scope.addToAudienceSegment = function(indexVal,selectedData){
		var indexVal = indexVal+1;
		$scope.isMultiEdit = false;
		$('#switch').bootstrapSwitch("disabled",true); 
		$scope.isError = false;
		var len = $scope.audienceSegment[$scope.context][$scope.category].length;
		//Add to selected items, to validate on further selection.
		var label = $scope.audienceSegment[$scope.context][$scope.category][len-1].selectedAttribute.label;
		var selectedIndex = $.inArray(label, $scope.selectedItems);
		if (selectedIndex == -1) {
			$scope.selectedItems.push(label);
		}
		$scope.audienceSegment[$scope.context][$scope.category].push({});
		setTimeout(function(){
		
			for (let i = 0, len = $scope.eventsArray.length; i < len; i++) {
				$scope.eventsArray[i].id=i;
				}		
			$(".events-select_"+indexVal).select2({
			  data: $scope.eventsArray
			})
			$(".events-select_since_"+indexVal).select2({
				data: $scope.eventsArray
			})
		},1000);
	}

	$scope.removeFromAudienceSegment = function(index){
		//Remove from selected items list.
		$scope.selectCategory($scope.category)
		$scope.isMultiEdit = false;
		$('#switch').bootstrapSwitch("disabled",false); 
		var label = ($scope.audienceSegment[$scope.context][$scope.category][index].selectedAttribute)? $scope.audienceSegment[$scope.context][$scope.category][index].selectedAttribute.label :'';
		removeFromSelectedItems(label);
		if($scope.audienceSegment[$scope.context][$scope.category].length==1){
			$scope.audienceSegment[$scope.context][$scope.category]=[{}];
			return;
		}
		$scope.audienceSegment[$scope.context][$scope.category].splice(index,1);
	}

	$scope.selectContext = function(context){
		$scope.context = context;  
		$scope.context !== 'what' ? ($scope.journeyKey = false)  : ($scope.journeyKey = true);
		$scope.context === 'what' && $scope.isWhat === true && ($scope.selectCategory($scope.category));			
		if(context == 'what' && $scope.isWhat == false){
			$scope.isWhat = true ;
			$scope.journeyKey = true;
			// get Event list 
			startLoader('Loading necessary Resources')
			populateEvents(function(){
				endLoader()
			})


		}
		if(context == 'who'  && $scope.isWho == false){
			// get device details, app details , carrier details, competing apps and other varaibles 

			startLoader('Loading necessary Resources')
			$scope.isWho = true ;

			getWhoDetails(function(){
				endLoader()
			})
		}
		if(context == 'where' && $scope.isWhere == false ){
			//get list of cities and countries
			$scope.isWhere = true ;
			startLoader('Loading necessary Resources')

			getWhereDetails(function(){
				endLoader()
			})

		}
		if(context == 'when'  && $scope.isWhen == false){
			$scope.isWhen = true
			startLoader('Loading necessary Resources')

			getConnectionType(function(){
				endLoader()

			})
		}
	}

	$scope.onJourneySelect = function(index, val) {
		let select2Data = [{id: 0, text: ""}];
		const selectedJourney = val;
		for (let i = 0, len = $scope.eventsArray.length; i < len; i++) {
			if($scope.eventsArray[i].journey === selectedJourney){
				var data ={
					id: i,
					text: $scope.eventsArray[i].text
				}
					select2Data.push(data);
			}
		} 
		setTimeout(function(){
			let totalEvents = $scope.audienceSegment[$scope.context][$scope.category];
			$(".events-select_"+index).empty();
			$(".events-select_since_"+index).empty();

			$(".events-select_"+index).select2({data: select2Data});
			$(".events-select_since_"+index).select2({data: select2Data});
		},500)
	};

	$scope.selectCategory = function(category){
		if(category == 'Geo'){
			$scope.getGeoFenceList();    // for geo-fence data
		}
		$scope.category = category;		
		if(category =='Events'){
			
			for(i = 0; i < $scope.eventsArray.length; i++) {
				if($scope.eventsArray[i].journey) {
					$scope.journeyKey = true;
					break; 
				}
			}
			var select2Data=[];
			for (let i = 0, len = $scope.eventsArray.length; i < len; i++) {
				var data ={
					id: i,
					text: $scope.eventsArray[i].text
					// text:$scope.eventsArray[i].journey
				 }
				 select2Data.push(data);
			}
				setTimeout(function(){
					let totalEvents = $scope.audienceSegment[$scope.context][$scope.category];
					totalEvents.forEach((element,i) => {
						$(".events-select_"+i).select2({
							data: select2Data
						})
						$(".events-select_since_"+i).select2({
							data: select2Data
						})
					    if($scope.audienceSegment[$scope.context][$scope.category]?.length > 0 && $scope.audienceSegment[$scope.context][$scope.category][0]?.selectedAttribute){
						var result = select2Data.filter(events => events.text == element.selectedAttribute?.label);
							
						$(".events-select_"+i).val(result[0]?.id).trigger('change');
						if(element.since && element.since.event){
							var result1 = select2Data.filter(events => events.text == element.since.event);
							$(".events-select_since_"+i).val(result1[0]?.id).trigger('change');
						}
					  }
					});
				},500)
		} 
		if(category == 'Competing Apps'){
			getCompetingAppsDetails(function(){})
		}
	}

	$scope.validateProperty = function(index){		
		var label = $scope.audienceSegment[$scope.context][$scope.category][index].selectedAttribute.label;			
		if($.inArray(label,$scope.selectedItems)!=-1){
			$scope.audienceSegment[$scope.context][$scope.category][index].selectedAttribute=undefined;	
		}							
	}
	
	$scope.changeMode = function(val){
		$scope.editMode = val;		
		$scope.audienceSegment = getAudienceSchema();
	}
	
	$scope.cancelBtn = false;
	if($routeParams.fromcampaign || $routeParams.template_id){
		$scope.cancelBtn = true;
	}

	$scope.cancelAud = function(){
		if($routeParams.template_id){
			window.location= appiceEncode.encodePayload("/dashboard?action=camp#/camp/create/new?aud=new&template_id="+$routeParams.template_id+"&templateType="+$routeParams.templateType);
		}else{
			window.location= appiceEncode.encodePayload("/dashboard?action=camp#/camp/create");
		}
	}

	function updateAud() {
		if(!validateSegment()){	
			$scope.contextVal = parseUIObject();
			let uploadDetailsObj ={}
			var datatype = document.getElementById('datatype')?.value;
			if(datatype != 0){
				let cutomSegObj = {"operand":"audid","operator":"eq", "value":$scope.audid ,"category":"Custom Segment","category_type":datatype,"attr":"","since":"","segmentOperator":""};
				$scope.contextVal.who.push(cutomSegObj);

				//Validating Custom upload CSV
				if (validateCustomSegment()) {
					return false
				}


				const fileInput = document.getElementById('customFile');
				const datatypes = document.getElementById('datatype').value;

				
				let did = false;
				let clientid = false;
				if (datatypes == "clientid") {
					clientid = true
				} else {
					did = true
				}
				uploadDetailsObj = {
					file: fileInput.files[0], // Access the first file selected by the user
					datatype: datatypes,
					fileheader: document.getElementById('fileheader').value,
					csvFile_id: fileInput.files[0].name,
					audid: $scope.audid,
					email: document.getElementById('hdnusremail').value,
					clientid: clientid,
					did: did
				}
				// Show Message when all id Correct
				$scope.showPopup('Upload has been started', 'We will notify you once file is uploaded' , 'success');
			}
			// validate segment name exists or not
			$scope.validateSegmentName(function(response){
				if(!response){
					var promise = appIceService.updateAudienceSegment($scope.audienceSegment.id,$scope.range,$scope.audienceSegment.name,$scope.audienceSegment.description,$scope.contextVal,uploadDetailsObj);
					promise.then(function(data) {
						// Error For the case of File Upload Failing
						if(data.status == 403){
							$scope.showPopup('Upload has been Failed', 'There is an Error While Uploading the File' , 'error');
						}
						$location.path ("/aud/view");	        	
					});
				}else{
					$scope.isError=true;
					$scope.errorMessage = "Please create the audience segment!";
				}
			});	
		}
	}
	$scope.saveAudienceSegment = async function(){
		if($scope.range == "" || $scope.range == null || $scope.range == undefined){
			var selector = Object();
			selector.generate = true;
			selector.countOrData = true;
			selector.execute = false;
			selector.column = ["did"];
			calculateReach(selector).then((data) => {
				vaidateAndCreateAud()
			})
		} else{
			vaidateAndCreateAud()
		}
	
	}

	const vaidateAndCreateAud =  function() {
		if(!validateSegment()){	
			$scope.contextVal = parseUIObject();
			
			let uploadDetailsObj ={}
			var datatype = document.getElementById('datatype')?.value;
			if(datatype != 0){
				let cutomSegObj = {"operand":"audid","operator":"eq","value":$scope.objectId.$$state.value,"category":"Custom Segment","category_type":datatype,"attr":"","since":"","segmentOperator":""};
				$scope.contextVal.who.push(cutomSegObj);

				//Validating Custom upload CSV
				if (validateCustomSegment()) {
					return false
				}


				const fileInput = document.getElementById('customFile');
				const datatypes = document.getElementById('datatype').value;

				
				let did = false;
				let clientid = false;
				if (datatypes == "clientid") {
					clientid = true
				} else {
					did = true
				}
				uploadDetailsObj = {
					file: fileInput.files[0], // Access the first file selected by the user
					datatype: datatypes,
					fileheader: document.getElementById('fileheader').value,
					csvFile_id: fileInput.files[0].name,
					audid: $scope.audid,
					email: document.getElementById('hdnusremail').value,
					clientid: clientid,
					did: did
				}
				// Show Message when all id Correct
				$scope.showPopup('Upload has been started', 'We will notify you once file is uploaded' , 'success');
			}
			// validate segment name exists or not
			$scope.validateSegmentName(function(response){
				if(!response && ($scope.contextVal.who.length > 0 || $scope.contextVal.what.length > 0 || $scope.contextVal.where.length > 0 || $scope.contextVal.when.length > 0)){ 
					var promise = appIceService.createAudienceSegment($scope.objectId.$$state.value,$scope.range,$scope.audienceSegment.name,$scope.audienceSegment.description,$scope.contextVal,uploadDetailsObj);
					promise.then(function(data) {
						// Error For the case of File Upload Failing
						if(data.status == 403){
							$scope.showPopup('Upload has been Failed', 'There is an Error While Uploading the File' , 'error');
						}
						if($routeParams.template_id && $routeParams.templateType && data._id ){
													
							window.location= appiceEncode.encodePayload("/dashboard?action=camp#/camp/create/new?aud=new&template_id="+$routeParams.template_id+"&templateType="+$routeParams.templateType+"&aud_id="+data._id);
							return true;
						}
						else if($routeParams.fromcampaign === 'funnel=true'){
							appIceService.resetCreateSegmentFromFunnel();
							window.location = appiceEncode.encodePayload("/dashboard?action=insideapp#/funnels/create");
							return true;
						}
						else if($routeParams.fromcampaign){
							window.location= appiceEncode.encodePayload("/dashboard?action=camp#/camp/create/new?aud=new&aud_id="+data._id);
							return true;
						}
						
						else{
							$location.path ("/aud/view");	        	        	
						}		         						        	
					});
				}else{
					$scope.isError=true;
					$scope.errorMessage = "This segment name already exists!";
				}
			});		
		}
	}

	$scope.operandChange = function(value){
		$scope.getGeoFenceList();
		removeFromSelectedItems(value);
	}
	$scope.updateAudienceSegment = async function(){
		var selector = Object();
			selector.generate = true;
			selector.countOrData = true;
			selector.execute = false;
			selector.column = ["did"];
			// Added triple equal to to stop type coercion
			if($scope.range === "" || $scope.range === null || $scope.range === undefined){
				calculateReach(selector).then((data)=> {
					updateAud()
				})
			} else{	
				updateAud()
			}
	}
	
	$scope.filterNumberValue = function($event,type){
		if(type=="number"){
			if(isNaN(String.fromCharCode(($event.which)?$event.which:$event.keyCode)) && $event.keyCode != 8){
	            $event.preventDefault();
	        }	
		}        
	};

	$scope.validateSegmentName = function(cb){
		// validate segment name
		if( $scope.audienceSegment.name != '' && $scope.audienceSegment.name != undefined && $scope.segmentOldName != $scope.audienceSegment.name ){
			$scope.isError = false; // hide error message
			promise = appIceService.validateSegmentName($scope.audienceSegment.name);
			promise.then(function(response) { 
	        	// show error message of segment name
	        	if(response.result){
	        		$scope.isError=true;
					$scope.errorMessage = "This segment name already exists!";
	        	}

	        	if(cb != undefined){
	        		cb(response.result)
	        	}
	    	});	
		}
		else{
			$scope.isError = false; // hide error message
			if( $scope.audienceSegment.name != '' && $scope.audienceSegment.name != undefined ){
				if(cb != undefined){
	        		cb(false);
	        	}
			}
		}
	}	

	function removeFromSelectedItems(label){
		var selectedIndex = $.inArray(label, $scope.selectedItems);
		if (selectedIndex>=0) {
			$scope.selectedItems.splice(selectedIndex, 1);
		}
	}
	$scope.getAudienceReach = function(row,ignore){
		//if(row.operator && row.value){
		var selector = Object();
		selector.generate = true;
		selector.countOrData = true;
		selector.execute = true;
		selector.column = ["did"];
		
		if(row.operator){
			calculateReach(selector);
		}
		else if(ignore==true){
			calculateReach(selector);
		}	

	}

	/* function store selected item object for fetch reach count */
	$scope.fetchAudienceReach = function(){
		var selector = Object();
		selector.generate = true;
		selector.countOrData = true;
		selector.execute = true;
		selector.column = ["did"];
		
		calculateReach(selector);
	}

	function validateSegment(){
		//   Validating the user input to contain only allowing letters, numbers, space, commas, periods?
		var regex = /^[a-zA-Z0-9 ]+$/;
		$scope.isError = false;
		if($scope.audienceSegment.name == undefined || $scope.audienceSegment.name==""){
			$scope.isError=true;
			$scope.errorMessage = "Enter a valid audience segment name."			
		}
		else if($scope.audienceSegment.name && !regex.test($scope.audienceSegment.name)){
        	$scope.isError=true;
			$scope.errorMessage = "Audience name must contain only letters, numbers, spaces";	
        }
		// for description
		else if($scope.audienceSegment.description == undefined || $scope.audienceSegment.description==""){
			$scope.isError=true;
			$scope.errorMessage = "Enter a valid audience Description."			
		}
		else if($scope.audienceSegment.description && !regex.test($scope.audienceSegment.description)){
        	$scope.isError=true;
			$scope.errorMessage = "Audience description must contain only letters, numbers, spaces";	
        }
		else if(!$scope.category){
			$scope.isError=true;
			$scope.errorMessage = "Please choose a target before saving."		
		}
		return $scope.isError;
	}

	//This function Validates the input feilds in the custom segement  
	function validateCustomSegment(){
		$scope.isError = false;

		const fileInput = document.getElementById('customFile');
		const fileHeaderInput = document.getElementById('fileheader');
		const dataTypeInput = document.getElementById('datatype');
	
		if (!fileInput || !fileInput.files || fileInput.files.length === 0) {
			$scope.isError=true;
			$scope.errorMessage = "File input is missing or no file selected.";
		}

		if (!fileHeaderInput || !fileHeaderInput.value) {
			$scope.isError=true;
			$scope.errorMessage = "Fileheader input is missing or empty.";
		}
	
		if (!dataTypeInput || !dataTypeInput.value) {
			$scope.isError=true;
			$scope.errorMessage = "Fileheader input is missing or empty.";
		}
	
		// All checks passed
		return $scope.isError;
	}

	/**
 * Determines whether the "Get Reach Count" button should be enabled based on the selected criteria.
 * 
 * @returns {boolean} True if the button should be enabled, otherwise false.
 */
	$scope.isButtonEnabled = function() {
		let notDoneSelected = false;
		let allParametersSelected = false;
	
		// Check if 'Have Not Done' is selected
		angular.forEach($scope.audience, function(aud) {
			angular.forEach(aud.Category, function(cat) {
				angular.forEach($scope.audienceSegment[aud.Context][cat], function(seg) {
					if (seg.since && seg.since.have === 'hn') {
						notDoneSelected = true;
						// Check if all three parameters are selected
						if (seg.since.time && seg.since.type && seg.since.event) {
							allParametersSelected = true;
						}
					}
				});
			});
		});
	
    // Button should be enabled if 'Have Not Done' is not selected
    // or if 'Have Not Done' is selected and all three parameters are selected
		return !notDoneSelected || (notDoneSelected && allParametersSelected);
	};
	
	$scope.$on('operatorChange', function(event, state){
		var len = $scope.audienceSegment[$scope.context][$scope.category].length;
		if(state){
			$scope.e_operator[$scope.audienceSegment[$scope.context][$scope.category][len-1].selectedAttribute.label] = 'OR';
		}else{
			$scope.e_operator[$scope.audienceSegment[$scope.context][$scope.category][len-1].selectedAttribute.label] = 'AND';
		}
	
	});
	async function calculateReach(selector){

		var selectedAudience = parseUIObject();
		var criteria = selectedAudience['who'];

		if($scope.customSegment == true){
			let cutomSegObj = {"operand":"audid","operator":"eq","value":$scope.audid,"category":"Custom Segment","attr":"","since":"","segmentOperator":""};
			criteria.push(cutomSegObj);
		}
		
		selectedAudience['where'].forEach(function(item){
			if(item.category=='Geo'){
				criteria.push(item);
			}
		});
		
		selectedAudience['what'].forEach(function(item){
			if(item.category=='Events'){
				criteria.push(item);
			}
		});
        
		$('#overlay').show();
		// In case of Audience Export is enabled
		if ($scope.isAudienceExport) {
			// add a flag in reach count api
			selector.isAudienceExport = $scope.isAudienceExport;
			selector.execute = false;
		}
		criteria = JSON.stringify(criteria);
		selector = JSON.stringify(selector);
		var promise = appIceService.getAudienceReach(criteria,selector);
		await promise.then(function(counter) {
			$('#overlay').hide();
		if ($scope.isAudienceExport) {
			// getting the exports query from reachCount Api 
			let q = JSON.stringify({"q":counter.userQ, isAud:true});		
			const audCsvPromise = appIceService.startExports(q);
			audCsvPromise.then(function(result) {

				  $("#messageboxsucess").text("Audience Export Initiated ")
				  $("#messagesucess").show();
				  $scope.isAudienceExport = false
				  setTimeout(() => {
					$("#messagesucess").hide();
				  },3000)   
			});
		}else{
			$scope.range = 0;
			if(counter){
				$scope.range = counter.count;
				$scope.query = counter.q;
				$scope.userQ = counter.userQ
			}
        	animateCounter();      	
		 }	
		})
		.catch(function(){
			$('#overlay').hide();
		});
	}

	function animateCounter(){
		var options = {useEasing : true,useGrouping : true, separator : ',', decimal : '.'};

		var endVal = parseInt($scope.range);		
		var startVal = parseInt($('#lblAudienceCounter').text());
		if(isNaN(startVal)){ startVal = 0; }
		var numAnim = new countUp("lblAudienceCounter", startVal,endVal,0,1,options);
		numAnim.start();
	}
	//Get audience segments.
	function refreshAudienceSegments(){	
		var promise = appIceService.getAudienceSegments();
		promise.then(function(segments) {
        	$scope.savedSegments = segments;        	
    	});
	}
	// Event function for AND - OR switch 
	$scope.$on('expendedImgAction',function(event, state){
		if(state == true){
			$scope.funnel.events[len-1].e_operator =  'OR'
		}
		else{
			$scope.funnel.events[len-1].e_operator =  'AND'
		}
	});

	/**
 	* Checks if all specified arrays within the given object are empty.
 	* @param {Object} obj - The object to be checked.
 	* @returns {boolean} - True if all specified arrays are empty, otherwise false.
 	*/
	function areAllArraysEmpty(obj) {

		    // Define an array of keys to check for empty arrays
		const keysToCheck = ["who", "what", "where", "when"];

	        // Check if the value corresponding to the current key is an array and if its length is 0
		return keysToCheck.every(key => Array.isArray(obj[key]) && obj[key].length === 0);
	}
	

	// Upon click of download button this function will check if any pillars are set 
	$scope.downloadAudienceCsv = function() {
		const selectedAudience = parseUIObject();

		// if all piilars are empty, show error ,
		if (areAllArraysEmpty(selectedAudience)) {
		
			$("#messagebox").text("Please Select a valid Audience Segement");
            $("#message").show();
            setTimeout(() => {
                $("#message").hide();
            },3000)
	
		}else{
			// set flag as true and call the api to generate query
			$scope.isAudienceExport  = true
			$scope.fetchAudienceReach()
		}
	};
	function parseUIObject(){
		var parsedObject = {}
		var counter = 0;
		$scope.audience.forEach(function(item){
			parsedObject[item.Context]=[];
			
			item.Category.forEach(function(cat){
				$scope.audienceSegment[item.Context][cat].forEach(function(segment){
					if(segment.selectedAttribute != null){
						var e_operator = ($scope.e_operator[segment.selectedAttribute.label]) ? $scope.e_operator[segment.selectedAttribute.label] : 'AND';
						counter++;
			     	}
					var operand = (segment.selectedAttribute) ? segment.selectedAttribute.label: undefined;		
					var operator = (segment.operator) ? segment.operator : undefined;
					var details = (segment.details) ? segment.details : undefined;
					var segmentOperator = (segment.segmentOperator) ? segment.segmentOperator : undefined;
					var  pubEventKey =(segment.selectedpubattr)? segment.selectedpubattr.label:undefined;
                    var  pubEventAttribute = (segment.subselectedpubattr) ?segment.subselectedpubattr.name : undefined;
                    var  subEventKey = (segment.selectedsubattr)? segment.selectedsubattr.label: undefined;
                    var  subEventAttribute = (segment.subselectedsubattr)?segment.subselectedsubattr.name: undefined;
					if(operator == 'in' || operator == 'nin'){
						var datasets = (segment.value) ? segment.value: "";
						var value = datasets.toString().split(",");
					}
					else if(operator == 'isb' || operator == 'isnb'){
						var datasets = (segment.value) ? segment.value: "";
						var value = datasets.toString().split(",");

						var datasetsSecond = (segment.valueSecond) ? segment.valueSecond: "";
						var valueSecond = datasetsSecond.toString().split(",");
						valueSecond = parseInt(valueSecond)
					}
					else{
						if(operand == 'gf'){
							var dw = 0;
							var dwell = (segment.dwell) ? segment.dwell: "";
							var time = (segment.dwell) ? segment.time: "";
							if(time == 'm'){ dw = dwell*60; }
							if(time == 'h'){ dw = dwell*60*60; }
							if(time == 'd'){ dw = dwell*60*60*24; }
						}
						var value = (segment.value) ? segment.value: undefined;
						
					}
					var timeUnit = (segment.timeUnit) ? segment.timeUnit : undefined;
					var attr = (segment.subselectedAttribute && segment.subselectedAttribute.name) ? segment.subselectedAttribute.name : undefined;
					var since = (segment.since) ? segment.since: undefined;
					if(segment.selectedAttribute && segment.selectedAttribute.type == "time"){
						if(segment.ft>=0 && segment.tt){
							value = segment.ft +"-"+segment.tt;	
						}						
					}
					if(segment.selectedpubattr){
                        parsedObject[item.Context].push({pubsub:{pub:{eventKey:pubEventKey,eventAttribute:pubEventAttribute },sub:{eventKey:subEventKey,eventAttribute:subEventAttribute}},category:cat});	
                     }
					if(operand && operator && value){
						if(segment.selectedAttribute.type=="number" && operator != 'in' && operator != 'nin' ){
							value = parseInt(value);
						}
						else if(segment.selectedAttribute.type=="bool"){
							value = (value == 'true');
						}else if(segment.subselectedAttribute != undefined){
							if(segment.subselectedAttribute.type =="boolean"){
								value = (value == 'true');
							}
							if(segment.subselectedAttribute.type=="number" && operator != 'in' && operator != 'nin'	){
								value = parseInt(value);
							}
						}
						if(operand == 'gf'){
							parsedObject[item.Context].push({operand : operand,operator:operator,timeUnit:timeUnit,e_operator:e_operator,value:value,category:cat, attr: attr,since:since,segmentOperator:segmentOperator,details:details, dw:dw, dwell:dwell, time:time });	
						}else{
							parsedObject[item.Context].push({operand : operand,operator:operator,timeUnit:timeUnit,e_operator:e_operator,value:value,valueSecond:valueSecond,category:cat, attr: attr,since:since,segmentOperator:segmentOperator });	
						}
						
					}else{
						if(operand  && operand != undefined){
							if(operand == 'gf'){
								parsedObject[item.Context].push({operand : operand,operator:operator,value:value,e_operator:e_operator,category:cat, attr: attr,since:since,segmentOperator:segmentOperator,details:details,dw:dw, dwell:dwell, time:time });	
							}else{
								parsedObject[item.Context].push({operand : operand,operator:operator,value:value,e_operator:e_operator,category:cat, attr: attr,since:since,segmentOperator:segmentOperator });	
							}
						}
					}
					parsedObject.q = $scope.query;
					parsedObject.userQ = $scope.userQ;
				});
			});
		});
		return parsedObject;
	}

	function parseSavedObject(savedObject){
		$scope.audienceSegment = getAudienceSchema();
		$scope.audience.forEach(function(item){
			savedObject[item.Context].forEach(function(segment){
				// During selecting exisitng Template set its category 
				$scope.category = segment.category; 
				if(segment && segment.timeunit){
					$scope.timeUnit = segment.timeunit
				}			
				if(segment.operand)	{												
					var newItem = {selectedAttribute:getAttributeDetails(segment.operand,segment.category),operator:segment.operator,value: segment.value !== undefined ? segment.value : '',valueSecond: segment.valueSecond !== undefined ? segment.valueSecond : '', attr:segment.attr,since:segment.since, timeUnit : segment.timeUnit};
				if(segment.operand=='custom'){
					newItem.ft = parseInt(segment.value.split('-')[0]);
					newItem.tt = parseInt(segment.value.split('-')[1]);
				}
				if(segment.dw != undefined){
					newItem.dwell = segment.dwell;
					newItem.time = segment.time;
				}
				if(newItem.selectedAttribute.type=='bool'){
					newItem.value = ''+newItem.value;
				}
				$scope.selectedItems.push(newItem.selectedAttribute.label);
			}

			if(segment.pubsub){
				var pubevent = {selectedpubattr:getpubsubDetails(segment.pubsub.pub.eventKey, segment.category)}
				pubevent.selectedsubattr = getpubsubDetails(segment.pubsub.sub.eventKey, segment.category)
				pubevent.subselectedpubattr = {"name":segment.pubsub.pub.eventAttribute}
				pubevent.subselectedsubattr = {"name":segment.pubsub.sub.eventAttribute}
				$scope.audienceSegment[item.Context][segment.category].push(pubevent);

				var arr = $scope.audienceSegment[item.Context][segment.category]
			    var filtered = arr.filter(function(x){
					return x.selectedpubattr != undefined
				});
				$scope.audienceSegment[item.Context][segment.category] = filtered;
			}
			if(segment.category != 'Communique'){
					$scope.audienceSegment[item.Context][segment.category].push(newItem);
				if(segment.category == 'Events'){
					var lastKey = $scope.audienceSegment[item.Context][segment.category].length-1;
					var lastEvent = $scope.audienceSegment[item.Context][segment.category];

					lastEvent = lastEvent[lastKey];
					var isSeg = false;
					if(lastEvent.attr && lastEvent.attr != ''){
						lastEvent.selectedAttribute.elist.forEach(function(list){
							if(list.name == lastEvent.attr){
								lastEvent.subselectedAttribute = list;
								isSeg = true;
							}
							
							if(list.type == 'string'){
								$scope.elist.push(list);
							}
						});
						if(lastEvent.selectedAttribute?.elist?.length === 0) {
							lastEvent.subselectedAttribute = {
							   name : lastEvent.attr
							};
							isSeg = true;
						}
						
						if(isSeg){
							$scope.getSegementValueBox(lastEvent.selectedAttribute, lastEvent);
						}
						
						$scope.audienceSegment[item.Context][segment.category][lastKey] = lastEvent;
					}
				}
				
				//Remove the template row in edit mode.
				if(!$scope.audienceSegment[item.Context][segment.category][0].selectedAttribute){
					$scope.audienceSegment[item.Context][segment.category].splice(0,1);
				}
			}
			// Adding for Custom segment
			if(segment.category == 'Custom Segment'){
				// Custom Segment
				 $scope.query = savedObject.q
				 $scope.userQ = savedObject.userQ
			}
			});			
		});
	}

	function getAttributeDetails(attribute,category){
		var result={};		
		$scope.categories.forEach(function(item){
			if(item.category==category){
				item.attributes?.forEach(function(attr){
					if(attr.label==attribute){
						result = attr;
					}
				});
			}
		});

		return result;
	}

	function getConnectionType(callback){
		// for connection Type
		promise = appIceService.getAttributeValues("ctype");
		promise.then(function(connectiontype) {
			document.getElementById('load').style.visibility="hidden";
        	$scope.connectiontypeList = connectiontype;
        	//Assign available values to attributes
			assignAvailableValuesToAttributes();
			callback()
		});
	}

	function getCompetingAppsDetails(callback){
    	promise = appIceService.getCompetingApps();
		promise.then(function(competingApps) {
        	$scope.competingApps = competingApps;
        	//Assign available values to attributes
			assignAvailableValuesToAttributes();
			callback()
    	});	
	}

	function getpubsubDetails(attribute,category){
		var result={};		
		$scope.categories.forEach(function(item){
			if(item.category==category){
				item.pubsubattr.forEach(function(attr){
					if(attr.label==attribute){
						result = attr;
					}
				});
			}
		});

		return result;
	}

	function getWhoDetails(callback){
		var promise1 = appIceService.getAttributeValues("c");
		var promise2 = appIceService.getAttributeValues("pv");
		var promise3 = appIceService.getAttributeValues("av");
		var promise4 = appIceService.getAttributeValues("d");
    	var promise5 = appIceService.getAttributeValues("ma");
    	var promise6 = appIceService.getAttributeValues("device_lang");
		Promise.all([promise1, promise2, promise3, promise4, promise5, promise6]).then((values) => {

			$scope.carrierList = values[0];
			$scope.platformVersionList = values[1];
			$scope.appVersionList = values[2];
			$scope.deviceList = values[3];        	
			$scope.devicemakeList = values[4]; 
			$scope.deviceLanguageList = values[5];       	
			assignAvailableValuesToAttributes();
			callback()
		  });
	}

	function getWhereDetails(callback){
		var promise1 = appIceService.getAttributeValues("cty");
		var promise2 = appIceService.getAttributeValues("cc");

		Promise.all([promise1, promise2]).then((values) => {
			$scope.cityList = values[0];
			$scope.countryList = values[1];
			assignAvailableValuesToAttributes();
			callback()
		  });
	}
	
	promise = appIceService.hideDisabledFeature();
	promise.then(function(data) {
	  if (data) {
		for (var i = 0; i < $scope.platformList.length; i++) {
			if ($scope.platformList[i].text === "web") {
				$scope.platformList.splice(i, 1);
				break;
			}
		}
	  }
	});

	function assignAvailableValuesToAttributes(){
		$scope.categories.forEach(function(item){
			if(item.attributes != undefined){				
			item.attributes.forEach(function(attr){
				if(attr.type=="bool"){
					attr.list = $scope.booleanList;
				}
				else if(attr.type=="timelist"){
					attr.list = $scope.timeList;
				}
				else{
					switch(attr.label){
						case "p":
							attr.list = $scope.platformList;
							break;
						case "c":
							attr.list = $scope.carrierList;
							break;
						case "device_lang":
							attr.list = $scope.deviceLanguageList;
							break;
						case "pv":
							attr.list = $scope.platformVersionList;
							break;
						case "av":
							attr.list = $scope.appVersionList;
							break;
						case "gender":
							attr.list = $scope.genderList;
							break;
						case "Interests":
							attr.list = $scope.interestList;
							break;
						case "cty":
							attr.list = $scope.cityList;
							break;
						case "cc":
							attr.list = $scope.countryList;
							break;
						case "d":
							attr.list = $scope.deviceList;
							break;
						case "ma":
							attr.list = $scope.devicemakeList;
							break;
						case "place":
							attr.list = $scope.placeList;
							break;	
						case "connection":
							attr.list = $scope.networkList;
							break;
						case "competingapps.apps.id":
							attr.list = $scope.competingApps;
							break;					
					}	
				}					
			});
		}
			
		});
	}

	function getAudienceSchema(){
		var schema = {};
		$scope.audience.forEach(function(item){
			schema[item.Context]={};
			item.Category.forEach(function(cat){
				schema[item.Context][cat]=[{}];
			});
		});
		return schema;
	}

	function populateCustomVariables(callback){
		var promise = appIceService.getCustomVariables();
		promise.then(function(data) {
			if(data && data.result){
				$scope.categories.forEach(function(cat){
					if(cat.category=="Custom Vars"){
						data.result.forEach(function(item){
							var attribute={};
							attribute.text = item.displayName;
							attribute.label = item.name;
							attribute.type = (item.type=="boolean")? "bool" : item.type;
							if(attribute.type=="string"){
								attribute.operators = $scope.stringOperators;
							}
							else if(attribute.type=="number"){
								attribute.operators = $scope.numericOperators;
							}
							else if(attribute.type=="bool"){
								attribute.operators = [{"text":"Equals","label":"eq"}];
								attribute.multiple = false;
								attribute.list = $scope.booleanList;
							}
							
							cat.attributes.push(attribute);
						});	
						$scope.eventsArray = cat.attributes;
					}
				});				
			}
			if(callback){
				callback();
			}         	        	
    	});		
	}


	function populateEvents(callback){
		var journeys = [];
		var promise = appIceService.getEventList();
		promise.then(function(eventsData) {
			$scope.categories.forEach(function(cat){
				if(cat.category=="Events"){
					var events = eventsData.data;

					// -------------------------------jouney drop down start
					$scope.allEvents = events;
					for (let i = 0; i < events.length; i++) {
					if(events[i].journey){
						// journeys.push({journey: events[i].journey, id:i+1});
						journeys.push(events[i].journey);
					}
					}
					const arr = journeys;
                    const journeyArray = arr.filter((elem, index, self) => {
                      return index === self.indexOf(elem);
                    });
					$scope.journeysArray = journeyArray;

					// -------------------------------------------- JDD end

					events.forEach(function(item){
						var attribute={};
						attribute.text = item.event;
						attribute.label = item.event;
						attribute.type = 'bool',
						attribute.operators = [{"text":"Equals","label":"eq"}];
						attribute.list = $scope.booleanList;
						attribute.elist = item.list;
						attribute.multiple = false;
						attribute.journey = item.journey;
						cat.attributes.push(attribute);
					});	
					$scope.eventsArray = cat.attributes
				}
				if(cat.category=="Communique"){
					var eventss = eventsData.data;
					eventss.forEach(function(item){
						var pubsub={};
						pubsub.text = item.event
						pubsub.label = item.event;
						pubsub.type = 'bool',
						pubsub.operators = [{"text":"Equals","label":"eq"}];
						pubsub.list = $scope.booleanList;
						pubsub.elist = item.list;
						pubsub.multiple = false;
						cat.pubsubattr.push(pubsub);
					});	
				}
			});							
			if(callback){
				callback();
			}        	        	
    	});		
	}
	// show popup box
	$scope.showPopup = function(title, msg, type){
		// show popup box
		swal({
				title: title,
				text: msg,
				type: type, //"error"
				// showCancelButton: !0,
				// confirmButtonClass: "btn-"+type,
				// confirmButtonText: "Close"
		});
	}
	///function for uploading custom segment csv file  ////
	$scope.uploadCustomFile = () => { 
        const fi = document.getElementById('customFile'); 
        // Check if any file is selected. 
        if (fi.files.length > 0) { 
			const fsize = fi.files.item(0).size; 
			const fName = fi.files.item(0).name;
			const file = Math.round((fsize / 1024)); 
			const fext = fName.split('.').pop();
			if (fName.indexOf('.') !== fName.lastIndexOf('.')){
				$("#custom_message").text("Please select csv format").css('color', 'red');
				return
			}
			//file extension 
			if(fext == 'csv' || fext == 'CSV'){
				// The size of the file. 
				if (file >= 64000) { alert("File too Big, please select a file less than 64mb"); 
				}else{ $scope.customFileupload(); } 
			}else{
				alert("Please select csv format");
			}
        }else{
			alert("Please select csv file");
		} 
	}
	function objectId () {
		return appIceService.getObjectId()
	}
	function hex (value) {
		return Math.floor(value).toString(16)
	}
	$scope.customFileupload = function() {
		var fi = document.getElementById('customFile');
		var datatype = document.getElementById('datatype').value; 
		var fileheader = document.getElementById('fileheader').value; 
		if(fileheader == 0 || datatype == 0){
			$("#custom_message").text("Select file header and data type option").css('color', 'red'); 
		}else{
			$("#custom_message").text("");
			if (fi.files.length > 0) { 
				$("#custom_message").text("Upload will happend once you save the segment").css('color', 'orange');
				$scope.customSegment = true;
				if($scope._id == '' || $scope._id == null || $scope._id == undefined){
					$scope.audid=$scope.objectId.$$state.value
				}else{
					$scope.objectId = $scope._id;
					$scope.audid= $scope._id
				}
			}
		}
    }
	$scope.isEnable = 0;
	$scope.openGeoFence = function ($event, type, indexVal) {
		if (type == 'new'){
			$('#geofence').modal({
				show: 'false'
			});
			if(!$scope.isEnable){
				initMap();
				$scope.isEnable = 1;
			}
		}else{
			$scope.geoData = $scope.geoArr.filter(function (e) {
				return e.name == type;
			});
			let details = []; 
			for (let i = 0; i <  $scope.geoData[0].details.length; i++) {
				let obj = {};
				obj.lat = $scope.geoData[0].details[i].coordinates.lat;
				obj.lng = $scope.geoData[0].details[i].coordinates.lng;
				if($scope.geoData[0].details[i].radius != undefined){
					obj.radius = $scope.geoData[0].details[i].radius;
				}
				details.push($scope.geoData[0].details[i]);
			}
			
			
			$scope.audienceSegment[$scope.context][$scope.category][indexVal].details = details;
		
		}
				
		setTimeout(function () {  }, 1000);
	}

	$scope.getGeoFenceList = function ($event, type) {
		var promise = appIceService.getGeoFencing();
		promise.then(function(geo) {
			
			$scope.geoArr = geo;
		})
		.catch(function(){
			$('#overlay').hide();
		});
	}

	$scope.geoArr = [];
	$scope.addGeoFence = function () {
		let name = $("#recipient-name").val();
		let desc = $("#message-text").val();
		if(name != '' && desc != ''){
			let finalObj = {};
			finalObj.name = name;
			finalObj.desc =  desc;
			finalObj.details = $scope.geo;
			if(finalObj.details.length){
				var promise = appIceService.saveGeoFencing(finalObj);
				promise.then(function(geo) {
					$scope.getGeoFenceList();
					$('#overlay').hide();
					if(geo.msg){
						$scope.errorMessage = geo.msg;
					}else{
						$scope.geoArr.push(geo);
						
						$('#geofence').hide();
					}   	
				})
				.catch(function(){
					$('#overlay').hide();
				});
			}else{
				$scope.errorMessage = 'Please draw geo-fencing shapes with greater then 200m radius';
				
			}
		}else{
			$scope.errorMessage = 'Please fill geo-fencing name/description';
		}
		
	}
	function getContextConfig (){
		return [
			{
			    "Context":"who",
			    "Category":["Device","App Usage","Custom Vars", "Competing Apps", "Custom Segment"],
			    "Label":"is doing"
			},
			{
			    "Context":"what",
			    "Category":["Events"],
			    "Label":"at"
			},
			{
			    "Context":"where",
			    "Category":["Geo","Location","Network"],
			    "Label":"and"
			},
			{
			    "Context":"when",
			    "Category":["Time"],
			    "Label":""
			}
		];
	}
    // Communique comment from what for gcc release 26-07-2022

	function getCategoryContextConfig(){
		return [
			  {
			    "category":"Device",
			    "reachable":true,
			    "attributes":[
			        {
			          "text":"Device Id",
			          "label":"did",
			          "type":"string",
			          "operators":[{"text":"Equals","label":"eq"},{"text":"Not Equals","label":"ne"},{"text":"In","label":"in"}]			          
			        },
			        {
			          "text":"Carrier",
			          "label":"c",
			          "type":"string",
			          "multiple":true,
			          "operators":[{"text":"In","label":"in"},{"text":"Not In","label":"nin"}]		          
			        },
			        {
			          "text":"Platform",
			          "label":"p",
			          "type":"string",
			          "multiple":false,
			          "operators":[{"text":"Equals","label":"eq"},{"text":"Not Equals","label":"ne"}]		          
			        },
			        {
			          "text":"Platform Version",
			          "label":"pv",
			          "type":"string",
			          "multiple":true,
			          "operators":[{"text":"In","label":"in"},{"text":"Not In","label":"nin"}]		          
			        },
			        {
			          "text":"App Version",
			          "label":"av",
			          "type":"string",
			          "multiple":true,
			          "operators":[{"text":"In","label":"in"},{"text":"Not In","label":"nin"}]		          
			        },
			        {
			          "text":"Device Make",
			          "label":"ma",
			          "type":"string",
			          "multiple":true,
			          "operators":[{"text":"In","label":"in"},{"text":"Not In","label":"nin"}]		          
			        },
			        {
			          "text":"Device Model",
			          "label":"d",
			          "type":"string",
			          "multiple":true,
			          "operators":[{"text":"In","label":"in"},{"text":"Not In","label":"nin"}]		          
			        },
					{
					  "text":"Device Language",
				      "label":"device_lang",
					  "type":"string",
				      "multiple":false,
					  "operators":[{"text":"Equals","label":"eq"},{"text":"In","label":"in"},{"text":"Not In","label":"nin"}]		          	          
				    }

			    ]
			    
			  },
			  {
			    "category":"Demographics",
			    "reachable":true,
			    "attributes":[
			        {
			          "text":"Gender",
			          "label":"gender",
			          "type":"string",
			          "multiple":false,
			          "operators":[{"text":"Equals","label":"eq"},{"text":"Not Equals","label":"ne"}]			          
			        }
			    ]
			    
			  },
			  {
			    "category":"Custom Vars",
			    "reachable":true,
			    "attributes":[]
			    
			  },
			  {
			    "category":"Competing Apps",
			    "reachable":true,
			    "attributes":[
			        {
			          "text":"Competing Apps",
			          "label":"competingapps.apps.id",
			          "type":"object",
			          "multiple":true,
			          "operators":[{"text":"In","label":"in"}, {"text":"Not in","label":"nin"}]			          
			        }
			    ]
			    
			  },
			  {
			    "category":"App Usage",
			    "reachable":true,
			    "attributes":[
			        {
			          "text":"First Seen",
			          "label":"fs",
			          "type":"number",
			          "operators":[{"text":"Greater Than","label":"gt"},{"text":"Greater Than or Equal To","label":"gte"},{"text":"Less Than","label":"lt"},{"text":"Less Than or Equal To","label":"lte"}],

			        },
			        {
			          "text":"Last Seen",
			          "label":"ls",
			          "type":"number",
			          "operators":[{"text":"Greater Than","label":"gt"},{"text":"Greater Than or Equal To","label":"gte"},{"text":"Less Than","label":"lt"},{"text":"Less Than or Equal To","label":"lte"}],
			        },
			        {
			          "text":"Session Count",
			          "label":"sc",
			          "type":"number",
			          "operators":[{"text":"Equals","label":"eq"},{"text":"Greater Than","label":"gt"},{"text":"Less Than","label":"lt"}]			           
			        },
			        {
			          "text":"Total Session Duration(Minutes)",
			          "label":"tsd",
			          "type":"number",
			          "operators":[{"text":"Equals","label":"eq"},{"text":"Greater Than","label":"gt"},{"text":"Less Than","label":"lt"}]			           
			        },
					{
						"text":"Notification Permission",
						"label":"permissions->'is_pn'",
						"multiple":"false",
						"type":"boolean",
						"operators":[{"text":"Equals","label":"eq"}]		           
					}
			    ]
			    
			  },
			   {
				    "category":"Interests",
				    "reachable":true,
				    "attributes":[
				        {
				          "text":"Interests",
				          "label":"Interests",
				          "type":"string",				          
				          "multiple":true,
				          "operators":[{"text":"In","label":"in"},{"text":"Not In","label":"nin"}]		          
				        }
				        
				    ]
				    
				  },
			  {
			    "category":"Geo",
			    "reachable":true,
			    "attributes":[
			        {
			          "text":"City",
			          "label":"cty",
			          "type":"string",
			          "multiple":true,
			          "operators":[{"text":"In","label":"in"},{"text":"Not In","label":"nin"}]		          
			        },
			        {
			          "text":"Country",
			          "label":"cc",
			          "type":"string",
			          "multiple":true,
			          "operators":[{"text":"In","label":"in"},{"text":"Not In","label":"nin"}]		          
			        },
					{
						"text":"Geo-fencing",
						"label":"gf",
						"type":"string",
						"multiple":true,
						"operators":[{ "text": "OnEntry", "label": "oen" }, { "text": "OnExit", "label": "oex" }]		          
					}
			    ]
			    
			  },
			  {
			    "category":"Location",
			    "attributes":[
			        {
			          "text":"Place",
			          "label":"place",
			          "type":"string",
			          "multiple":true,
			          "operators":[{"text":"In","label":"in"},{"text":"Not In","label":"nin"}]		          
			        }
			    ]
			    
			  },
			  {
			  	"category":"Network",
			  	"attributes":[			  		
			        {
			          "text":"Connection Type",
			          "label":"connection",
			          "type":"string",
			          "multiple":true,
			          "operators":[{"text":"In","label":"in"},{"text":"Not In","label":"nin"}]		          
			        },
			        {
			          "text":"Roaming",
			          "label":"roaming",
			          "type":"bool",
			          "multiple":false,
			          "operators":[{"text":"Equals","label":"eq"}]		          
			        }
			  	]
			  },
			  {
			    "category":"Time",
			    "attributes":[
			        {
			          "text":"Time",
			          "label":"time",
			          "type":"timelist",
			          "multiple":true,
			          "operators":[{"text":"In","label":"in"},{"text":"Not In","label":"nin"}]		          
			        },
			        {
			          "text":"Custom",
			          "label":"custom",
			          "type":"time",			          
			          "operators":[{"text":"Between","label":"between"}]
			        }
			    ]

			},
			{
			  "category":"Communique",
			  "pubsubattr":[]
			  },
			  {
			    "category":"Events",
			    "attributes":[]
			  },
			  {
			    "category":"Custom Segment"
			  }
			]
	}

	function initMap() {
		let infoWindow = new google.maps.InfoWindow();
		if (navigator.geolocation) {
			navigator.geolocation.getCurrentPosition(
			  (position) => {
				const pos = {
				  lat: position.coords.latitude,
				  lng: position.coords.longitude,
				};
	  
				infoWindow.setPosition(pos);
				infoWindow.setContent("Your Location");
				infoWindow.open(map);
				map.setCenter(pos);
			  },
			  () => {
				handleLocationError(true, infoWindow, map.getCenter());
			  }
			);
		  } else {
			// Browser doesn't support Geolocation
			handleLocationError(false, infoWindow, map.getCenter());
		  }
		const map = new google.maps.Map(document.getElementById("map"), {
			center: { lat: -34.397, lng: 150.644 },
			zoom: 8,
			mapTypeControl: false
		});
		// Create the search box and link it to the UI element.
		const input = document.getElementById("pac-input");
		const searchBox = new google.maps.places.SearchBox(input);
		map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);
		map.addListener("bounds_changed", () => {
			searchBox.setBounds(map.getBounds());
		});
		let markers = [];
		searchBox.addListener("places_changed", () => {
			const places = searchBox.getPlaces();
	
			if (places.length == 0) {
				return;
			}
			// Clear out the old markers.
			markers.forEach((marker) => {
				marker.setMap(null);
			});
			markers = [];
			// For each place, get the icon, name and location.
			const bounds = new google.maps.LatLngBounds();
			places.forEach((place) => {
				if (!place.geometry) {
					
					return;
				}
				const icon = {
					url: place.icon,
					size: new google.maps.Size(71, 71),
					origin: new google.maps.Point(0, 0),
					anchor: new google.maps.Point(17, 34),
					scaledSize: new google.maps.Size(25, 25),
				};
				// Create a marker for each place.
				markers.push(
					new google.maps.Marker({
						map,
						icon,
						title: place.name,
						position: place.geometry.location,
					})
				);
	
				if (place.geometry.viewport) {
					// Only geocodes have viewport.
					bounds.union(place.geometry.viewport);
				} else {
					bounds.extend(place.geometry.location);
				}
			});
			map.fitBounds(bounds);
		});
		var all_overlays = [];
        var selectedShape;
		const drawingManager = new google.maps.drawing.DrawingManager({
			drawingMode: google.maps.drawing.OverlayType.CIRCLE,
			drawingControl: true,
			drawingControlOptions: {
				position: google.maps.ControlPosition.TOP_CENTER,
				drawingModes: [
					// google.maps.drawing.OverlayType.MARKER,
					google.maps.drawing.OverlayType.CIRCLE,
					google.maps.drawing.OverlayType.POLYGON,
					// google.maps.drawing.OverlayType.POLYLINE,
					google.maps.drawing.OverlayType.RECTANGLE,
				],
			},
			markerOptions: {
				icon:
					"assets/minifiedImg/Logo.png",
			},
			circleOptions: {
				fillColor: "#f0f0f0",
				fillOpacity: 0.2,
				strokeWeight: 2,
				clickable: false,
				editable: true,
				zIndex: 1,
			},
		});

		drawingManager.setMap(map);
	
		$scope.geo = [];
		google.maps.event.addListener(drawingManager, 'overlaycomplete', function(event) {
			all_overlays.push(event);
			
			
			if (event.type == 'circle') {
				var radius = event.overlay.getRadius();
				var path = event.overlay.getCenter();
				placeMarker(path,radius);
				if(radius > 200){
					$scope.errorMessage = '';
					$scope.geo.push({"type":event.type,"coordinates":path,"radius":radius});
				}else{
					$scope.errorMessage = 'Please drow geo-fencing greater then 200m';
				}
			}
			if (event.type == 'polygon') {
				var radius = event.overlay.getPath().getArray();
				$scope.geo.push({"type":event.type,"coordinates":radius});
			}
			if (event.type !== google.maps.drawing.OverlayType.MARKER) {
				drawingManager.setDrawingMode(null);
				//Write code to select the newly selected object.
				var newShape = event.overlay;
				newShape.type = event.type;
				google.maps.event.addListener(newShape, 'click', function() {
					setSelection(newShape); 
				});

				setSelection(newShape);
			}
		});

		function clearSelection() {
			if (selectedShape) {
				selectedShape.setEditable(false);
				selectedShape = null;
			}
		}

		function setSelection(shape) {
			
			clearSelection();
			selectedShape = shape;
			shape.setEditable(true);
			google.maps.event.addListener(selectedShape.getPath(), 'insert_at', getPolygonCoords(shape));
			google.maps.event.addListener(selectedShape.getPath(), 'set_at', getPolygonCoords(shape));
		}

		function deleteSelectedShape() {
			if (selectedShape) {
				selectedShape.setMap(null);
			}
		}

		function deleteAllShape() {
			for (var i = 0; i < all_overlays.length; i++) {
				all_overlays[i].overlay.setMap(null);
			}
			all_overlays = [];
			deleteMarkers();
		}
		var marker = [];

		function placeMarker(position, radius) {
			const marker = new google.maps.Marker({
				position,
				color:"#fff",
				label:position.toUrlValue(5)+" ( Radius :"+parseInt(radius)+" )",
				map,
			});
			markers.push(marker);
		}
		// Sets the map on all markers in the array.
		function setMapOnAll(map) {
			for (let i = 0; i < markers.length; i++) {
				markers[i].setMap(map);
			}
		}
		// Removes the markers from the map, but keeps them in the array.
		function hideMarkers() {
			setMapOnAll(null);
		}

		// Shows any markers currently in the array.
		function showMarkers() {
		setMapOnAll(map);
		}

		// Deletes all markers in the array by removing references to them.
		function deleteMarkers() {
		hideMarkers();
		markers = [];
		}
		function CenterControl(controlDiv, map) {

			// Set CSS for the control border.
			 var controlUI = document.createElement('div');
			controlUI.style.backgroundColor = '#fff';
			controlUI.style.backgroundImage = 'https://gccuatpanel.appice.io/assets/minifiedImg/delete.svg';
			controlUI.style.border = '2px solid #fff';
			controlUI.style.borderRadius = '3px';
			controlUI.style.boxShadow = '0 2px 6px rgba(0,0,0,.3)';
			controlUI.style.cursor = 'pointer';
			controlUI.style.marginBottom = '22px';
			controlUI.style.textAlign = 'center';
			controlUI.title = 'Delete Last Draw';
			controlDiv.appendChild(controlUI);
			// Set CSS for the control interior.
			var controlText = document.createElement('div');
			controlText.style.color = 'rgb(25,25,25)';
			controlText.style.fontFamily = 'Roboto,Arial,sans-serif';
			controlText.style.fontSize = '14px';
			controlText.style.lineHeight = '30px';
			controlText.style.paddingLeft = '5px';
			controlText.style.paddingRight = '5px';
			controlText.innerHTML = 'Delete Last Draw';
			controlUI.appendChild(controlText);
			// Setup the click event listeners: simply set the map to Chicago.
			controlUI.addEventListener('click', function(newShape) {
				deleteSelectedShape();
				//deleteAllShape();
			 });

		}
		function CenterControlV1(controlDiv, map) {
			// Set CSS for the control border.
			const controlUIV1 = document.createElement("div");
		  
			controlUIV1.style.backgroundColor = "#fff";
			controlUIV1.style.border = "2px solid #fff";
			controlUIV1.style.borderRadius = "3px";
			controlUIV1.style.boxShadow = "0 2px 6px rgba(0,0,0,.3)";
			controlUIV1.style.cursor = "pointer";
			controlUIV1.style.marginRight = "11px";
			controlUIV1.style.marginBottom = "22px";
			controlUIV1.style.textAlign = "center";
			controlUIV1.title = "Delete All";
			controlDiv.appendChild(controlUIV1);
		  
			// Set CSS for the control interior.
			const controlTextV1 = document.createElement("div");
		  
			controlTextV1.style.color = "rgb(255,0,0)";
			controlTextV1.style.fontFamily = "Roboto,Arial,sans-serif";
			controlTextV1.style.fontSize = "16px";
			controlTextV1.style.lineHeight = "38px";
			controlTextV1.style.paddingLeft = "5px";
			controlTextV1.style.paddingRight = "5px";
			controlTextV1.innerHTML = "Del";
			controlUIV1.appendChild(controlTextV1);
			// Setup the click event listeners: simply set the map to Chicago.
			controlUIV1.addEventListener("click", () => {
				deleteAllShape();
			});
		  }
		var centerControlDiv = document.createElement('div');
        //var centerControl = new CenterControl(centerControlDiv, map);
		var CenterContro = new CenterControlV1(centerControlDiv, map);
        centerControlDiv.index = 1;
        map.controls[google.maps.ControlPosition.RIGHT_TOP].push(centerControlDiv);
	}

});
