appice.controller('analyticsController',function ($scope, $timeout, appIceService) {
	$scope.action = 'Run';
	$scope.isRun = true;
	$scope.isTarget = false;
	$scope.isGroup = false;
	$scope.isDownload = false;
	$scope.explore = {};
	$scope.exploreData = '';
	$scope.isError = false;
	$scope.eventList = [];
	$scope.timeList = [];

	// time drop down list
	$scope.timeList.push({time:'12:00 AM'});
	$scope.timeList.push({time:'12:15 AM'});
	$scope.timeList.push({time:'12:30 AM'});
	$scope.timeList.push({time:'12:45 AM'});
	
	var hours, minutes, ampm;
    for(var i = 60; i <= 1430; i += 15){
        hours = Math.floor(i / 60);
        minutes = i % 60;
        if (minutes < 10){
            minutes = '0' + minutes; // adding leading zero
        }
        ampm = hours % 24 < 12 ? 'AM' : 'PM';
        hours = hours % 12;
        if (hours === 0){
            hours = 12;
        }
        if (hours < 10){
        	hours = '0' + hours; // adding leading zero
        }
        
        $scope.timeList.push({time:hours + ':' + minutes + ' ' + ampm});
    }
    // add end min of day
    $scope.timeList.push({time:'11:59 PM'});
	
	$scope.getEvents = function(){
		var promise = appIceService.getEventList();
		promise.then(function(events) {
        	$scope.eventList = events.data;
    	});
	}
	$scope.getEvents();
	
	$scope.changeAnalyseType = function(){
		switch($scope.explore.analysis_type){
	    	case "count":
	    		$scope.isGroup = true;
	    		break;
	    	case "count_unique":
	    	case "minimum":
	    	case "maximum":
	    	case "sum":
	    	case "average":
	    	case "select_unique":
	    		$scope.isTarget = true;
	    		$scope.isGroup = true;
	    		break;	
	    	case "extraction":
	    		$scope.isTarget = false;
	    		$scope.isGroup = false;
	    		$scope.explore.target_property = '';
	    		$scope.explore.group_by = '';
	    		break;	
	    }
	}
	
	$timeout(function(){
		$(".analysis_type").select2();
		$(".event_lists").select2();
		$(".target_property").select2();
		$(".start_time_list").select2();
		$(".end_time_list").select2();
		$('#start_date').datepicker({
		      todayHighlight: true
		});
		$('#end_date').datepicker({
		      todayHighlight: true
		});
    }, 200);
	
	$scope.execute = function(){
		$scope.isError = false;
		$scope.error = "";
		
		if($scope.explore.analysis_type == undefined || $scope.explore.analysis_type == ''){
			$scope.isError = true;
			$scope.error = "Please choose analysis type";
			return false;
		}
		else{
			if($scope.isTarget){
				if($scope.explore.target_property == undefined || $scope.explore.target_property == ''){
					$scope.isError = true;
					$scope.error = "Please enter target property";
					return false;
				}
			}
		}
		
		if($scope.explore.event == undefined || $scope.explore.event == ''){
			$scope.isError = true;
			$scope.error = "Please choose event";
			return false;
		}
		
		if($scope.explore.startDate == undefined || $scope.explore.startDate == ''){
			$scope.isError = true;
			$scope.error = "Please select start date";
			return false;
		}
		
		if($scope.explore.startTime == undefined || $scope.explore.startTime == ''){
			$scope.isError = true;
			$scope.error = "Please select start time";
			return false;
		}
		
		if($scope.explore.endDate == undefined || $scope.explore.endDate == ''){
			$scope.isError = true;
			$scope.error = "Please select end date";
			return false;
		}

		if($scope.explore.endTime == undefined || $scope.explore.endTime == ''){
			$scope.isError = true;
			$scope.error = "Please select end time";
			return false;
		}
		
		
		if($scope.isRun){
			$('#exploreData').html('');
			$scope.isRun = false;
			$scope.action = "Fetching.....";
			var promise = appIceService.getEventExploreData($scope.explore);
			promise.then(function(exploreData) {
				$scope.isRun = true;
				$scope.action = "Run";
				if(exploreData){
					$scope.isDownload = true;
					$scope.dataObj = {};
					$scope.dataObj[$scope.explore.analysis_type] = JSON.stringify(exploreData.result);
					$('#exploreData').jsonView($scope.dataObj);
				}
		   	}, function(){
		   		$scope.isDownload = false;
		   		$scope.isRun = true;
				$scope.action = "Run";
		   	});
		}
		
		$scope.download = function(){
			var dataStr = "data:text/json;charset=utf-8," + encodeURIComponent(JSON.stringify($scope.dataObj));
			var dlAnchorElem = document.getElementById('downloadAnchorElem');
			dlAnchorElem.setAttribute("href",     dataStr     );
			dlAnchorElem.setAttribute("download", "data.json");
			//dlAnchorElem.click();
		}
	}
});