var appice = angular.module('appice', ['ngRoute','ui.tree']);
appice.config(function ($routeProvider) {
	$routeProvider
	   .when("/camp/view/:campId", {
   		 controller: "campaignDetailsController",
    	 templateUrl: "partials/campaignDetails.html"
  		})
		.when('/funnels/create',{
			controller: 'funnelsController',
			templateUrl: 'partials/funnels.html'
		}).when('/funnels/view',{
			controller: 'funnelsViewController',
			templateUrl: 'partials/funnelresults.html'
		}).when('/funnels/data', {
			controller: 'funnelsTableController',
			templateUrl: 'partials/funnelsTable.html'
		}).when('/usage', {
			controller: 'usagePageController',
			templateUrl: 'partials/usage.html'
		})
		.when('/events', {
			controller: 'eventsController',
			templateUrl: 'partials/events.html'
		})
		.when('/jobs/export', {
			controller: 'jobsController',
			templateUrl: 'partials/jobs-export.html'
		})
		.when('/jobs/export/:id', {
			controller: 'jobsController',
			templateUrl: 'partials/jobs-export.html'
		})
		.when('/aud/create',{
			controller: 'audienceController',
			templateUrl: 'partials/audience.html'
		}).when('/aud/create/true/:template_id/:templateType',{
			controller: 'audienceController',
			templateUrl: 'partials/audience.html'
		}).when('/aud/create/:fromcampaign',{
			controller: 'audienceController',
			templateUrl: 'partials/audience.html'
		}).when('/aud/view',{
			controller: 'audienceViewController',
			templateUrl: 'partials/audienceView.html'
		}).when('/aud/edit/:id',{
			controller: 'audienceController',
			templateUrl: 'partials/audience.html'
		}).when('/mod/view',{
			controller: 'globalAppModuleController',
			templateUrl: 'partials/globalAppModules.html'
		}).when('/mod/app/view',{
			controller: 'appModuleController',
			templateUrl: 'partials/appModules.html'
		}).when('/camp/create',{
			controller: 'campaignsController',
			templateUrl: 'partials/campaign.html'
		}).when('/temp',{
			controller: 'templatesController',
			templateUrl: 'partials/templates.html'
		}).when('/camp/create/:template_id/:templateType/:aud_id',{
			controller: 'campaignsController',
			templateUrl: 'partials/campaign.html'
		}).when('/camp/create/new',{
			controller: 'campaignsController',
			templateUrl: 'partials/campaign.html'
		}).when('/camp/edit/:id',{
			controller: 'campaignsController',
			templateUrl: 'partials/campaign.html'
		}).when('/app/groups',{
			controller: 'appGroupsController',
			templateUrl: 'partials/appGroups.html'
		}).when('/app/childapps',{
			controller: 'appChildController',
			templateUrl: 'partials/childApps.html'
		}).when('/users/getall',{
			controller: 'appUsersController',
			templateUrl: 'partials/appUsers.html'
		}).when('/users/details/:did',{
			controller: 'appUserDetailsController',
			templateUrl: 'partials/appUserDetails.html'
		}).when('/createchatbot',{
			controller: 'chatbotSettingController',
			templateUrl: 'partials/chatbot-setting.html'
		}).when('/createchatbot/dashboard/:app_id',{
			controller: 'chatbotSessionController',
			templateUrl: 'partials/chat-bot-session.html'
		}).when('/insides/inside',{
			controller: 'insidesController',
			templateUrl: 'partials/inside-custom.html'
		}).when('/campaigns',{
			controller: 'transitionalCampaignsController',
			templateUrl: 'partials/transitional-campaigns.html'
		}).when('/campaigns-details/:campid/:type/:ctype/:id',{
			controller: 'transitionalCampaignsController',
			templateUrl: 'partials/transitional-campaigns-detail.html'
		}).when('/analyticsview',{
			controller: 'analyticsController',
			templateUrl: 'partials/analytics.html'
		}).when('/aidql',{
			controller: 'rawDataController',
			templateUrl: 'partials/ai-dql.html'
		})
		// .when('/screenshotSettings', {
		// 	controller: 'screenshotController',
		// 	templateUrl: 'partials/settingScreenshot.html'
		// }).when('/sessionSetting/newScreenShot', {
		// 	controller: 'newScreenshotSettingController',
		// 	templateUrl: 'partials/newScreenshot.html'
		// })
		.when("/journey/table", {
			controller: "journeyTableController",
			templateUrl: "partials/journey-results.html"
		 }).when("/journey/create", {
			controller: "journeyCreateController",
			templateUrl: "partials/journey-create.html"
		 }).when("/journey/view", {
			controller: "journeyCreateController",
			templateUrl: "partials/journey-view.html"});//.otherwise({ redirectTo: 'funnels/view'});		
});

appice.filter('range', function() {
  return function(input, min, max) {
    min = parseInt(min);
    max = parseInt(max);
    for (var i=min; i<=max; i++)
      input.push(i);
    return input;
  };
});

appice.directive('validNumber', function() {
  return {
    require: '?ngModel',
    link: function(scope, element, attrs, ngModelCtrl) {
      if(!ngModelCtrl) {
        return; 
      }

      ngModelCtrl.$parsers.push(function(val) {
        if (angular.isUndefined(val)) {
            var val = '';
        }
        
        var clean = val.replace(/[^-0-9\.]/g, '');
        var negativeCheck = clean.split('-');
		var decimalCheck = clean.split('.');
        if(!angular.isUndefined(negativeCheck[1])) {
            negativeCheck[1] = negativeCheck[1].slice(0, negativeCheck[1].length);
            clean =negativeCheck[0] + '-' + negativeCheck[1];
            if(negativeCheck[0].length > 0) {
            	clean =negativeCheck[0];
            }
            
        }
          
        if(!angular.isUndefined(decimalCheck[1])) {
            decimalCheck[1] = decimalCheck[1].slice(0,2);
            clean =decimalCheck[0] + '.' + decimalCheck[1];
        }

        if (val !== clean) {
          ngModelCtrl.$setViewValue(clean);
          ngModelCtrl.$render();
        }
        return clean;
      });

      element.bind('keypress', function(event) {
        if(event.keyCode === 32) {
          event.preventDefault();
        }
      });
    }
  };
});

appice.filter("trust", ['$sce', function($sce) {
    return function(htmlCode){
        return $sce.trustAsHtml(htmlCode);
    }
}]);

