let winston = require('winston'), logger={}, moment = require('moment'), semusiConfig = require('./../config'), OS = require('os');
// winston.emitErrs = true;
let winstonLogger;

(function(logger){
    logger.init = function(filename, isDateWise){
        // check current host directory in logs direcotry
        //let hostDir = OS.hostname();
        //let path = semusiConfig.callbackLog+"/"+hostDir;
        let path = semusiConfig.callbackLog;
        // set log file name
        filename = path+"/"+filename;
        // add date time into log file name
        if(isDateWise){
            // let postFix = '';
            // let cmin = parseInt(moment().minutes())
            // if(cmin%semusiConfig.logFileTime == 0){
            //   postFix = moment().hour()+''+moment().minutes();
            // }
            // else{
            //   postFix = moment().hour()+''+parseInt(parseInt(cmin/semusiConfig.logFileTime)*semusiConfig.logFileTime);
            // }
            // // prepare log file name
            // filename += '_'+moment().year()+''+(moment().month()+1)+''+moment().date()+'_'+postFix;
            filename += '_'+moment().year()+''+(moment().month()+1)+''+moment().date();
        }
        // add file extension
        filename += '.log';

        // init winston log file with winston object
        winstonLogger = new winston.Logger({
            transports: [
                new winston.transports.File({
                    level: 'info',
                    filename: filename,
                    handleExceptions: true,
                    json: true,
                    //maxsize: 5242880, //5MB
                    //maxFiles: 5,
                    colorize: false
                })
            ],
            exitOnError: false
        });
    }

    logger.initWithPath = function(filename, isDateWise){
        winstonLogger = new winston.Logger({
            transports: [
                new winston.transports.File({
                    level: 'info',
                    filename: filename,
                    handleExceptions: true,
                    json: true,
                    //maxsize: 5242880, //5MB
                    //maxFiles: 5,
                    colorize: false
                })
            ],
            exitOnError: false
        });
    }

    logger.writeData = function(data){
        winstonLogger.info(data);
    }

    logger.query = function(options, callback){
        winstonLogger.query(options, function (err, results) {
            callback(err, results);
        });
    }

}(logger));

module.exports = logger;
