let cacheApi = {},
    Redis = require('ioredis'),
    logger = require("../../logger");
    semusiConfig = require('./../config');
    (function (cacheApi) {
  let client;
 // Managed Via Config
   if(semusiConfig.redisDefaultEnabledPassword == 'true' ){
    if(semusiConfig.isDefaultRedisClusterEnabled == 'true'){
        let redisClusterHostConfig = semusiConfig.redisClusterHost.split(' ');
        let keys = semusiConfig.KeysArray;
        let redisClusterHostData = [];
        for(let i=0; i < redisClusterHostConfig.length; i += keys.length){
            redisClusterHostData.push({"host":redisClusterHostConfig[i],"port":redisClusterHostConfig[i+1],"password":redisClusterHostConfig[i+2]});
        }
        client = new Redis.Cluster(redisClusterHostData);
    }else{
        client = new Redis({
            host: semusiConfig.redisServerHost,
            port: semusiConfig.redisServerPort,
            password: semusiConfig.redisServerPassword,
            no_ready_check: true,
          });
    }
}else{
    if(semusiConfig.isDefaultRedisClusterEnabled === "true"){
        let redisClusterHostConfig = semusiConfig.redisClusterHost.split(' ');
        let keys = semusiConfig.KeysArray;
        let redisClusterHostData = [];
        for(let i=0; i < redisClusterHostConfig.length; i += keys.length){
            redisClusterHostData.push({"host":redisClusterHostConfig[i],"port":redisClusterHostConfig[i+1]});
        }
        client = new Redis.Cluster(redisClusterHostData);
     }else{
        client = Redis.createClient(semusiConfig.redisServerPort,semusiConfig.redisServerHost,{no_ready_check: true}) 
     }
}

        client.on('connect', function() {
            logger.info('Redis connected.')
        });
    
        cacheApi.setKey = function (key, data) {
            client.set(key, data);
        }
    
        cacheApi.getKey = function (key, callback) {
            client.get(key, function (err, result) {
                if (err) {
                    logger.error("Error while retrieving the Key");
                }
                callback(err, result);
            });
        }
    
        cacheApi.deleteKey = function (key, callback) {
            client.del(key, function (err, result) {
                callback(err, result);
            });
        }
    
        cacheApi.expire = function (key, seconds) {
            client.expire(key, seconds);
        }
    
        cacheApi.addToSet = function (key, value, callback) {
            client.sadd(key, value);
            client.scard(key, function (err, data) {
                callback(data);
            });
        }
    
        cacheApi.addToSadd = function (key, value, callback) {
            client.sadd(key, value, function (err, data) {
                callback(data);
            });
        }
    
        cacheApi.getMembers = function (key, callback) {
            client.smembers(key, function (err, data) {
                callback(err, data);
            });
        }
    
        cacheApi.removeMember = function (key, member, callback) {
            client.srem(key, member, function (err, data) {
                callback(data);
            });
        }
        
        cacheApi.checkExpireTime = function (key, callback) {
            client.ttl(key, function (err, data) {
                callback(data);
            });
        }
        cacheApi.setKeywithTTL = async function (key, data,ttl) {
            client.set(key, data,'EX',ttl); 
        }
    
    }(cacheApi));
    
    module.exports = cacheApi;