let pushApi = {},         
    AWS = require('aws-sdk'),
    logger = require('../../logger'),
    semusiConfig = require('./../config');

(function (pushApi) {

    pushApi.sendPushAndroid = function (apikey,gcmid,content) {       

        AWS.config.region = semusiConfig.AWS_REGION;
        AWS.config.update({accessKeyId:semusiConfig.AWSLAMBDA_ACCESS_KEY_ID,
        secretAccessKey:semusiConfig.AWSLAMBDA_SECRET_KEY});

        let lambda = new AWS.Lambda({apiVersion: '2015-03-31'});

        let bufferData = {
          "platform": "gcm",
          "gcm_api_key": apikey,
          "tokens": [gcmid],
          "message": content,
          "collapse_key": "push_message",
          "delay_while_idle": false
        };

        let params = {
          FunctionName: 'AWS-Lambda-GCM-PushV1', /* required */
          InvocationType: 'RequestResponse',
          LogType: 'Tail',
          Payload: JSON.stringify(bufferData)
        };

        lambda.invoke(params, function(err, data) {
          if (err) {
            logger.error(`error==>>>> ${err} && err.stack =>>> ${err.stack}`);
          }  
           
        });

        return true;
    };


    pushApi.sendBulkPushAndroid = function (appid,apikey,gcmids,content) {       
        AWS.config.region = semusiConfig.AWS_REGION;
        AWS.config.update({accessKeyId:semusiConfig.AWSLAMBDA_ACCESS_KEY_ID,
        secretAccessKey:semusiConfig.AWSLAMBDA_SECRET_KEY});

        let lambda = new AWS.Lambda({apiVersion: '2015-03-31'});
        common.db.collection('apps').findOne({"_id":common.db.ObjectID(appid)},function(err,result)
          {
           if(result)
            { 
              let isappmodeproduction = false;
              if(result.isappmodeproduction)
              {
                isappmodeproduction = result.isappmodeproduction;
              }


            let bufferData = {
              "platform": "gcm",
              "appid":appid,
              "gcm_api_key": apikey,
              "tokens": gcmids,
              "message": content,
              "collapse_key": "push_message",
              "delay_while_idle": false,
              "isappmodeproduction":isappmodeproduction,
              "isproduction":semusiConfig.IsProduction
            };

            let params = {
              FunctionName: 'AWS-Lambda-GCM-PushV1', /* required */
              InvocationType: 'Event',
              LogType: 'Tail',
              Payload: JSON.stringify(bufferData)
            };

            lambda.invoke(params, function(err, data) {
              if (err) {
                logger.error(`error==>>>> ${err} && err.stack =>>> ${err.stack}`);
              }  
                 
            });
          }
        return true;
      });

    };


    pushApi.sendPushApple = function (certFileName,keyFileName,passphrase,apnId,content,isappmodeproduction) {
       
        AWS.config.region = semusiConfig.AWS_REGION;
        AWS.config.update({accessKeyId:semusiConfig.AWSLAMBDA_ACCESS_KEY_ID,
        secretAccessKey:semusiConfig.AWSLAMBDA_SECRET_KEY});

        let lambda = new AWS.Lambda({apiVersion: '2015-03-31'});
        

        let bufferData = {
          "appid":appid,
          "certFileName":certFileName,
          "keyFileName":keyFileName,
          "passphrase": passphrase,
          "apnId":apnId,
          "content":content,
          "isappmodeproduction":isappmodeproduction,
          "isproduction":semusiConfig.IsProduction
        };

        let params = {
          FunctionName: 'aws-lambda-apn-pushV1', /* required */
          InvocationType: 'Event',
          LogType: 'Tail',
          Payload: JSON.stringify(bufferData)
        };

        lambda.invoke(params, function(err, data) {
          if (err) {
            logger.error(`error==>>>> ${err} && err.stack =>>> ${err.stack}`);
          }  
             else
          {
            logger.info(`data ::> ${data}`);          // successful response
            logger.info(`message sent to ::> ${apnId}`); 
             
           }
        });    
        
        return true;
    };

    pushApi.sendBulkPushApple = function (appid,certFileName,keyFileName,passphrase,apnIds,content,isappmodeproduction) {
         
      logger.info('bulk apple push Notification');

        AWS.config.region = semusiConfig.AWS_REGION;
        AWS.config.update({accessKeyId:semusiConfig.AWSLAMBDA_ACCESS_KEY_ID,
        secretAccessKey:semusiConfig.AWSLAMBDA_SECRET_KEY});

        let lambda = new AWS.Lambda({apiVersion: '2015-03-31'});
        
        apnIds.forEach(function(deviceId){
            let bufferData = {
          "appid":appid,
          "certFileName":certFileName,
          "keyFileName":keyFileName,
          "passphrase": passphrase,
          "apnId":deviceId,
          "content":content,
          "isappmodeproduction":isappmodeproduction,
          "isproduction":semusiConfig.IsProduction
        };

        let params = {
          FunctionName: 'aws-lambda-apn-pushV1', /* required */
          InvocationType: 'RequestResponse',
          LogType: 'Tail',
          Payload: JSON.stringify(bufferData)
        };

        lambda.invoke(params, function(err, data) {
          if (err) {
            logger.error(`error==>>>> ${err} && err.stack =>>> ${err.stack}`);
          }  
               
        });    
    });

        return true;
    };


}(pushApi));

module.exports = pushApi;
