/*
 * Nested JSON to Flatten object
 * @Author Manish Yadav
 * @copyright Semusi Technologies Pvt Ltd @2018
 */

let flattened = {};
(function(flattened){
	flattened.convert2Flatten = function(data){
		flattened.keysData = {HKEYS:[]};
		// validate data param
		if(data){
			// validate data it should be with object or object
			if( (Array.isArray(data) && data.length > 0 )
					|| (Object.keys(data).length > 0 && data.constructor === Object) 
				){
			
				// check type cast 
				if(Array.isArray(data)){
					let events = [];
					// iterate data array
					data.forEach(function(element){
						let tmpData = [];
						// convert nested boject into flatten
						flattened.parseJSONObj(element);
						// delte header keys
						delete flattened.keysData.HKEYS;
						// push flatten object into array
						events.push(flattened.keysData);
						// blank flatten
						flattened.keysData = {HKEYS:[]};
					});

					// retrun flatten data
					return {err:null, data:events};
				}
				else{
					// convert nested boject into flatten
					flattened.parseJSONObj(data);
					// delte header keys
					delete flattened.keysData.HKEYS;
					// retrun flatten data
					return {err:null, data:flattened.keysData};
				}
			}
			else{
				// return message as error
				return {err:"Data not found!", data:""};
			}
		}
		else{
			// return message as error
			 
			return {err:"Data not found!", data:""};
		}
	}
	
	// get json keys list
	flattened.parseJSONObj = function(data){
		// get json object keys
		let parentKeys = flattened.getKeys(data);
		parentKeys.forEach(function(key){
			if(data[key]){
				if(data[key].constructor === Object){
					// call nested json keys function
					flattened.getNestedJSONKeysValues(data[key], key);
				}
				else {
					flattened.keysData.HKEYS.push(key);
					data[key] = (data[key] != '' && typeof data[key] == 'string' )? data[key].replace(new RegExp('\r?\n','g'), "") : data[key];
					flattened.keysData[key] = data[key];//(data[key] != '')? data[key].replace(/\t?\n/g, "") : data[key];
				}
			}
		});
		return;
	}
	
	// get nested json keys
	flattened.getNestedJSONKeysValues = function(obj, pKey){
		let objectKeys = [];
		let childKeys = flattened.getKeys(obj);
		childKeys.forEach(function(key){
			// check object key property
			if(obj[key] && obj[key].constructor === Object){
				objectKeys.push(key);
			}
			else {
				flattened.keysData.HKEYS.push(pKey+"_"+key);
				obj[key] = (obj[key] != '' && typeof obj[key] == 'string' )? obj[key].replace(new RegExp('\r?\n','g'), "") : obj[key];
				flattened.keysData[pKey+"_"+key] = obj[key];//(obj[key] != '')? obj[key].replace(/\t?\n/g, "") : obj[key];
			}
		});
		// check nested object keys
		if(objectKeys.length > 0){
			objectKeys.forEach(function(objKey){
				// push json key as column
				flattened.keysData.HKEYS.push(pKey+'_'+objKey);
				flattened.keysData[pKey+'_'+objKey] = '';
				// make flattern json nested keys
				flattened.getNestedJSONKeysValues(obj[objKey], pKey+'_'+objKey);
			});
		}
		else{
			return false;
		}
	}
	
	// get parent keys of json
	flattened.getKeys = function(obj){
		return Object.keys(obj);
	}
	
}(flattened));
module.exports = flattened;

