let dateFunctions = {},
    moment = require('moment');

(function (dateFunctions) {


    /**
    * Gets the common date format used for formatting dates.
    * @returns {string} - The date format string.
    */
    dateFunctions.getDateFormat = function(){
        return "MMM D, YYYY";
    }


    /**
    * Converts an epoch timestamp into a formatted date string.
    * The format of the returned string is YYYY_MM_DD.
    * @param {number} epoch - The epoch timestamp in milliseconds.
    * @returns {string} - The formatted date string in the format YYYY_MM_DD.
    */
    dateFunctions.convertEpochToFormattedDate = function (epoch) {
        return moment(parseInt(epoch)).format('YYYY_MM_DD');
    };

    
    /**
    * Converts an epoch timestamp into a formatted date string.
    * The format of the returned string is MMM D, YYYY.
    * @param {number} epoch - The epoch timestamp in milliseconds.
    * @returns {string} - The formatted date string in the format YYYY_MM_DD.
    */
    dateFunctions.ConvertEpochtoCommonFormatDate = function (epoch) {
        // return moment(dateStr, 'YYYY_MM_DD');
        return moment(parseInt(epoch)).format(dateFunctions.getDateFormat())
    };


    /**
    * Converts a formatted date string into a moment object.
    * The format of the input string is YYYY_MM_DD.
    * @param {string} dateStr - The date string in the format YYYY_MM_DD.
    * @returns {moment.Moment} - The corresponding moment object.
    */
    dateFunctions.parseFormattedDate = function (dateStr) {
        return moment(dateStr, 'YYYY_MM_DD');
    };


    /**
    * Checks if a given date string is within a range of start and end dates.
    * The format of the dates is YYYY_MM_DD.
    * @param {string} dateToCheck - The date string to check.
    * @param {string} startDate - The start date of the range.
    * @param {string} endDate - The end date of the range.
    * @returns {boolean} - True if the dateToCheck is within the range, false otherwise.
    */
    dateFunctions.isDateInRange = function (dateToCheck, startDate, endDate) {
        const checkDate = dateFunctions.parseFormattedDate(dateToCheck);
        const start = dateFunctions.parseFormattedDate(startDate);
        const end = dateFunctions.parseFormattedDate(endDate);
        return checkDate.isBetween(start, end, null, '[]'); // Inclusive range
    };

}(dateFunctions));

module.exports = dateFunctions;
