let commonEvent = {},
	dataProducer = require('./common.data.producer.js');
    common = require('./common.js');
    logger = require('../../logger');

(function(commonEvent){
	//send events to queue
    commonEvent.sendEvent = function(dataObj){
        let obj = {
            app_id : dataObj.app_id,
            device_id:dataObj.did,
            app_key:dataObj.app_key,
            user_id: '',
            events:[],
            key : "uninstall",
            ip : dataObj.ip
        };
        logger.info(`Object Data => ${dataObj}`)
        let event = {}
        event._tz = 19800;
        event.key = dataObj.key;
        event.timestamp = common.getCurrentEpochTime();
		event.eventTime = common.getCurrentEpochTime();
		event.did = dataObj.did;
		event.appid = dataObj.app_id;
		event.rtime = common.getCurrentEpochTime();
		event.utime = common.getCurrentEpochTime();
        event.context = {};
        // check last event
        if(dataObj.le){
            event.context = dataObj.le.c;
            // set event into obj
            obj.events.push(event);
            logger.info(`Object Data => ${dataObj}`)
            dataProducer.writeDataDirectly(obj);
        }
    }
}(commonEvent));
module.exports = commonEvent;
