let deviceImport={},
	semusiConfig = require('./../config'),
	client = require('node-rest-client').Client;

let proxy = new client();

(function (deviceImport) {

	deviceImport.registerDevice = function(data,callback){
				
		let url = semusiConfig.APIUrl+"/i/V1/initialize?";
		//Add url parameters
		url+="app_id="+data.app_id;
		url+="&app_key="+data.app_key;
		url+="&api_key="+data.api_key;
		url+="&device_id="+data.device_id;
		url+="&inittime="+data.inittime;
		url+="&timestamp="+data.timestamp;
		url+="&metrics="+data.metrics;
		url+="&moreInfo="+data.moreInfo;
		if(data.ip){
			url+="&ip_address="+data.ip;
		}
		url+="&skipPreviousDateCheck=true";
		
		
		let args = {};
			
		proxy.get(url, args, function(data,response) {		    		    
	    	let resp = JSON.parse(data.toString());	
		    resp.statusCode = response.statusCode;
		    callback(resp);		    
		});    		
	}

	deviceImport.updateDeviceMetaData = function(data,callback){
				
		let url = "https://a.appice.io/i/V1/updateDeviceMetaData?";//semusiConfig.APIUrl+"/i/V1/initialize?";
		//Add url parameters
		url+="app_id="+data.app_id;
		url+="&app_key="+data.app_key;
		url+="&api_key="+data.api_key;
		url+="&device_id="+data.device_id;
		url+="&args="+data.args;				
		let args = {};
			
		proxy.get(url, args, function(data,response) {		    		    
	    	let resp = JSON.parse(data.toString());	
		    resp.statusCode = response.statusCode;
		    callback(resp);		    
		});    		
	}

}(deviceImport));

module.exports = deviceImport;