let dataProducer = {},
	common = require('./common.js'),
	pgsql = require('./pgsql.utils.js'),
	semusiConfig = require('../config.js')
	azureHelper = require('./../parts/data/azure.data.js');

(function (dataProducer) {

	dataProducer.writeData = function(params){
		azureHelper.writeAPIDataToSQS(params.QueueObject,function(status){
			if(status){
				common.returnMessage(params,200,"Success");
			}
			else{
				common.returnMessage(params,400,"Failure");
			}
		});
	};

	dataProducer.writeDataDirectly = function(data){
		// check if processing is working through PG 
		if(semusiConfig.isPgProcessorEnabled){
			pgsql.writeCsvDataToPgQueue(data,function(status){
				return status;
			});
		}else{
			azureHelper.writeAPIDataToSQS(data,function(status){
				return status;
			});			
		}
	};

	dataProducer.writeDataToSQS = function(data, callback){
			azureHelper.writeAPIDataToSQS(data,function(status){
				return callback(status);
			});
	};
}(dataProducer));

module.exports = dataProducer;
