let campaignDb = {},
common = require('./common.js');

(function (campaignDb) {



     /**
     * Retrieves campaign data from the 'campaigns_APPID' collection based on the provided campaign ID.
     * 
     * @param {string} app_id - The appID used to determine the collection name.
     * @param {string} cid - The unique campaign ID to search for in the collection.
     * @returns {Promise<Object>} - A promise that resolves to the campaign object if found, or an empty object if not found.
     */
    campaignDb.retrieveCampData =  async function (app_id,cid) {
        return new Promise((resolve, reject) => {
            // Querying the 'campaigns_APPID' collection in the database to find the campaigns associated with the passed cid.
            common.db.collection('campaigns_' + app_id).findOne({'_id':common.db.ObjectID( cid) }, (err, campaign) => {
                if (err) {
                    logger.error(`Error while retrieving campign from camps_appid`)
                    resolve({});
                } else {
                    // If no error occurs and the Campaign is found, resolve the Promise with the retrieved campaign object
                    // or an empty object if no campaign are found.
                    resolve(campaign || {});
                }
            });
        });
    }

    /**
     * Retrieves multiple campaign statistics from the 'timely_campaign_statsdata' collection based on an array of IDs.
     *  Arrays should be in the form of  appid+Campid+Date 
     * @param {Array} array - An array of campaign IDs to search for in the collection.
     * @returns {Promise<Array>} - A promise that resolves to an array of campaign statistics objects if found, or an empty array if not found.
     */
    campaignDb.retrieveCampDataFromTimely_campaign_statsdata =  async function (array) {
        return new Promise((resolve, reject) => {
            // Querying the 'campaign_statsdata_' collection in the database to find the campaigns associated with the passed cid.
            common.db.collection("timely_campaign_statsdata").find({ _id: { $in: array } }).toArray(function(err,campDetails){
                if (err) {
                    resolve([]);
                } else {
                    // If no error occurs and the Campaign is found, resolve the Promise with the retrieved campaign object
                    // or an empty object if no campaign are found.
                    resolve(campDetails || []);
                }
            });
        });
    }
       /**
     * Retrieves campaign data from the 'campaign_statsdata_APPID' collection based on the provided campaign ID.
     * 
     * @param {string} app_id - The application ID used to determine the collection name.
     * @param {string} cid - The unique campaign ID to search for in the collection.
     * @returns {Promise<Object>} - A promise that resolves to the campaign object if found, or an empty object if not found.
     */
    campaignDb.retrieveCampDataFromStatsData =  async function (app_id,cid) {
        return new Promise((resolve, reject) => {
            // Querying the 'campaign_statsdata_' collection in the database to find the campaigns associated with the passed cid.
            common.db.collection('campaign_statsdata_' + app_id).findOne({'_id': cid }, (err, campaign) => {
                if (err) {
                    resolve({});
                } else {
                    // If no error occurs and the Campaign is found, resolve the Promise with the retrieved campaign object
                    // or an empty object if no campaign are found.
                    resolve(campaign || {});
                }
            });
        });
    }


}(campaignDb))
module.exports = campaignDb;
