var matTune_Callback = {},
    common = require('./../utils/common.js')
    request = require('request');

(function (matTune_Callback) {

    matTune_Callback.DateFormat={
        "format":"yyyy-mm-dd hh:mm:ss",
        "dateSeparator":"-",
        "dateTimeSeparator":" ",
        "timeSeparator":":",
        "dayIndex":2,
        "monthIndex":1,
        "yearIndex":0,
        "hourIndex":0,
        "minuteIndex":1,
        "secondIndex":2,
        "milliSeconIndex":-1
    };


matTune_Callback.getParamsObj= function(objIn,data){
    var dtEntry = '';
    var tmpIUObj = {}; 

    //sample data is in the form of 
    //ad_network_id={ad_network_id}&advertiser_id={advertiser_id}&advertiser_name={advertiser_name}&agency_id={agency_id}&android_id={android_id}&app_ad_tracking_disabled={app_ad_tracking_disabled}&app_version={app_version}&conversion_referral={conversion_referral}&conversion_user_agent={conversion_user_agent}&country_code={country_code}&currency_code={currency_code}&device_brand={device_brand}&device_carrier={device_carrier}&device_ip={device_ip}&device_model={device_model}&device_type={device_type}&event_name=Install&google_aid={google_aid}&impression_timestamp={impression_timestamp}&ios_ifa={ios_ifa}&ios_ifv={ios_ifv}&is_view_through={is_view_through}&language={language}&match_type={match_type}&os_jailbroke={os_jailbroke}&os_version={os_version}&package_app_version={package_app_version}&package_name={package_name}&site_name={site_name}&timestamp={timestamp}&tracking_id={tracking_id}&windows_aid={windows_aid}
                    
    objIn.time = common.initTimeObj(objIn.appTimezone, data.timestamp);
    dtEntry=common.initTimeObj(objIn.appTimezone, data.timestamp);
    objIn.user.country = data.country_code;
    objIn.ip_address = data.device_ip;
    objIn.qstring.metrics._ref = (data.conversion_referral != null)  ? data.conversion_referral : data.advertiser_name;
    objIn.qstring.metrics._app_version=data.package_app_version;
    objIn.qstring.metrics._device= data.device_brand + ' ' + data.device_model ;                     
    objIn.qstring.metrics._os_version=data.os_version;
    objIn.qstring.metrics["_custom_clicktime"]= common.initTimeObj(objIn.appTimezone, common.getEpochTime(data.impression_datetime,matTune_Callback.DateFormat));
    objIn.qstring.metrics._carrier=data.device_carrier;

    if(data.google_aid)
    {
        objIn.qstring.metrics._os='Android';
        objIn.qstring.device_id = data.google_aid;
    }
    else if(data.ios_ifa)
    {
        objIn.qstring.metrics._os='iOS';
        objIn.qstring.device_id = data.ios_ifa;   
    }
   

    var cpi = 0.0;
    var historyObject={
                        'refname': objIn.qstring.metrics._ref,
                        'type':'I',
                        'dtEntry': dtEntry,
                        'ip_address':data.ip
                    };
                    
    historyObject.cpi = cpi;

    common.fillTimeObject(objIn,tmpIUObj,"T",1); 
    common.fillTimeObject(objIn,tmpIUObj,"I",1); 
    objIn.historyObject = historyObject;
    return objIn;
};

}(matTune_Callback));

module.exports = matTune_Callback;