var apsalar_Callback = {},
    common = require('./../utils/common.js'),
    moment = require('moment'),
    request = require('request');

(function (apsalar_Callback) {

   
apsalar_Callback.createAppUserObject = function(data){
    var appUser = {};   
    appUser.app_id = data.APPID;
    appUser.app_key = data.APPKEY;
    appUser.api_key = data.APIKEY;                        
        
    var keys = Object.keys(data);
    appUser.metrics={
        "_locale":"en_US",  
        "_ref":"",                                                                                            
        "context":{"where" : {"location" : {"place" : "other"},"geo" : {}}},                                    
        "_installer":"Apsalar",
        "_device":""
    };
    appUser.moreInfo={};
    if(keys.length>0){
        keys.forEach(function(key){                             
            switch(key){
                case "appver":{
                    appUser.metrics['_app_version'] = data[key];
                    appUser.metrics['_app_version'] = data[key].toString();
                    break;
                }                
                case "osver":{
                    appUser.metrics['_os_version'] = data[key].toString();
                    break;
                }
                case "platform":{
                    appUser.metrics['_os'] = getParameterValue(data[key]);
                    break;
                }                                                                              
                case "InstallTime":{                                                 
                    var installtime = data[key].replace('_'," ");
                    if(new Date(installtime)!== "Invalid Date"){                            
                        appUser.metrics['_tz']=0                                                                        
                        appUser.timestamp = (moment(new Date(installtime)).valueOf()/1000);
                        appUser.inittime = appUser.timestamp;   
                        appUser.moreInfo['ls'] = appUser.timestamp;
                           
                    }
                    else{
                        appUser.timestamp=undefined;
                    }                                                                                                                                     
                    break;
                }                    
                case "carrier":{
                    appUser.metrics['_carrier'] = getParameterValue(data[key]);
                    break;
                }
                case "city":{
                    appUser.moreInfo['cty'] = data[key];
                    break;
                }
                case "country":{
                    appUser.moreInfo['cc'] = data[key];
                    appUser.moreInfo['country'] = data[key];
                    break;
                }                                                                            
                case "FBCampaignName":
                case "campaign":{
                    if(data['FBCampaignName']!=null && data['FBCampaignName']!="" && data['FBCampaignName'].toLowerCase()!='none' && appUser.metrics._ref.indexOf('utm_source')<0){
                        appUser.metrics._ref +=  "%26utm_source="+data['FBCampaignName'];   
                    }
                    else if(data['campaign']!=null && data['campaign']!="" && data['campaign']!="Unattributed" && appUser.metrics._ref.indexOf('utm_source')<0){
                        appUser.metrics._ref +=  "%26utm_source="+data['campaign'];      
                    }
                    else if(appUser.metrics._ref.indexOf('utm_source')<0){
                        appUser.metrics._ref += "%26utm_source=self";
                    }
                    break;
                }
                case "site":{
                    if(data[key]!=null){
                        appUser.metrics._ref += "%26utm_medium="+data[key];
                    }
                    break;    
                }
                case "device_brand":{
                    if(data[key]!=null){
                        appUser.metrics._device = (data['device_model'])? data[key]+" "+data['device_model'] : data[key];
                    }
                    break;    
                }
                case "campaign":{
                    if(data['campaign']!=null){
                        appUser.metrics._ref += "%26utm_campaign="+data['campaign']; 
                    }
                    break;                              
                }                                
                case "aifa":
                case "iafa":
                case "AndroidID":{
                    if(data['aifa'] || data['iafa']){
                        appUser.device_id = data[key];
                        appUser.moreInfo['android_id'] = data['AndroidID']; 
                    }
                    else if(data['AndroidID']){
                        appUser.device_id = data[key];    
                        appUser.moreInfo['android_id'] = data['AndroidID'];
                    }                    
                    break;                              
                }
                case "idfa":{
                    appUser.device_id = data[key];
                    break;
                }                
                case "IP":{
                    if(data[key]!=null){
                        appUser.metrics.ip = data[key];                        
                        appUser.metrics.ip = data[key];  
                        appUser.ip = data[key];                      
                    }
                    break;
                    
                }                
            }
        });     
    }   
    
    if(appUser.timestamp===undefined || appUser.device_id===undefined || appUser.device_id===null){
         
        //var log = fs.createWriteStream("missingcreatedate.json", {'flags': 'a'});       
        //log.end(JSON.stringify(data,null,4)+",");

        return undefined;
    }

    appUser.args = {"_ref":appUser.metrics._ref};
    appUser.metrics = JSON.stringify(appUser.metrics);
    appUser.moreInfo = JSON.stringify(appUser.moreInfo);
    if(appUser.metrics['_os_version']==null || appUser.metrics['_os_version']==""){
        appUser.metrics['_os_version']="NA";
    }
    if(appUser.metrics['_app_version']==null || appUser.metrics['_app_version']==""){
        appUser.metrics['_app_version']="NA";
    }
    if(appUser.moreInfo['cty'] == null || appUser.moreInfo['cty'] == ""){
        appUser.moreInfo['cty'] = "NA";
    }
    if(appUser.moreInfo['cc'] == null || appUser.moreInfo['cc'] == ""){
        appUser.moreInfo['cc'] = "NA";
        appUser.moreInfo['country'] = "NA";
    }

    if(appUser.metrics['_os_version']==null || appUser.metrics['_os_version']==undefined || appUser.metrics['_os_version']==""){
        appUser.metrics['_os_version']="NA";
    }
    if(appUser.metrics['_app_version']==null || appUser.metrics['_app_version']==undefined || appUser.metrics['_app_version']==""){
        appUser.metrics['_app_version']="NA";
    }
    if(appUser.moreInfo['cty'] == null || appUser.moreInfo['cty'] == undefined ||  appUser.moreInfo['cty'] == ""){
        appUser.moreInfo['cty'] = "NA";
    }
    if(appUser.moreInfo['cc'] == null || appUser.moreInfo['cc'] == undefined || appUser.moreInfo['cc'] == ""){
        appUser.moreInfo['cc'] = "NA";
        appUser.moreInfo['country'] = "NA";
    }
    return appUser;

}

function getParameterValue(value){
    if(value && typeof(value)=='string'){
        return common.toFirstUpper(value.replace(/^\$/, ""));
    }
    else if(value && typeof(value)!='string'){
        return value;
    }
    else{
        return "";
    }
}


}(apsalar_Callback));

module.exports = apsalar_Callback;