var appsFlyer_Callback = {},
    common = require('./../utils/common.js'),
    moment = require('moment'),
    request = require('request');

(function (appsFlyer_Callback) {


appsFlyer_Callback.createAppUserObject = function(data){
    var appUser = {};
    appUser.app_id = data.APPID;
    appUser.app_key = data.APPKEY;
    appUser.api_key = data.APIKEY;

    var keys = Object.keys(data);
    appUser.metrics={
        "_locale":"en_US",
        "_ref":"",
        "context":{"where" : {"location" : {"place" : "other"},"geo" : {}}}
        //"_installer":"AppsFlyer"
    };
    appUser.moreInfo={};
    if(keys.length>0){
        keys.forEach(function(key){
            switch(key){
                case "app_version":{
                    appUser.metrics['_app_version'] = data[key].toString();
                    break;
                }
                case "device_brand":
                case "device_model":{
                    var device ="";
                    var manufacturer = (data['device_brand'])? data['device_brand']+" ":"";
                    var model = (data['device_model'])? data['device_model']:"";
                    if(model && typeof(model)=='string' && model.indexOf(manufacturer)==0){
                        device = model;
                    }
                    else{
                        device = manufacturer+model;
                    }
                    appUser.metrics['_device'] = getParameterValue(device);
                    break;
                }
                case "os_version":{
                    appUser.metrics['_os_version'] = data[key].toString();
                    break;
                }
                case "platform":{
                    appUser.metrics['_os'] = getParameterValue(data[key]);
                    break;
                }
                case "install_time":{
                    if(new Date(data[key])!== "Invalid Date"){
                        appUser.metrics['_tz']=0
                        appUser.timestamp = (moment(new Date(data[key])).valueOf()/1000);
                        appUser.inittime = appUser.timestamp;
                        appUser.moreInfo['ls'] = appUser.timestamp;

                    }
                    else{
                        appUser.timestamp=undefined;
                    }
                    break;
                }
                case "carrier":{
                    appUser.metrics['_carrier'] = getParameterValue(data[key]);
                    break;
                }
                case "city":{
                    appUser.moreInfo['cty'] = data[key];
                    break;
                }
                case "country_code":{
                    appUser.moreInfo['cc'] = data[key];
                    appUser.moreInfo['country'] = data[key];
                    break;
                }
                case "attribution_type":{
                    if(data['attribution_type']!=null &&  data['attribution_type'].toLowerCase()=='organic'){
                       appUser.metrics._ref += "%26utm_source=self";
                    }
                    break;
                }
                case "campaign":
                case "fb_campaign_name":
                case "af_channel":{
                    if(data['campaign']!=null && data['campaign']!="" && data['campaign'].toLowerCase()!='none' && appUser.metrics._ref.indexOf('utm_source')<0){
                        var campaign = (data['af_channel'])? data['af_channel'] : data['campaign'];
                        appUser.metrics._ref +=  "%26utm_source="+campaign;
                    }
                    else if(data['af_channel']!=null && data['af_channel']!="" && appUser.metrics._ref.indexOf('utm_source')<0){
                        appUser.metrics._ref +=  "%26utm_source="+data['af_channel'];
                    }
                    else if(data['fb_campaign_name']!=null && data['fb_campaign_name']!="" && appUser.metrics._ref.indexOf('utm_source')<0){
                        appUser.metrics._ref +=  "%26utm_source="+data['fb_campaign_name'];
                    }
                    else if(appUser.metrics._ref.indexOf('utm_source')<0){
                        appUser.metrics._ref += "%26utm_source=self";
                    }
                    break;
                }
                case "media_source":{
                    if(data[key]!=null){
                        appUser.metrics._ref += "%26utm_medium="+data[key];
                    }
                    break;
                }
                case "agency":{
                    if(data[key]!=null){
                        appUser.metrics._ref += "%26utm_campaign="+data[key];
                    }
                    else if(data['campaign']!=null){
                        appUser.metrics._ref += "%26utm_campaign="+data['campaign'];
                    }
                    break;
                }
                case "af_cost_currency":{
                    if(data[key]!=null){
                        appUser.metrics._ref += "%26cost_currency="+data[key];
                    }
                    break;
                }
                case "af_cost_model":{
                    if(data[key]!=null){
                        appUser.metrics._ref += "%26cost_model="+data[key];
                    }
                    break;
                }
                case "af_cost_value":{
                    if(data[key]!=null){
                        appUser.metrics._ref += "%26cost_value="+data[key];
                    }
                    break;
                }
                case "cost_per_install":{
                    if(data[key]!=null){
                        appUser.metrics._ref += "%26cost_value="+data[key];
                    }
                    break;
                }
                case "fb_adset_name":{
                    if(data[key]!=null){
                        appUser.metrics._ref += "%26fb_adset_name="+data[key];
                    }
                    break;
                }
                case "fb_adgroup_name":{
                    if(data[key]!=null){
                        appUser.metrics._ref += "%26fb_adgroup_name="+data[key];
                    }
                    break;
                }
                case "advertising_id":
                case "android_id":{
                    if(data['advertising_id']){
                        appUser.device_id = data[key];
                        appUser.moreInfo['android_id'] = data['android_id'];
                    }
                    else if(data['android_id']){
                        appUser.device_id = data[key];
                        appUser.moreInfo['android_id'] = data['android_id'];
                    }
                    break;
                }
                case "idfa":{
                    appUser.device_id = data[key];
                    break;
                }
                case "appsflyer_device_id":{
                    appUser.moreInfo['appsflyer_device_id']=data[key];
                    break;
                }
                case "af_channel":{
                    if(data[key]!=null){
                        appUser.moreInfo['_custom_Channel'] = data[key];
                    }
                    break;
                }
                case "ip":{
                    if(data[key]!=null){
                        appUser.metrics.ip = data[key];
                        appUser.ip = data[key];
                    }
                    break;

                }
                case "imei":{
                    if(data[key]!=null){
                        appUser.moreInfo['imei'] = data[key];
                    }
                    break;
                }
            }
        });
    }

    if(appUser.timestamp===undefined || appUser.device_id===undefined || appUser.device_id===null){
         
        //var log = fs.createWriteStream("missingcreatedate.json", {'flags': 'a'});
        //log.end(JSON.stringify(data,null,4)+",");

        return undefined;
    }

    appUser.args = {"_ref":appUser.metrics._ref};
    appUser.metrics = JSON.stringify(appUser.metrics);
    appUser.moreInfo = JSON.stringify(appUser.moreInfo);


    return appUser;

}

function getParameterValue(value){
    if(value && typeof(value)=='string'){
        return common.toFirstUpper(value.replace(/^\$/, ""));
    }
    else if(value && typeof(value)!='string'){
        return value;
    }
    else{
        return "";
    }
}


}(appsFlyer_Callback));

module.exports = appsFlyer_Callback;
