var appsFlyer = {},
    common = require('./../utils/common.js'),
    fs = require('fs');
    request = require('request');
	csvparse = require('csv');


(function (appsFlyer) {

    //0 index is field name, 1 index is field index from file. 
    //So that if column sequence is later changed we have the actual index generted from file.
    appsFlyer.FieldList=[
        ["Install Time",-1],
        ["Click Time",-1],
        ["Android Id",-1],
        ["IDFA",-1],
        ["Country Code",-1],
        ["Media Source (pid)",-1],
        ["City",-1],
        ["Device Type",-1],
        ["OS Version",-1],
        ["App Version",-1],
        ["Agency/PMD (af_prt)",-1],
        ["Campaign (c)",-1],
        ["Site Id (af_siteid)",-1],
        ["Cost Per Install (af_cpi)",-1],
        ["IP",-1],
        ["WIFI",-1],
        ["Language",-1],
        ["Appsflyer Device Id",-1],
        ["Customer User Id",-1],
        ["IMEI",-1],
        ["MAC",-1],
        ["Advertising Id",-1],
        ["SDK Version",-1],
        ["Operator",-1],
        ["Carrier",-1],
        ["Platform",-1]
    ];


    appsFlyer.DateFormat1={
    	"format":"dd/mm/yy hh:mm",
        "dateSeparator":"/",
        "dateTimeSeparator":" ",
        "timeSeparator":":",
        "dayIndex":0,
        "monthIndex":1,
        "yearIndex":2,
        "hourIndex":0,
        "minuteIndex":1,
        "secondIndex":-1,
        "milliSeconIndex":-1
    };

    appsFlyer.DateFormat2={
    	"format":"yyyy-mm-dd hh:mm:ss",
        "dateSeparator":"-",
        "dateTimeSeparator":" ",
        "timeSeparator":":",
        "dayIndex":2,

        "monthIndex":1,
        "yearIndex":0,
        "hourIndex":0,
        "minuteIndex":1,
        "secondIndex":2,
        "milliSeconIndex":-1
    };

    appsFlyer.delimiterChar = ',';

    appsFlyer.getFieldList = function(data){
        var fields=appsFlyer.FieldList;
        for (var i = 0; i<fields.length ; i++) {
            for(var j=0;j<data[0].length;j++){
                if(fields[i][0]==data[0][j]){
                    fields[i][1]=j;
                    break;
                }
            }   
        }

        return fields;
    };

    appsFlyer.getDateFormat= function(data){
    	var dateValue;

        if(data.length > 0)
        {
            dateValue=data[0][1];    
        }

        if(dateValue)
        {
        	if(dateValue.length==appsFlyer.DateFormat1.format.length && dateValue.indexOf(appsFlyer.DateFormat1.dateSeparator)>0 && dateValue.indexOf(appsFlyer.DateFormat1.timeSeparator)>0 && dateValue.indexOf(appsFlyer.DateFormat1.dateTimeSeparator)>0){
        		return appsFlyer.DateFormat1;
        	}
        	else if(dateValue.length==appsFlyer.DateFormat2.format.length && dateValue.indexOf(appsFlyer.DateFormat2.dateSeparator)>0 && dateValue.indexOf(appsFlyer.DateFormat2.timeSeparator)>0 && dateValue.indexOf(appsFlyer.DateFormat2.dateTimeSeparator)>0){
        		return appsFlyer.DateFormat2;
        	}
        } 
        else
        {
            return appsFlyer.DateFormat1;
        }  
    };

}(appsFlyer));

module.exports = appsFlyer;