var runCampaign = {}, 
	semusiConfig = require('./../../config'),
	logger = require('../../../logger'),
	netcoreEmailAPI = require('./netcore-email'),
	smsAPI = require('./sms');

let appsList = semusiConfig.campaignsApps,
		    counter = 0;

(function(runCampaign){
	runCampaign.emailCampaign = function(){
		counter = 0;
		function checkCampaignAppWise(counter){
		    if(appsList[counter]){
		        netcoreEmailAPI.getAllAppsIds(appsList[counter],function(error, apps){
		            if(error){
		                logger.error(`apps list error=> ${error}`); 
		            }
		            else{
		                netcoreEmailAPI.processActiveCampaigns(apps, function(status){
							logger.info(`email status :: +> ${status}`);
		                    counter++;
		                    checkCampaignAppWise(counter);
		                });
		            }
		        });
		    }
		    else{
				logger.info('Done email script');  
		       //process.exit(1);
		    }
		}

		checkCampaignAppWise(counter);
	}

	runCampaign.smsCampaign = function(){
		counter = 0;
		function checkSMSCampaignAppWise(counter){
		    if(appsList[counter]){
		        smsAPI.getAllAppsIds(appsList[counter].app_id,function(error, apps){
		            if(error){
						logger.error(`error=> ${error}`);     
		            }
		            else{
		                smsAPI.processActiveCampaigns(apps, function(status){
							logger.info(` status :: +> ${status}`);  
		                    counter++;
		                    checkSMSCampaignAppWise(counter);
		                });
		            }
		        });
		    }
		    else{
		        logger.info('Done script');
		       process.exit(1);
		    }
		}

		checkSMSCampaignAppWise(counter);
	}

}(runCampaign));

runCampaign.emailCampaign();
runCampaign.smsCampaign();
