/**
 * Consumer that consume data from error queue and send to worker for process it.
 * @Author Semusi Technologies Pvt Ltd.
 * @Copyright appICE.io @2017
 */

const consumer = require('sqs-consumer'),
logger = require('../../../logger'),
	semusiConfig = require('./../../config'),
	errorConsumer = require('./../../utils/error.queue.worker'),
	AWS = require('aws-sdk');

AWS.config.region = semusiConfig.AWS_REGION;
AWS.config.update({accessKeyId:semusiConfig.AWS_ACCESS_KEY_ID,secretAccessKey:semusiConfig.AWS_SECRET_KEY});

var app = consumer.create({
	queueUrl: semusiConfig.apiQueueMap['errors'],
	region: semusiConfig.AWS_REGION,
	batchSize: 10,
	handleMessage: function (message, done) {
		try{
			var dataObject = JSON.parse(message.Body);
			//Construct consumer compatible object.
			var data = [dataObject];
            errorConsumer.processData(data,function(status){
                if(status){
                    done();
                }
                return;
            });
            /*
            switch(dataObject.method){
                case "processBeginSessionData":
                {
                    errorConsumer.processBeginSessionData(data,function(status){
                        if(status){
                            done();
                        }
                    });
                    break;
                }
                case "processEndSessionData":
                {
                    errorConsumer.processEndSessionData(data,function(status){
                        if(status){
                            done();
                        }
                    });
                    break;
                }
                case "processEvents":
                {
                    errorConsumer.processEvents(data,function(status){
                        if(status){
                            done();
                        }
                    });
                    break;
                }
                case "processCompetingApps":
                {
                    errorConsumer.processCompetingApps(data,function(status){
                        if(status){
                            done();
                        }
                    });
                    break;
                }
                case "processDeviceUpdates":
                {
                    errorConsumer.processDeviceUpdates(data,function(status){
                        if(status){
                            done();
                        }
                    });
                    break;
                }
                case "updateUserInfo":
                {
                    errorConsumer.updateUserInfo(data,function(status){
                        if(status){
                            done();
                        }
                    });
                    break;
                }
                case "updateUserHb":
                {
                    errorConsumer.updateUserHb(data,function(status){
                        if(status){
                            done();
                        }
                    });
                    break;
                }
                case "processAppUpdates":
                {
                    errorConsumer.processAppUpdates(data,function(status){
                        if(status){
                            done();
                        }
                    });
                    break;
                }
                case "processCampaignResponses":
                {
                    errorConsumer.processCampaignResponses(data,function(status){
                        if(status){
                            done();
                        }
                    });
                    break;
                }
                case "processEventAttribute":
                {
                    errorConsumer.processEventAttribute(data,function(status){
                        if(status){
                            done();
                        }
                    });
                    break;
                }
            }
            */
		}
	    catch(e){
            logger.error(`Catch error ${e}`);
    		logger.info(`message => ${message}`);
    		done();
    	}
	}
});

app.on('error', function (err) {
    logger.error(`There is an error while processing message. ${err.message}`); 
  	//done(err);
});

app.start();
