var consumer = require('sqs-consumer'),
logger = require('../../../logger'),
	semusiConfig = require('./../../config'),
	dataConsumer = require('./../../utils/screenshot-worker'),
	AWS = require('aws-sdk');

AWS.config.region = semusiConfig.AWS_REGION;
AWS.config.update({accessKeyId:semusiConfig.AWS_ACCESS_KEY_ID,secretAccessKey:semusiConfig.AWS_SECRET_KEY});

var app = consumer.create({
	queueUrl: semusiConfig.apiQueueMap['session_record'],
	region: semusiConfig.AWS_REGION,
	batchSize: 10,
	handleMessage: function (message, done) {
		try{
			var dataObject = JSON.parse(message.Body);
			dataObject.MessageId = message.MessageId; // add sqs message id
			switch(dataObject.key){
				case "session_record":
				{
					dataConsumer.screenRecordingData(dataObject,function(status){
						if(status){
							done();
						}
					});
					break;
				}
			}
		}
	    catch(e){
			logger.error(`session record catch error ${e}`);
    		logger.info(`message>>> ${message}`);
    		done();
    	}
	}
});

app.on('error', function (err) {
	logger.error(`There is an error while processing message ${err.message}`); 
  	//done(err);
});

app.start();
