var consumer = require('sqs-consumer'),
    logger = require('../../../logger'),
	semusiConfig = require('./../../config'),
	dataConsumer = require('./../../utils/redshift-worker.js'),
	AWS = require('aws-sdk');

AWS.config.region = semusiConfig.AWS_REGION;
AWS.config.update({accessKeyId:semusiConfig.AWS_ACCESS_KEY_ID,secretAccessKey:semusiConfig.AWS_SECRET_KEY});

var app = consumer.create({
	queueUrl: semusiConfig.apiQueueMap['Lambda'],
	region: semusiConfig.AWS_REGION,
	batchSize: 10,
	handleMessage: function (message, done) {
		try{
			var dataObject = JSON.parse(message.Body);
			switch(dataObject.key){
				case "redshift":
				{
					dataConsumer.processFirehoseStreamData(dataObject,function(status){
						if(status){
							done();
						}
					});
					break;
				}
			}
		}
	    catch(e){
			logger.error(`catch error => ${error}`);
    		logger.info(`${message}`);
    		 
    		 
    		done();
    	}
	}
});

app.on('error', function (err) {
	logger.error(`There is an error while processing message. => ${err.message}`);
  	//done(err);
});

app.start();
