var consumer = require('sqs-consumer'),
	semusiConfig = require('./../../config'),
	backup = require('./backup.js'),
	logger = require('../../../logger'),
	AWS = require('aws-sdk');

AWS.config.region = semusiConfig.AWS_REGION;
AWS.config.update({accessKeyId:semusiConfig.AWS_ACCESS_KEY_ID,secretAccessKey:semusiConfig.AWS_SECRET_KEY});
        
var app = consumer.create({
	queueUrl: semusiConfig.DataBackupQueueList[0],
	region: semusiConfig.AWS_REGION,
	batchSize: 10,
	handleMessage: function (message, done) {
	    var postData = JSON.parse(message.Body);
	    if(postData.data){
	    	try{
	    		var datajson = JSON.parse(postData.data);
	    		backup.updateBackup(datajson,postData.app_id);
	    		done();
	    	}
	    	catch(e){
	    		logger.error(`error in consumer.create ${e}`);
	    		logger.info(`${postData}`);
	    		done();
	    	}	
	    }
	    else{
	    	logger.info(`PostData data does not contain data object : ${postData}`);
	    	done();
	    }
	}
});
 
app.on('error', function (err) {
	logger.error(`There is an error while processing message.${err.message}`);
  	//done(err);
});
 
app.start();