var semusiDeviceDetails = {},
    semusiCommon = require('./semusi.common.js'),
    underscore = require('underscore');

(function (semusiDeviceDetails) {

    //Private Properties
    var _periodObj = {},
        _deviceDetailsDb = {},
        _os = [],
        _resolutions = [],
        _os_versions = [];

    //Public Methods

    semusiDeviceDetails.setDb = function(db) {
        _deviceDetailsDb = db;
        setMeta();
    };

    semusiDeviceDetails.clearDeviceDetailsObject = function (obj) {
        if (obj) {
            if (!obj["t"]) obj["t"] = 0;
            if (!obj["n"]) obj["n"] = 0;
            if (!obj["u"]) obj["u"] = 0;
        }
        else {
            obj = {"t":0, "n":0, "u":0};
        }

        return obj;
    };

    semusiDeviceDetails.getPlatforms = function () {
        return _os;
    };

    semusiDeviceDetails.getPlatformBars = function () {
        return semusiCommon.extractBarData(_deviceDetailsDb, _os, semusiDeviceDetails.clearDeviceDetailsObject);
    };

    semusiDeviceDetails.getPlatformData = function () {

        var chartData = semusiCommon.extractTwoLevelData(_deviceDetailsDb, _os, semusiDeviceDetails.clearDeviceDetailsObject, [
            {
                name:"os_",
                func:function (rangeArr, dataObj) {
                    return rangeArr;
                }
            },
            { "name":"t" },
            { "name":"u" },
            { "name":"n" }
        ]);

        var platformNames = _.pluck(chartData.chartData, 'os_'),
            platformTotal = _.pluck(chartData.chartData, 'u'),
            chartData2 = [];

        var sum = _.reduce(platformTotal, function (memo, num) {
            return memo + num;
        }, 0);

        for (var i = 0; i < platformNames.length; i++) {
            var percent = (platformTotal[i] / sum) * 100;
            chartData2[i] = {data:[
                [0, platformTotal[i]]
            ], label:platformNames[i]};
        }

        chartData.chartDP = {};
        chartData.chartDP.dp = chartData2;

        return chartData;
    };

    semusiDeviceDetails.getResolutionBars = function () {
        return semusiCommon.extractBarData(_deviceDetailsDb, _resolutions, semusiDeviceDetails.clearDeviceDetailsObject);
    };

    semusiDeviceDetails.getOSVersionBars = function () {
        var osVersions = semusiCommon.extractBarData(_deviceDetailsDb, _os_versions, semusiDeviceDetails.clearDeviceDetailsObject);

        for (var i = 0; i < osVersions.length; i++) {
            osVersions[i].name = fixOSVersion(osVersions[i].name);
        }

        return osVersions;
    };

    semusiDeviceDetails.getOSVersionData = function (os) {

        var oSVersionData = semusiCommon.extractTwoLevelData(_deviceDetailsDb, _os_versions, semusiDeviceDetails.clearDeviceDetailsObject, [
            {
                name:"os_version",
                func:function (rangeArr, dataObj) {
                    return rangeArr;
                }
            },
            { "name":"t" },
            { "name":"u" },
            { "name":"n" }
        ]);

        var osSegmentation = ((os) ? os : ((_os) ? _os[0] : null)),
            platformVersionTotal = _.pluck(oSVersionData.chartData, 'u'),
            chartData2 = [];

        if (oSVersionData.chartData) {
            for (var i = 0; i < oSVersionData.chartData.length; i++) {
                oSVersionData.chartData[i].os_version = fixOSVersion(oSVersionData.chartData[i].os_version);

                if (oSVersionData.chartData[i].os_version.indexOf(osSegmentation) == -1) {
                    delete oSVersionData.chartData[i];
                }
            }
        }

        oSVersionData.chartData = _.compact(oSVersionData.chartData);

        var platformVersionNames = _.pluck(oSVersionData.chartData, 'os_version'),
            platformNames = [];

        var sum = _.reduce(platformVersionTotal, function (memo, num) {
            return memo + num;
        }, 0);

        for (var i = 0; i < platformVersionNames.length; i++) {
            var percent = (platformVersionTotal[i] / sum) * 100;

            chartData2[chartData2.length] = {data:[
                [0, platformVersionTotal[i]]
            ], label:platformVersionNames[i].replace(osSegmentation + " ", "")};
        }

        oSVersionData.chartDP = {};
        oSVersionData.chartDP.dp = chartData2;
        oSVersionData.os = [];

        if (_os && _os.length > 1) {
            for (var i = 0; i < _os.length; i++) {
                //if (_os[i] != osSegmentation) {
                //    continue;
                //}

                oSVersionData.os.push({
                    "name":_os[i],
                    "class":_os[i].toLowerCase()
                });
            }
        }

        return oSVersionData;
    };

    function setMeta() {
        if (_deviceDetailsDb['meta']) {
            _os = (_deviceDetailsDb['meta']['os']) ? _deviceDetailsDb['meta']['os'] : [];
            _resolutions = (_deviceDetailsDb['meta']['resolutions']) ? _deviceDetailsDb['meta']['resolutions'] : [];
            _os_versions = (_deviceDetailsDb['meta']['os_versions']) ? _deviceDetailsDb['meta']['os_versions'] : [];
        } else {
            _os = [];
            _resolutions = [];
            _os_versions = [];
        }

        if (_os_versions.length) {
            _os_versions = _os_versions.join(",").replace(/\./g, ":").split(",");
        }
    }

    function fixOSVersion(osName) {
        return osName
            .replace(/:/g, ".")
            .replace(/i/g, "iOS ")
            .replace(/a/g, "Android ")
            .replace(/b/g, "BlackBerry ")
            .replace(/w/g, "Windows Phone ")
            .replace(/m/g, "Mac ");
    }

}(semusiDeviceDetails));

module.exports = semusiDeviceDetails;
