const dotenv = require('dotenv');
dotenv.config();
var semusiConfig = {
    mongodb: {
	localUrl : process.env.localUrl,
        productionUrl :   process.env.productionUrl,
        maxTimeMS : 1000*60*9000 // this key contain seconds //2 minutes
    },

    // PG config with object Connection
    postgreSQL:{
        productionCitus:{
            user: process.env.citusUserProd,
            host: process.env.citusHostProd,
            database: process.env.citusDatabaseProd,
            password: process.env.citusPasswordProd,
            port: process.env.citusPortProd,
            idle: 30000,
            acquire:  300000,
            max : 10,
            min : 0
        },
        productionCitusURI: process.env.productionCitusURI,
        localUrl: {
            "user": process.env.citusUserLocal,
            "host": process.env.citusHostLocal,
            "database": process.env.citusDatabaseLocal,
            "password": process.env.citusPasswordLocal,
            "port": process.env.citusPortLocal,
            "idleTimeoutMillis": 30000
        },
    },
    // Sendgrid Email Info 
    emailInfo: {
        from: 'hello@appice.io',
        templateId: {
            sendAppAuthInfo_id: process.env.sendAppAuthT_id,
            sendStepsToDeveloper :process.env.sendStepsT_id ,
            Account_Disapproved : process.env.Account_DisapprovedT_id,
            Account_Approved: process.env.Account_ApprovedT_id,
            sendPwdSuccessResetInfo: process.env.sendPwdSuccessResetInfo,
            sendAlertNotification : process.env.sendAlertT_id,
            sendSignUpNotification: process.env.sendSignUpT_id,
            sendToNewMember: process.env.sendToNewMemberT_id,
            resetPwdEmailT_id : process.env.resetPwdEmailT_id
        },
        sendGridApiKey:process.env.sendGridApiKey    
    },
    sendGrid :{
      emailId: 'it@appice.io',
      password: process.env.sendGrid_pasword,
      helloID: 'hello@appice.io'
    },
    api: {
        workers: 0,
        port: process.env.serverPort1,
        host: process.env.serverHost,
        safe: true,
        session_duration_limit: 120,
        max_sockets: 1024,
        city_data: true
    },
    apps: {
        country: "IN",
        timezone: "Asia/India",
        category: "6"
    },
};

//postgresql Details
semusiConfig.PgQueue = {
    user: process.env.pgQueueUser,
    host: process.env.pgQueueHost,
    port: process.env.pgQueuePort,
    pgQueuepassword:process.env.pgQueuePassword,
    dialect: process.env.pgQueueDialect,
    database : process.env.pgQueueDatabase, 
    sslconnection: false,
    maxConnection: 10,
    minConnection: 0,
    acquire: 100*1000,
    idle:30000
};
semusiConfig.ServiceName = {
  Funnel:'appice-funnel',
  CampaignReports:'appICECampaignReports'
  }

// Set your host IP or domain to be used in the emails sent
semusiConfig.FCM = {
    serviceAccount : "./../lib/fir-test-b9e05-firebase-adminsdk-v13ba-fbb115630e.json",
    db: "https://fir-test-b9e05.firebaseio.com"
  }
  //PROXY DETAILS FOR FCM 
// if proxy url is not found in env then set the value as false  
  semusiConfig.http_proxy = (process.env.http_proxy) ? process.env.http_proxy : false;
  //PROXY DETAILS FOR APNS
  semusiConfig.proxyPORT = (process.env.proxyPORT) ? process.env.proxyPORT : false
  semusiConfig.proxyUrl = (process.env.proxyUrl) ? process.env.proxyUrl : false
  semusiConfig.certificatesAlerts = "support@appice.io";
  semusiConfig.athenaBucketURI = "";
  semusiConfig.certificatesDomains = ['panel.appice.io','a.appice.io'];
  semusiConfig.errorMails = [];
  semusiConfig.accessContolAllowOrigin= process.env.cdnUrl;
  semusiConfig.apiServerUrl = process.env.apiServerUrl;
  semusiConfig.serverDomain = process.env.cdnUrl;
  semusiConfig.host = process.env.host;
  semusiConfig.androidsdkv = '2421';
  semusiConfig.campHost = process.env.campHost;
  semusiConfig.postbackInstallBufferSec = 5;
  semusiConfig.chatbot_session_time = 60;
  semusiConfig.Domains = ["gmail","ymail","outlook","hotmail","gmx","mail","mail","yandex","india","b4Uindia","rediffmail","indiatimes","outGun","email","canada","bluebottle","canoe","dCEmail","fastermail","gawab","graffiti","hotpop","hushmail","iCQmail","inbox","inMail24 ","jubii","linuxMail ","litepost ","lycos Mail","mail.com ","mail2World","mailSnare ","merseyMail ","muchoMail","myWay ","mpera Mail","outGun ","postmaster","prontoMail ","runbox ","sacMail ","safe-mail","uReach ","vFEmail","zilladog","fuser ","grab Mail ","jump2Email","mail2Web ","myEmail ","tamadaa ","techemail","earthClassMail","futureMe ","hoaxMail ","l8r","postful","pranketh","shinyLetter","2Prong","dodgeit","e4ward ","emailias ","gishPuppy ","guerrillaMail","mailExpire","pookMail","spam ","spambox","spamex ","spamgourmet ","tempInbox ","zoEmail","in.com Mail ","sify","aol mail ","webdunia ","ibibo","iCloud","yahoo"];
  semusiConfig.AdminIds = ["tarun.anand@semusi.com","dilip.mistry@semusi.com"];
  semusiConfig.AlertIds = [];
  semusiConfig.IsProduction = true;
  semusiConfig.APPID_BYPASS_PS = ["5efc235b22ab3a69da580e69"];
  semusiConfig.contextNetPType = {'1':'gsm','2':'cdma'};
  semusiConfig.successGroup = "success@appice.io";
  semusiConfig.appIceUrl="https://a.appice.io/track?";
  semusiConfig.fontsrc = process.env.fontsrc;
  semusiConfig.stylesrc = process.env.stylesrc;
  semusiConfig.framesrc = process.env.framesrc;
  semusiConfig.connectsrc = process.env.connectsrc;
  semusiConfig.imagesrc =  `${process.env.imagesrc} ${process.env.blobContainerCDN}`;
  semusiConfig.appListSrc = ''; // by default Empty
  semusiConfig.ChatBotKey = "beginchatbotsession";
  semusiConfig.googleApiKey= process.env.googleApiKey;
  semusiConfig.AWS_ACCESS_KEY_ID = process.env.AWS_ACCESS_KEY_ID;
  semusiConfig.AWS_SECRET_KEY = process.env.AWS_SECRET_KEY;
  // redis config variable for single node connection  
  semusiConfig.StagingQueueDeviceImportUrl = "";
  semusiConfig.ProductionQueueDeviceImportUrl = "";
  semusiConfig.dStreamName =  "appiceProduction";
  semusiConfig.firehostBucket =  "appice-kinesisfirehose-data";
  semusiConfig.redshiftTablePostfix =  "_production";
  semusiConfig.CSVS3DIR = "appice-redshiftData";
  semusiConfig.SPECIFIC_CSVS3DIR = "appice-specificapps";
  semusiConfig.screenshot = "/var/www/appICE-Panel/screenshot"
  semusiConfig.CSVDIR = "/var/www/appICE-Panel/csvdir/"
  semusiConfig.CSVBUCKET = "appice-event-csv"
  semusiConfig.AWS_REGION = "us-east-1";
  semusiConfig.S3_STAGING_CERTBUCKET = "appice-staging-ioscerts";
  semusiConfig.S3_PROD_CERTBUCKET = "appice-prod-ioscerts";
  
  
  semusiConfig.AWSLAMBDA_ACCESS_KEY_ID = process.env.AWSLAMBDA_ACCESS_KEY_ID;
  semusiConfig.AWSLAMBDA_SECRET_KEY = process.env.AWSLAMBDA_SECRET_KEY;
  semusiConfig.isPgProcessorEnabled = (process.env.isPgProcessorEnabled == 'true' ) ? true: false;
  
  
  semusiConfig.batchSize = 10;
  semusiConfig.DataBackupQueueList = [];
  semusiConfig.BackupQueueLength = 2;
  semusiConfig.logFileTime = 15 // min
  semusiConfig.campaignImagePath = "//var/www/appICE-Panel/frontend/express/public/uploads/campaignFiles/campaignimages";
  semusiConfig.APIUrl="https://a.appice.io";
  semusiConfig.callbackLog = "/var/www/appICE-Panel/log/callbacklogs";
  semusiConfig.databackup = "/var/www/appICE-Panel/log";
  semusiConfig.keendatabackup = "/var/www/appICE-Panel/log/keenzip";
  semusiConfig.SQSFailureLog = "/var/www/appICE-Panel/log/sqslogs";
  semusiConfig.applogs = "/var/wwww/appICE-Panel/log";
  semusiConfig.atRiskAudience = "Users At Risk";
  semusiConfig.eventBufferTime = 120; // put in seconds
  semusiConfig.maxWifiDistance = 50;
  semusiConfig.maxLatLngDistance = 10;
  semusiConfig.uploadFilesStorage = process.env.uploadFilesStorage
  semusiConfig.E2EKey = "appice-custom-segment-data";
  semusiConfig.isCustomCsvEnabled= ( process.env.isCustomCsvEnabled )? process.env.isCustomCsvEnabled.split(","): []
  semusiConfig.getAppType = process.env.getAppType;
  semusiConfig.SilentPushEnable = (process.env.SilentPushEnable ) ? process.env.SilentPushEnable.split(' '): []
/*Minio Details*/
  semusiConfig.endPoint =  (process.env.minioEndPoint) ? process.env.minioEndPoint :'';
  semusiConfig.port = (process.env.minioPort) ? parseInt(process.env.minioPort): ''; //default port 9000 if not found
  semusiConfig.useSSL =  (process.env.miniouseSSL == 'true' ) ? true: false;
  semusiConfig.accessKey =  (process.env.minioAccessKey) ? process.env.minioAccessKey : ''; 
  semusiConfig.secretKey =  (process.env.miniosecretKey) ? process.env.miniosecretKey : ''; 
/* Bucket Name for Export CSV */
  semusiConfig.panelExport = (process.env.panelExport && process.env.panelExport == 'true') ? true : false 
  semusiConfig.minioBuckets = {
    exportsCsv:(process.env.exportsCsvBckt) ? process.env.exportsCsvBckt:"",
    campaignImages: (process.env.campaignImages) ? process.env.campaignImages : "appice-prod-campaign-images",
};
  semusiConfig.cyType = process.env.cyType;
  semusiConfig.places = [
  {"place":"mall","group":"mall"},
  {"place":"school","group":"school,college"},
  {"place":"college","group":"school,college"},
  {"place":"gym","group":"gym stadium,gymnasium"},
  {"place":"stadium","group":"gym,stadium,gymnasium"},
  {"place":"gymnasium","group":"gym,stadium,gymnasium"},
  {"place":"cinemas", "group": "cinema,multiplex,cineplex"},
  {"place":"cineplex", "group": "cinema,multiplex,cineplex"},
  {"place":"multiplex", "group": "cinema,multiplex,cineplex"},
  {"place":"coffee","group":"coffee"},
  {"place":"restaurant","group":"restaurant"},
  {"place":"hotel","group":"hotel"},
  {"place":"airport","group":"airport"},
  {"place":"metro station","group":"metro station"},
  {"place":"railway station","group":"railway station"}];
  
  semusiConfig.uploadAssets = (process.env.uploadAssets) ? process.env.uploadAssets.split(",") : []
  semusiConfig.cryptoPassword = process.env.cryptoPassword;
  semusiConfig.cryptoSalt = process.env.cryptoSalt;
  semusiConfig.cryptoKey = process.env.cryptoKey; 
  semusiConfig.cryptoIV = process.env.cryptoIV;
  semusiConfig.blobContainerCDN = process.env.blobContainerCDN;

  semusiConfig.azureCDNBlobSASURL = process.env.azureCDNBlobSASURL;
  semusiConfig.e2eContainerCDN = process.env.e2eblobContainerCDN;
  semusiConfig.KeysArray=['host', 'port','password'];
  semusiConfig.redisClusterHost = process.env.redisClusterHost;
  semusiConfig.redisDefaultEnabledPassword = process.env.redisDefaultEnabledPassword;
  semusiConfig.isDefaultRedisClusterEnabled = process.env.isDefaultRedisClusterEnabled;
  //for single node
  semusiConfig.redisServerHost = process.env.redisServerHost;
  semusiConfig.redisServerPort = process.env.redisServerPort;
  semusiConfig.redisServerPassword = process.env.redisServerPassword;
  semusiConfig.eventHubCaptureEndpoint = process.env.eventHubCaptureEndpoint;
  semusiConfig.eventHubCaptureKey = process.env.eventHubCaptureKey;
  semusiConfig.azureApiStorageSASToken = process.env.azureCDNSASToken;
  
  
  semusiConfig.azureApiQueueSASURL = process.env.azureApiQueueSASURL;
  semusiConfig.azureApiBlobSASURL = process.env.azureCDNBlobSASURL;
  semusiConfig.azureApiFileSASURL = process.env.azureApiFileSASURL;
  semusiConfig.azureApiQueueMap = {
      "uninstall":"appice-uninstall-raw-data",
      "installs":"appice-installapi",
      "beginsession":"appice-api-sessions",
      "endsession":"appice-api-sessions",
      "beginchatbotsession":"appice-api-generic-events",
      "events":"appice-api-ml-events",
      "updateDeviceMetaData":"appice-api-ml-events",
      "updateAppMetaData":"appice-api-ml-events",
      "bulkResponse":"appice-api-ml-events",
      "competingApps":"appice-api-ml-events",
      "eventsqueue":"appice-api-specific-appevents",
      "campaigns":"appice-api-campaigns",
      "errors":"appice-api-errorsqs",
      "Lambda":"appice-api-lambda",
      "deadLetter":"appice-api-deadlettersqs",
      "session_record":"appice-prod-screenshot",
      "genericQueue":"appice-api-generic-events",
      "genericQueue_updateDeviceMetaData":"appice-api-generic-events",
      "genericQueue_updateAppMetaData":"appice-api-generic-events",
      "genericQueue_competingApps":"appice-api-generic-events",
      "appice-custom-segment-data":"appice-custom-segment-data",
      "updateDeviceMetaData1":"test-queue"
  };
  semusiConfig.apiQueueMap={
        "beginsession":"https://sqs.us-east-1.amazonaws.com/315197677640/Appice-API-Sessions",
        "endsession":"https://sqs.us-east-1.amazonaws.com/315197677640/Appice-API-Sessions",
        "beginchatbotsession":"https://sqs.us-east-1.amazonaws.com/315197677640/Appice-generic-queue_NEW",
        "events":"https://sqs.us-east-1.amazonaws.com/315197677640/Appice-generic-queue_NEW",
        "updateDeviceMetaData":"https://sqs.us-east-1.amazonaws.com/315197677640/Appice-generic-queue_NEW",
        "updateAppMetaData":"https://sqs.us-east-1.amazonaws.com/315197677640/Appice-generic-queue_NEW",
        "bulkResponse":"https://sqs.us-east-1.amazonaws.com/315197677640/Appice-generic-queue_NEW",
        "competingApps":"https://sqs.us-east-1.amazonaws.com/315197677640/Appice-generic-queue_NEW",
        "eventsqueue":"https://sqs.us-east-1.amazonaws.com/315197677640/Appice-API-Specific-AppEvents",
        "campaigns":"https://sqs.us-east-1.amazonaws.com/315197677640/Appice-Campaigns",
        "errors":"https://sqs.us-east-1.amazonaws.com/315197677640/Appice-API-ErrorSQS",
        "Lambda":"https://sqs.us-east-1.amazonaws.com/315197677640/Appice-Lambda",
        "deadLetter":"https://sqs.us-east-1.amazonaws.com/315197677640/Appice-API-DeadLetterSQS",
        "session_record":"https://sqs.us-east-1.amazonaws.com/315197677640/Appice-prod-screenshot",
        "genericQueue":"https://sqs.us-east-1.amazonaws.com/315197677640/Appice-generic-queue_NEW"
  };
  semusiConfig.gupshupConfig = {
      API : 'http://enterprise.smsgupshup.com/GatewayAPI/rest',
      method: 'SendMessage',
      auth_scheme: 'plain',
      msg_type: 'TEXT',
      v: '1.1',
      format: 'text'
  }
  
  semusiConfig.FmRange = {
     from : 87,
     to : 108
  }
  semusiConfig.redshiftSpecificApps = ["58d90026119910472d0ade16","58dcf37b119910472d0ade21","58e2501e2d851cb35038a027", "5922cce2de0b7a421f2c16b7", "5924485f4ca0e6c4251d0168", "59411c7b41673f842a7764dd", "5943ba332ebe6ac46c613706", "594a6041257576f24ede29df", "59562e18f8e0634e11a7f41d", "59e458073161a91d22920b90", "59ef0ad65d2c64fc3963bdc4", "59fac2bdaf9a75a3786868b2", "5a09ae86c2ccc6467bc90844", "5a192f319ba81249386fab41", "5a194c4f9ba81249386fab46", "5a227b47f6afd8b7731db2e7"]
  semusiConfig.notInGenericQueue = ["583293316940eec96800559f", "57e8f2d84e25c0b702996cb0","5aa7b71bd0df368e46dede9e","5d5fd1290200e5b6009d6478","5bebe93c25d705690ffbc758","5ad83ce1f71de7016db4c0c1"];
  semusiConfig.newQueueApps = ["583e6143ca3b1959380b54b4", "5aaa1c6cd0df368e46dedea4", "5a7d9b319dcc7f913dc13a47", "59033d55665dbf37447657ac", "5a168f97c69b8b4e711fda4a", "5a5dfef0d2651fac0b6e98bb", "5a2639c9306b7fc346134a31"];
  semusiConfig.validateEventsApps = ["583e6143ca3b1959380b54b4", "5aaa1c6cd0df368e46dedea4", "5a7d9b319dcc7f913dc13a47", "59033d55665dbf37447657ac", "5a168f97c69b8b4e711fda4a", "5a5dfef0d2651fac0b6e98bb", "5a2639c9306b7fc346134a31"];
  semusiConfig.sendPostbackApps = ["583e6143ca3b1959380b54b4", "5aaa1c6cd0df368e46dedea4", "5a7d9b319dcc7f913dc13a47", "57f7a1a9662688ff05897eb1", "59033d55665dbf37447657ac", "594cc2a4b44cacc2397b40dc", "5a168f97c69b8b4e711fda4a", "5a5dfef0d2651fac0b6e98bb", "5a2639c9306b7fc346134a31"];
  semusiConfig.postbackEventsApps = [
      {
          appid:'594cc2a4b44cacc2397b40dc',
          events:['aw_otp_verified','aw_search_byflight_no','aw_search_byroute','app_open','aw_flight_added'],
          refferers:['taskbucks','airwhizz']
      }
  ];
  semusiConfig.campaignsApps = [];
  semusiConfig.octane = {
      URL : "",
      KEY_octane : "",
      FROM : {
          emailid:"",
          name:"appICE"
      }
  }
  
  // Vtion apps list
  semusiConfig.keenApps = [
    '5a5dfef0d2651fac0b6e98bb',
    '5a2639c9306b7fc346134a31',
    '5a168f97c69b8b4e711fda4a',
    '59033d55665dbf37447657ac',
    '583e6143ca3b1959380b54b4',
    '5a7d9b319dcc7f913dc13a47',
    '5aaa1c6cd0df368e46dedea4',
    '5ab09a2c2a9f5c2606f7484a',
    '5ad07bbe648d97d71fc89de1',
    '5ad83ce1f71de7016db4c0c1'
  ];
  
  // AzureCitus apps list
  semusiConfig.azureCitus = [
      '5ad83ce1f71de7016db4c0c1',
      '5ac8d2b9467f561f48bb262d',
      '5a8ea0a4d98f781d739b6713',
      '57f7a1a9662688ff05897eb1',
      '5aa7b71bd0df368e46dede9e',
      '57e8f2d84e25c0b702996cb0',
      '583293316940eec96800559f',
      '583e6143ca3b1959380b54b4',
      '59033d55665dbf37447657ac',
      '5a5dfef0d2651fac0b6e98bb',
      '5a2639c9306b7fc346134a31',
      '5a168f97c69b8b4e711fda4a',
      '5a7d9b319dcc7f913dc13a47',
      '5aaa1c6cd0df368e46dedea4',
      '5acb994ce96b09565e1f1d7b',
      '5b3603f41261d7fa6db4ce0e',
      '5b6040cbb7aa6b824a89b628',
      '5b33366662c73ad0428b77a2',
      '5b5eee4fb7aa6b824a89b623',
      '5b3f3929dafaa91435b066a8',
      '594cc2a4b44cacc2397b40dc',
      '559a7647d888eebc64000028',
      '56740ceb566583c105000001',
      '58d90026119910472d0ade16',
      '5bebe93c25d705690ffbc758'
  ];
  
  // Interest Clients
  semusiConfig.intetestAppsList = [
      '5ad83ce1f71de7016db4c0c1',
      '5bebe93c25d705690ffbc758',
      '5d5fd1290200e5b6009d6478',
      '5ac8d2b9467f561f48bb262d',
      '57f7a1a9662688ff05897eb1',
      '5a5dfef0d2651fac0b6e98bb',
      '5a2639c9306b7fc346134a31',
      '5a168f97c69b8b4e711fda4a',
      '5a7d9b319dcc7f913dc13a47',
      '5aaa1c6cd0df368e46dedea4',
      '5acb994ce96b09565e1f1d7b',
      '5b3603f41261d7fa6db4ce0e',
      '5b6040cbb7aa6b824a89b628',
      '5b33366662c73ad0428b77a2',
      '5df742d4cc01c2c163c2f09b',
      '583e6143ca3b1959380b54b4',
      '5fa41afe6fc1e678a8344311'   
    ];
  
  // manage end session event with cache for mark end session if not get from client
  semusiConfig.eventCacheKey = "endsession_cache"
  semusiConfig.eventIntervalTime = 3600; // seconds
  
  // screen playback url and header authkey
  semusiConfig.screenPlaybakcUrlDev =  process.env.screenPlaybakcUrlDev;
  semusiConfig.screenPlaybakcAuthKeyDev =  process.env.screenPlaybakcAuthKeyDev;
  semusiConfig.screenPlaybakcUrlProd = process.env.screenPlaybakcUrlProd;
  semusiConfig.screenPlaybakcHeaderKeyProd =  process.env.screenPlaybakcHeaderKeyProd;
  semusiConfig.screenPlaybakcAuthKeyProd =  process.env.screenPlaybakcAuthKeyProd;
  semusiConfig.screenPlaybakcQuality = "mid";
  semusiConfig.screenPlaybakcCommand = "#screenshot";
  //Push expire time 
  semusiConfig.iOSPushExpireTime = Math.floor(Date.now() / 1000) + 3600;
  semusiConfig.regexAPPIDS = ( process.env.regexAPPIDS )? process.env.regexAPPIDS.split(","): [];
  semusiConfig.appInboxAPPIDS= ( process.env.appInboxAPPIDS )? process.env.appInboxAPPIDS.split(","): []
  semusiConfig.appidwithNoDelay = (process.env.appidwithNoDelay) ? process.env.appidwithNoDelay.split(',') : []
  semusiConfig.activateCampaignAPPIDS= ( process.env.activateCampaignAPPIDS )? process.env.activateCampaignAPPIDS.split(","): []
  semusiConfig.showVariant = ( process.env.showVariant ) ? process.env.showVariant : false
  semusiConfig.CampaignViaParentAppID= [
    '5ad83ce1f71de7016db4c0c1',
    '5bebe93c25d705690ffbc758'
  ] 

  semusiConfig.ChatBotKey = "beginchatbotsession";
  semusiConfig.mdALgo = process.env.mdALgo;
  semusiConfig.shaV1Hash =process.env.shaV1Hash
  semusiConfig.shaV2Hash = process.env.shaV2Hash
  semusiConfig.cmpInsertInToPG = process.env.cmpInsertInToPG;
  semusiConfig.campaignColumn = process.env.campaignColumn;
  semusiConfig.forgetPasswordEmail = process.env.forgetPasswordEmail;
  semusiConfig.ttl = (process.env.ttl)  ? parseInt(process.env.ttl) : 5000
  semusiConfig.hashTupleEnabledTrue = process.env.hashTupleEnabledTrue;
  semusiConfig.AIEmailEditor = {
    client_id : process.env.AIEmailEditor_client_id,
    client_secret : process.env.AIEmailEditor_client_secret,
    endpoint : process.env.AIEmailEditor_endpoint,
    grant_type : process.env.AIEmailEditor_grant_type
}
  module.exports = semusiConfig;
