var botsUser = {},
    commonBots = require('./common.js'),
    common = require('../utils/common.js');
    semusiConfig = require('./../config');
(function (botsUser) {

    botsUser.newInstalls = function(params, botEvent){
        var did = commonBots.getSenderId(botEvent);
        var time = commonBots.getEventTime(botEvent);

        did = common.crypto.createHash(semusiConfig.shaV1Hash).update(did+ "").digest('hex');
        var appUser = {
                            "inittime" : time,
                            "fs" : time,
                            "ls" : time,
                            "did" : did,
                            "active" : true,
                            "history" : [
                                {
                                    "refname" : params.platform,
                                    "installer" : "Self",
                                    "type" : "I",
                                    "dtEntry" : time,
                                    "isnew" : true,
                                    "createdBy" : params.platform
                                }
                            ],
                            "p" : params.platform,
                            "tz" : 0,
                            "createdAt" : time,
                            "sc" : 1,
                            "updatedAt" : time
                        }
        // add new chat plot user in app user collection
        common.db.collection('app_users' + params.appid).update({'_id':did}, {'$set':appUser}, {'upsert':true}, function (err,result) {
            if(!err){      
            }
            else{
            }    
        });
    }

    botsUser.processBegginSession = function(params, botEvent){
        var did = commonBots.getSenderId(botEvent);
        var time = commonBots.getEventTime(botEvent);

        did = common.crypto.createHash(semusiConfig.shaV1Hash).update(did+ "").digest('hex');
        var obj = {
                            "ls" : time,
                            "updatedAt" : time
                        }
        // update chat plot user in app user collection
        common.db.collection('app_users' + params.appid).update({'_id':did}, {'$set':obj, '$inc': {'sc':1}}, {'upsert':true}, function (err,result) {
            if(!err){
            }
            else{
            }    
        });
    }

    botsUser.processEndSession = function(appid, did, duration, time){
        did = common.crypto.createHash(semusiConfig.shaV1Hash).update(did+ "").digest('hex');
        var obj = {
                            "lsd" : duration,
                            "updatedAt" : time,
                            "ls_st" : time
                        }
        // update chat plot user in app user collection
        common.db.collection('app_users' + appid).update({'_id':did}, {'$set':obj, '$inc': {'tsd':duration}}, {'upsert':true}, function (err,result) {
            if(!err){
                  
            }
            else{
                
            }    
        });
    }

    botsUser.checkUser = function(params, botEvent, callback){
        var did = commonBots.getSenderId(botEvent);
        did = common.crypto.createHash(semusiConfig.shaV1Hash).update(did+ "").digest('hex');
        common.db.collection('app_users' + params.appid).findOne({'_id':did}, function (err,result) {
            if(!err){
                callback(false);       
            }
            else{
                if(result){
                    callback(true);
                }
                else{
                    callback(false);
                }
            }    
        });
    }

}(botsUser));

module.exports = botsUser;
