var botsEvents = {},
    dataProducer = require('../utils/common.data.producer.js'),
    common = require('../utils/common.js'),
    botsSession = require('./bots.session.js');
    semusiConfig = require('../config')
    
(function (botsEvents) {

    botsEvents.sendEventData = function(params, botEvent){
        // check new session
        if(params.qstring.type == "incoming"){
            botsSession.processToSession(params, botEvent);
        }

        var eventData = botsEvents.prepareEventData(botEvent);
        if(eventData.did){
            eventData.did = common.crypto.createHash(semusiConfig.shaV1Hash).update(eventData.did+ "").digest('hex');
            var obj = {
                appid: params.qstring.appid,
                did: eventData.did,
                user_id: eventData.did,
                events: eventData.events,
                key : "events"
            };
            dataProducer.writeDataDirectly(obj);
        }
        else{
        }       
    }

    botsEvents.prepareEventData = function(botEvent){
       var eventData = {did:'', events:[]};
       // handle incoming msg
       if(botEvent.entry){
            botEvent.entry.forEach(function(event){
                var obj = {};
                var segmentsData = botsEvents.prepareEventSegment(event.messaging);
                obj.eventTime = parseInt(parseInt(event.time)/1000);
                obj.chatbot = true;
                obj._tz = 0;
                obj.key = botEvent.eventKey;
                obj.segment = segmentsData.sengments;
                obj.messaging = event.messaging;
                obj.context = {                        
                                "who": {
                                    "device": {
                                        "p": botEvent.platform
                                    }
                                },
                                "when": {
                                    "timestamp": parseInt(parseInt(event.time)/1000)
                                },
                                "where": {
                                    "geo": {
                                        
                                    },
                                    "location": {
                                    }
                                },
                                "what": {}
                            }
                if(obj.segment){
                   eventData.did = segmentsData.did
                }

                eventData.events.push(obj);
           });
       } 
       // handle outgoing msg
       else if(botEvent.recipient) {
            eventData.did = botEvent.recipient.id;
            var obj = {};
            obj.eventTime = parseInt(parseInt(botEvent.time));
            obj._tz = 0;
            obj.key = botEvent.eventKey;
            obj.segment = {'text':botEvent.message.text};
            obj.context = {                        
                            "who": {
                                "device": {
                                    "p": botEvent.platform
                                }
                            },
                            "when": {
                                "timestamp": parseInt(parseInt(botEvent.time))
                            },
                            "where": {
                                "geo": {
                                    
                                },
                                "location": {
                                }
                            },
                            "what": {}
                        }

            eventData.events.push(obj);
       } 

       return eventData;
    }

    botsEvents.prepareEventSegment = function(eventMsg){
        var segment = {sengments:{}};
        eventMsg.forEach(function(msg, key){
            if(msg.message && msg.message.mid){
                segment.did = msg.sender.id;
                segment.sengments["mid"+key] = msg.message.mid.replace(/\./g, ":");
            }
            if(msg.message && msg.message.text){
                segment.did = msg.sender.id;
                segment.sengments["text"+key] = msg.message.text;
            }            
        });
        return segment;
    }

}(botsEvents));

module.exports = botsEvents;
