#if 0
#elif defined(__arm64__) && __arm64__
// Generated by Apple Swift version 5.10 (swiftlang-5.10.0.13 clang-1500.3.9.4)
#ifndef KOCHAVANETWORKING_SWIFT_H
#define KOCHAVANETWORKING_SWIFT_H
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wgcc-compat"

#if !defined(__has_include)
# define __has_include(x) 0
#endif
#if !defined(__has_attribute)
# define __has_attribute(x) 0
#endif
#if !defined(__has_feature)
# define __has_feature(x) 0
#endif
#if !defined(__has_warning)
# define __has_warning(x) 0
#endif

#if __has_include(<swift/objc-prologue.h>)
# include <swift/objc-prologue.h>
#endif

#pragma clang diagnostic ignored "-Wauto-import"
#if defined(__OBJC__)
#include <Foundation/Foundation.h>
#endif
#if defined(__cplusplus)
#include <cstdint>
#include <cstddef>
#include <cstdbool>
#include <cstring>
#include <stdlib.h>
#include <new>
#include <type_traits>
#else
#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>
#include <string.h>
#endif
#if defined(__cplusplus)
#if defined(__arm64e__) && __has_include(<ptrauth.h>)
# include <ptrauth.h>
#else
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wreserved-macro-identifier"
# ifndef __ptrauth_swift_value_witness_function_pointer
#  define __ptrauth_swift_value_witness_function_pointer(x)
# endif
# ifndef __ptrauth_swift_class_method_pointer
#  define __ptrauth_swift_class_method_pointer(x)
# endif
#pragma clang diagnostic pop
#endif
#endif

#if !defined(SWIFT_TYPEDEFS)
# define SWIFT_TYPEDEFS 1
# if __has_include(<uchar.h>)
#  include <uchar.h>
# elif !defined(__cplusplus)
typedef uint_least16_t char16_t;
typedef uint_least32_t char32_t;
# endif
typedef float swift_float2  __attribute__((__ext_vector_type__(2)));
typedef float swift_float3  __attribute__((__ext_vector_type__(3)));
typedef float swift_float4  __attribute__((__ext_vector_type__(4)));
typedef double swift_double2  __attribute__((__ext_vector_type__(2)));
typedef double swift_double3  __attribute__((__ext_vector_type__(3)));
typedef double swift_double4  __attribute__((__ext_vector_type__(4)));
typedef int swift_int2  __attribute__((__ext_vector_type__(2)));
typedef int swift_int3  __attribute__((__ext_vector_type__(3)));
typedef int swift_int4  __attribute__((__ext_vector_type__(4)));
typedef unsigned int swift_uint2  __attribute__((__ext_vector_type__(2)));
typedef unsigned int swift_uint3  __attribute__((__ext_vector_type__(3)));
typedef unsigned int swift_uint4  __attribute__((__ext_vector_type__(4)));
#endif

#if !defined(SWIFT_PASTE)
# define SWIFT_PASTE_HELPER(x, y) x##y
# define SWIFT_PASTE(x, y) SWIFT_PASTE_HELPER(x, y)
#endif
#if !defined(SWIFT_METATYPE)
# define SWIFT_METATYPE(X) Class
#endif
#if !defined(SWIFT_CLASS_PROPERTY)
# if __has_feature(objc_class_property)
#  define SWIFT_CLASS_PROPERTY(...) __VA_ARGS__
# else
#  define SWIFT_CLASS_PROPERTY(...) 
# endif
#endif
#if !defined(SWIFT_RUNTIME_NAME)
# if __has_attribute(objc_runtime_name)
#  define SWIFT_RUNTIME_NAME(X) __attribute__((objc_runtime_name(X)))
# else
#  define SWIFT_RUNTIME_NAME(X) 
# endif
#endif
#if !defined(SWIFT_COMPILE_NAME)
# if __has_attribute(swift_name)
#  define SWIFT_COMPILE_NAME(X) __attribute__((swift_name(X)))
# else
#  define SWIFT_COMPILE_NAME(X) 
# endif
#endif
#if !defined(SWIFT_METHOD_FAMILY)
# if __has_attribute(objc_method_family)
#  define SWIFT_METHOD_FAMILY(X) __attribute__((objc_method_family(X)))
# else
#  define SWIFT_METHOD_FAMILY(X) 
# endif
#endif
#if !defined(SWIFT_NOESCAPE)
# if __has_attribute(noescape)
#  define SWIFT_NOESCAPE __attribute__((noescape))
# else
#  define SWIFT_NOESCAPE 
# endif
#endif
#if !defined(SWIFT_RELEASES_ARGUMENT)
# if __has_attribute(ns_consumed)
#  define SWIFT_RELEASES_ARGUMENT __attribute__((ns_consumed))
# else
#  define SWIFT_RELEASES_ARGUMENT 
# endif
#endif
#if !defined(SWIFT_WARN_UNUSED_RESULT)
# if __has_attribute(warn_unused_result)
#  define SWIFT_WARN_UNUSED_RESULT __attribute__((warn_unused_result))
# else
#  define SWIFT_WARN_UNUSED_RESULT 
# endif
#endif
#if !defined(SWIFT_NORETURN)
# if __has_attribute(noreturn)
#  define SWIFT_NORETURN __attribute__((noreturn))
# else
#  define SWIFT_NORETURN 
# endif
#endif
#if !defined(SWIFT_CLASS_EXTRA)
# define SWIFT_CLASS_EXTRA 
#endif
#if !defined(SWIFT_PROTOCOL_EXTRA)
# define SWIFT_PROTOCOL_EXTRA 
#endif
#if !defined(SWIFT_ENUM_EXTRA)
# define SWIFT_ENUM_EXTRA 
#endif
#if !defined(SWIFT_CLASS)
# if __has_attribute(objc_subclassing_restricted)
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# else
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# endif
#endif
#if !defined(SWIFT_RESILIENT_CLASS)
# if __has_attribute(objc_class_stub)
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME) __attribute__((objc_class_stub))
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_class_stub)) SWIFT_CLASS_NAMED(SWIFT_NAME)
# else
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME)
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) SWIFT_CLASS_NAMED(SWIFT_NAME)
# endif
#endif
#if !defined(SWIFT_PROTOCOL)
# define SWIFT_PROTOCOL(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
# define SWIFT_PROTOCOL_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
#endif
#if !defined(SWIFT_EXTENSION)
# define SWIFT_EXTENSION(M) SWIFT_PASTE(M##_Swift_, __LINE__)
#endif
#if !defined(OBJC_DESIGNATED_INITIALIZER)
# if __has_attribute(objc_designated_initializer)
#  define OBJC_DESIGNATED_INITIALIZER __attribute__((objc_designated_initializer))
# else
#  define OBJC_DESIGNATED_INITIALIZER 
# endif
#endif
#if !defined(SWIFT_ENUM_ATTR)
# if __has_attribute(enum_extensibility)
#  define SWIFT_ENUM_ATTR(_extensibility) __attribute__((enum_extensibility(_extensibility)))
# else
#  define SWIFT_ENUM_ATTR(_extensibility) 
# endif
#endif
#if !defined(SWIFT_ENUM)
# define SWIFT_ENUM(_type, _name, _extensibility) enum _name : _type _name; enum SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# if __has_feature(generalized_swift_name)
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) enum _name : _type _name SWIFT_COMPILE_NAME(SWIFT_NAME); enum SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# else
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) SWIFT_ENUM(_type, _name, _extensibility)
# endif
#endif
#if !defined(SWIFT_UNAVAILABLE)
# define SWIFT_UNAVAILABLE __attribute__((unavailable))
#endif
#if !defined(SWIFT_UNAVAILABLE_MSG)
# define SWIFT_UNAVAILABLE_MSG(msg) __attribute__((unavailable(msg)))
#endif
#if !defined(SWIFT_AVAILABILITY)
# define SWIFT_AVAILABILITY(plat, ...) __attribute__((availability(plat, __VA_ARGS__)))
#endif
#if !defined(SWIFT_WEAK_IMPORT)
# define SWIFT_WEAK_IMPORT __attribute__((weak_import))
#endif
#if !defined(SWIFT_DEPRECATED)
# define SWIFT_DEPRECATED __attribute__((deprecated))
#endif
#if !defined(SWIFT_DEPRECATED_MSG)
# define SWIFT_DEPRECATED_MSG(...) __attribute__((deprecated(__VA_ARGS__)))
#endif
#if !defined(SWIFT_DEPRECATED_OBJC)
# if __has_feature(attribute_diagnose_if_objc)
#  define SWIFT_DEPRECATED_OBJC(Msg) __attribute__((diagnose_if(1, Msg, "warning")))
# else
#  define SWIFT_DEPRECATED_OBJC(Msg) SWIFT_DEPRECATED_MSG(Msg)
# endif
#endif
#if defined(__OBJC__)
#if !defined(IBSegueAction)
# define IBSegueAction 
#endif
#endif
#if !defined(SWIFT_EXTERN)
# if defined(__cplusplus)
#  define SWIFT_EXTERN extern "C"
# else
#  define SWIFT_EXTERN extern
# endif
#endif
#if !defined(SWIFT_CALL)
# define SWIFT_CALL __attribute__((swiftcall))
#endif
#if !defined(SWIFT_INDIRECT_RESULT)
# define SWIFT_INDIRECT_RESULT __attribute__((swift_indirect_result))
#endif
#if !defined(SWIFT_CONTEXT)
# define SWIFT_CONTEXT __attribute__((swift_context))
#endif
#if !defined(SWIFT_ERROR_RESULT)
# define SWIFT_ERROR_RESULT __attribute__((swift_error_result))
#endif
#if defined(__cplusplus)
# define SWIFT_NOEXCEPT noexcept
#else
# define SWIFT_NOEXCEPT 
#endif
#if !defined(SWIFT_C_INLINE_THUNK)
# if __has_attribute(always_inline)
# if __has_attribute(nodebug)
#  define SWIFT_C_INLINE_THUNK inline __attribute__((always_inline)) __attribute__((nodebug))
# else
#  define SWIFT_C_INLINE_THUNK inline __attribute__((always_inline))
# endif
# else
#  define SWIFT_C_INLINE_THUNK inline
# endif
#endif
#if defined(_WIN32)
#if !defined(SWIFT_IMPORT_STDLIB_SYMBOL)
# define SWIFT_IMPORT_STDLIB_SYMBOL __declspec(dllimport)
#endif
#else
#if !defined(SWIFT_IMPORT_STDLIB_SYMBOL)
# define SWIFT_IMPORT_STDLIB_SYMBOL 
#endif
#endif
#if defined(__OBJC__)
#if __has_feature(objc_modules)
#if __has_warning("-Watimport-in-framework-header")
#pragma clang diagnostic ignored "-Watimport-in-framework-header"
#endif
@import Foundation;
@import ObjectiveC;
#endif

#endif
#pragma clang diagnostic ignored "-Wproperty-attribute-mismatch"
#pragma clang diagnostic ignored "-Wduplicate-method-arg"
#if __has_warning("-Wpragma-clang-attribute")
# pragma clang diagnostic ignored "-Wpragma-clang-attribute"
#endif
#pragma clang diagnostic ignored "-Wunknown-pragmas"
#pragma clang diagnostic ignored "-Wnullability"
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"

#if __has_attribute(external_source_symbol)
# pragma push_macro("any")
# undef any
# pragma clang attribute push(__attribute__((external_source_symbol(language="Swift", defined_in="KochavaNetworking",generated_declaration))), apply_to=any(function,enum,objc_interface,objc_category,objc_protocol))
# pragma pop_macro("any")
#endif

#if defined(__OBJC__)
@class NSString;

/// A class combines a dispatch queue and a lock into a unified actor.
SWIFT_CLASS_NAMED("Actor")
@interface KVAActor : NSObject
/// A global concurrent default-qos actor, which can be used generically to ensure that code can wait and not block execution.
/// Any sub-system which wishes to ensure execution can wait and not block execution in a global sense may use this queue.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAActor * _Nonnull globalConcurrent;)
+ (KVAActor * _Nonnull)globalConcurrent SWIFT_WARN_UNUSED_RESULT;
/// A global serial default-qos actor, which can be used generically to ensure that code execution is synchronized.
/// Any sub-system which wishes to synchronize code execution in a global sense may use this queue.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAActor * _Nonnull globalSerial;)
+ (KVAActor * _Nonnull)globalSerial SWIFT_WARN_UNUSED_RESULT;
/// The main dispatch queue.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAActor * _Nonnull main;)
+ (KVAActor * _Nonnull)main SWIFT_WARN_UNUSED_RESULT;
/// Return a description of the instance.
@property (nonatomic, readonly, copy) NSString * _Nonnull description;
/// Asynchronously dispatch and execute the provided closure.
/// \param sourceIdentifier A unique identifier for the location in code from which this originated.  It may be a universally unique identifier (UUID) or a friendly name such as “func someFunc()”.  It is generally preferrable to use a friendly name for public methods, whereas a UUID may be more appropriate for internal methods.
///
/// \param closure The closure to execute (conditionally).
///
- (void)asyncWithSourceIdentifier:(NSString * _Nullable)sourceIdentifier closure:(void (^ _Nullable)(void))closure;
/// Asynchronously dispatch after a given timeInterval and execute the provided closure.
/// \param sourceIdentifier A unique identifier for the location in code from which this originated.  It may be a universally unique identifier (UUID) or a friendly name such as “func someFunc()”.  It is generally preferrable to use a friendly name for public methods, whereas a UUID may be more appropriate for internal methods.
///
/// \param timeInterval The TimeInterval to async after.
///
/// \param closure The closure to execute (conditionally).
///
- (void)asyncAfterWithSourceIdentifier:(NSString * _Nullable)sourceIdentifier timeInterval:(NSTimeInterval)timeInterval closure:(void (^ _Nullable)(void))closure;
/// Asynchronously dispatch after a stepped-settling dispatch.
/// The purpose of this dispatch recognizes that when we receive some form of wrapping trigger that really what we’re looking for is the moment in which that trigger’s entire body of work has completed.  Our goal is to move forward after the work associated with punctuated moments has settled.  The use of a stepped-settling dispatch provides a general form of assurance which minimizes the need for other forms of waits downstream.
/// \param sourceIdentifier A unique identifier for the location in code from which this originated.  It may be a universally unique identifier (UUID) or a friendly name such as “func someFunc()”.  It is generally preferrable to use a friendly name for public methods, whereas a UUID may be more appropriate for internal methods.
///
/// \param count A count for the number of dispatch steps.  Default 24.
///
/// \param closure The closure to execute (conditionally).
///
+ (void)asyncAfterSteppedSettlingDispatchWithSourceIdentifier:(NSString * _Nullable)sourceIdentifier count:(NSInteger)count closure:(void (^ _Nullable)(void))closure;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// A class for working with the App Groups capability.
SWIFT_CLASS_NAMED("AppGroups")
@interface KVAAppGroups : NSObject
/// The singleton shared instance.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAAppGroups * _Nonnull shared;)
+ (KVAAppGroups * _Nonnull)shared SWIFT_WARN_UNUSED_RESULT;
/// A shared instance, for convenience— optional.
/// See var <code>shared</code>.  This variable will be nil prior to the shared instance being defaulted.  This may be used to optionally invalidate any existing shared instance without causing it to first be defaulted in the process.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAAppGroups * _Nullable shared_optional;)
+ (KVAAppGroups * _Nullable)shared_optional SWIFT_WARN_UNUSED_RESULT;
/// A string which corresponds to an app group identifier to be used as a shared container for the Kochava SDK.
@property (nonatomic, copy) NSString * _Nullable generalAppGroupIdentifier;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class KVANetworking;

SWIFT_PROTOCOL_NAMED("Networking_Provider")
@protocol KVANetworking_Provider
@property (nonatomic, strong) KVANetworking * _Nullable networking;
@end

@class KVAContext;
@class NSNumber;
@class NSDate;

/// A feature which serves as an authority related to consent for the sharing of personal data.
/// Data sharing privacy laws such as GDPR require consent to be obtained before certain kinds of personal data may be shared with partners.
SWIFT_CLASS_NAMED("Consent")
@interface KVAConsent : NSObject <NSCopying, KVANetworking_Provider>
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (id _Nonnull)copyWithZone:(struct _NSZone * _Nullable)zone SWIFT_WARN_UNUSED_RESULT;
- (id _Nullable)kva_toContext:(KVAContext * _Nullable)context SWIFT_WARN_UNUSED_RESULT;
/// Return a boolean indicating if the app may collect (or calculate) data which may be subject to consent.
/// Return true if consent is not required or else is granted.  This will immediately return false if the consent requirement(s) have been updated but not an updated consent response has not yet been given from the user.  Compare with mayKeepBool, mayPersistBool, and mayShareBool.
- (BOOL)mayCollectBool SWIFT_WARN_UNUSED_RESULT;
/// Return a boolean indicating if the app may persist (or retain in persistent storage) data which may be subject to consent.
/// Return true if consent is not required or else is granted.  This will immediately return false if the consent requirement(s) have been updated but not an updated consent response has not yet been given from the user.  Compare with mayCollectBool, mayKeepBool, and mayShareBool.
- (BOOL)mayPersistBool SWIFT_WARN_UNUSED_RESULT;
/// Return a boolean indicating if the app may share (or export) data which may be subject to consent.
/// Return true if consent is not required or else is granted.  This will immediately return false if the consent requirement(s) have been updated but not an updated consent response has not yet been given from the user.  Compare with mayCollectBool, mayKeepBool, and mayPersistBool.
- (BOOL)mayShareBool SWIFT_WARN_UNUSED_RESULT;
/// Return a boolean indicating if the app may keep (or retain in memory) data which may be subject to consent.
/// Return true if consent is not required or else the user did not otherwise previously deny consent.  This will return true while consent is not known, as long as the previous response did not deny consent.  This includes when the definition for consent has changed and the user previously granted consent.  Compare with mayCollectBool, mayPersistBool, and mayShareBool.
- (BOOL)mayKeepBool SWIFT_WARN_UNUSED_RESULT;
@property (nonatomic, weak) KVANetworking * _Nullable networking;
/// A boolean indicating if GDPR applies to this user.
@property (nonatomic, readonly) BOOL gdprAppliesBool;
/// A boolean indicating if GDPR is enabled.
@property (nonatomic, readonly) BOOL gdprEnabledBool;
/// A boolean wrapped in an NSNumber which indicates if consent has been granted.
/// A value of true indicates consent was granted.  A value of false indicates consent was denied.  A value of nil exists when the user has not provided a response.
/// This API is provided for Objective-C support.  In Swift use var <code>Consent/grantedBool</code>.
@property (nonatomic, strong) NSNumber * _Nullable grantedBoolNumber;
/// Return a date for when consent was granted.
/// If grantedBool == true, then this returns responseDate.  If not, then this returns nil.
@property (nonatomic, readonly, copy) NSDate * _Nullable grantedDate;
/// A boolean indicating if consent is required.
/// This is expected to be true when the user is taken to be under the scope of consent gathering requirements such as GDPR.  This is expected to be the case for EU citizens within EU territory or abroad, and non-EU citizens within EU territory.  When requiredBool is undefined this will return a default of true.  It will also be overridden to false when intelligentManagementBool is false.  This variable may also be set when Manual Managed Requirements is turned on.  See also gdprAppliesBool.
@property (nonatomic, readonly) BOOL requiredBool;
/// A date representing the last time the user did respond concerning consent.
/// This includes both positive and negative responses.  This value is nil when the user has not provided a response.
@property (nonatomic, readonly, copy) NSDate * _Nullable responseDate;
@end


/// A class which defines a context.
/// This class provides the means of defining the context for something that is being done.  It is generally used to identify a target or provider.
SWIFT_CLASS_NAMED("Context")
@interface KVAContext : NSObject
/// A context which represents the host app.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAContext * _Nonnull host;)
+ (KVAContext * _Nonnull)host SWIFT_WARN_UNUSED_RESULT;
/// A context which represents the log.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAContext * _Nonnull log;)
+ (KVAContext * _Nonnull)log SWIFT_WARN_UNUSED_RESULT;
/// A context which represents persistentStorage.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAContext * _Nonnull persistentStorage;)
+ (KVAContext * _Nonnull)persistentStorage SWIFT_WARN_UNUSED_RESULT;
/// A context which represents the SDK.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAContext * _Nonnull sdk;)
+ (KVAContext * _Nonnull)sdk SWIFT_WARN_UNUSED_RESULT;
/// A context which represents the Server.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAContext * _Nonnull server;)
+ (KVAContext * _Nonnull)server SWIFT_WARN_UNUSED_RESULT;
/// A context which represents the Server, and is un-restricted by considerations such as allowed and denied identifiers.
/// This is of particular relevance with Transaction(s) where allowed and/or denied identifiers may not (or not yet) be known, such as config retrievals.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAContext * _Nonnull serverUnrestricted;)
+ (KVAContext * _Nonnull)serverUnrestricted SWIFT_WARN_UNUSED_RESULT;
/// Return a description of the instance.
@property (nonatomic, readonly, copy) NSString * _Nonnull description;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// A class which defines the structure of a dictionary.
/// This class provides the means of defining how a dictionary should be formatted.
SWIFT_CLASS("_TtC17KochavaNetworking16DictionaryFormat")
@interface DictionaryFormat : NSObject <KVANetworking_Provider>
/// An instance of networking.
@property (nonatomic, weak) KVANetworking * _Nullable networking;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end



/// A class which defines a log level, with enumerated values.
SWIFT_CLASS_NAMED("Level")
@interface KVALog_Level : NSObject
/// A log level which never prints visibly in the log.
/// When Log.Message(s) are not printed visibly to the log, they are still posted as notifications.  This enables all Log.Message(s) to be observed, regardless of their current visibility.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level * _Nonnull never;)
+ (KVALog_Level * _Nonnull)never SWIFT_WARN_UNUSED_RESULT;
/// A log level for errors which are to some extent fatal.
/// This does not mean that a crash will necessarily follow, but that something failed unrecoverably.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level * _Nonnull error;)
+ (KVALog_Level * _Nonnull)error SWIFT_WARN_UNUSED_RESULT;
/// A log level for warnings which are not fatal.
/// A warning is generally anything that behaved unexpectedly and should be brought to a developer’s attention.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level * _Nonnull warn;)
+ (KVALog_Level * _Nonnull)warn SWIFT_WARN_UNUSED_RESULT;
/// A log level for general information, such as basic initialization and api calls.
/// This level should be viewed as to be used sparingly, as it is the default log level.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level * _Nonnull info;)
+ (KVALog_Level * _Nonnull)info SWIFT_WARN_UNUSED_RESULT;
/// A log level for low-level messages intended for verifying (or debugging) an integration.  Includes transaction payloads.
/// note:
/// We previously used osLevel .debug here, but the result was that for some time log levels higher than info weren’t showing in Xamarin apps- even in the simulator.  We were able to see log messages in the “Console” app, but only for info or below.  From my research there seem to be known Apple bug(s) associated with this.  So, for a time we switched the osLevel here to .info.  As of Xcode 15.2 it appears to be working at osLevel .debug and so we’ve switched it back to there.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level * _Nonnull debug;)
+ (KVALog_Level * _Nonnull)debug SWIFT_WARN_UNUSED_RESULT;
/// A log level for very low-level messages intended for tracing the origin of an issue.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level * _Nonnull trace;)
+ (KVALog_Level * _Nonnull)trace SWIFT_WARN_UNUSED_RESULT;
/// A log level which always prints visibly in the log.
/// When the logLevel is .always and the visibleMaximumLevel resolves to .never, the visibleMaximumLevel will win, resulting in no visibility.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level * _Nonnull always;)
+ (KVALog_Level * _Nonnull)always SWIFT_WARN_UNUSED_RESULT;
+ (nullable instancetype)from:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
/// Return a description of the instance.
@property (nonatomic, readonly, copy) NSString * _Nonnull description;
/// The identifier for the instance.
/// This identifier is used when displaying log messages related to this instance.  Assuming that the property identifier is reasonable, this should be set to the class identifier of that property, but it can be something else that would make sense to the host app developer.  If the class has a two or three digit alphanumeric prefix it is recommended that the class prefix be omitted.
/// Examples:  “Log.Level.never”, “Log.Level.error”, “Log.Level.warn”, “Log.Level.info”, “Log.Level.debug”, “Log.Level.trace”, “Log.Level.always”.
@property (nonatomic, readonly, copy) NSString * _Nonnull identifier;
/// The universal identifier.
/// Examples:  “never”, “error”, “warn”, “info”, “debug”, “trace”, “always”.
@property (nonatomic, readonly, copy) NSString * _Nonnull universalIdentifier;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


@interface KVALog_Level (SWIFT_EXTENSION(KochavaNetworking))
@end


/// A class which defines an os log level, with enumerated values.
SWIFT_CLASS_NAMED("OSLevel")
@interface KVALog_Level_OSLevel : NSObject
/// An os log level which is used to write messages to the log about a critical event in your app’s execution.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level_OSLevel * _Nonnull critical;)
+ (KVALog_Level_OSLevel * _Nonnull)critical SWIFT_WARN_UNUSED_RESULT;
/// An os log level which is used to write messages to the log about a bug that occurs when your app executes.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level_OSLevel * _Nonnull fault;)
+ (KVALog_Level_OSLevel * _Nonnull)fault SWIFT_WARN_UNUSED_RESULT;
/// An os log level which is used to write information about errors to the log.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level_OSLevel * _Nonnull error;)
+ (KVALog_Level_OSLevel * _Nonnull)error SWIFT_WARN_UNUSED_RESULT;
/// An os log level which is used to write information about warnings to the log.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level_OSLevel * _Nonnull warn;)
+ (KVALog_Level_OSLevel * _Nonnull)warn SWIFT_WARN_UNUSED_RESULT;
/// An os log level which is used to write informative messages to the log.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level_OSLevel * _Nonnull info;)
+ (KVALog_Level_OSLevel * _Nonnull)info SWIFT_WARN_UNUSED_RESULT;
/// An os log level which is used to write debug messages to the log.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level_OSLevel * _Nonnull debug;)
+ (KVALog_Level_OSLevel * _Nonnull)debug SWIFT_WARN_UNUSED_RESULT;
/// An os log level which is used to write trace messages to the log.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level_OSLevel * _Nonnull trace;)
+ (KVALog_Level_OSLevel * _Nonnull)trace SWIFT_WARN_UNUSED_RESULT;
/// An os log level which is the default level.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level_OSLevel * _Nonnull notice;)
+ (KVALog_Level_OSLevel * _Nonnull)notice SWIFT_WARN_UNUSED_RESULT;
+ (nullable instancetype)from:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
/// Return a description of the instance.
@property (nonatomic, readonly, copy) NSString * _Nonnull description;
/// The identifier for the instance.
/// Examples:  “OSLevel.critical”, “OSLevel.fault”, “OSLevel.error”, “OSLevel.warn”, “OSLevel.info”, “OSLevel.debug”, “OSLevel.trace”, “OSLevel.notice”.
@property (nonatomic, readonly, copy) NSString * _Nonnull identifier;
/// The universal identifier.
/// Examples:  “critical”, “fault”, “error”, “warn”, “info”, “debug”, “trace”, “notice”.
@property (nonatomic, readonly, copy) NSString * _Nonnull universalIdentifier;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// A class which constitutes a log, which is a collection of log messages.
SWIFT_CLASS_NAMED("Log")
@interface KVALog : NSObject
/// The singleton shared instance.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog * _Nonnull shared;)
+ (KVALog * _Nonnull)shared SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
/// The visible maximum log level for log messages.
@property (nonatomic, strong) KVALog_Level * _Nullable level;
/// A boolean indicating if log messages may be printed using Logger(s).
/// Default true.  When disabled, log messages will fall back to raw os_log or NSLog.  Raw os_log and NSLog lack certain features which Logger has, but they may print in environments where Logger is not supported.
@property (nonatomic) BOOL loggerEnabledBool;
/// A boolean indicating if log messages may be printed using os_log.
/// Default true.  When disabled, log messages will fall back to NSLog.  NSLog lacks certain features which os_log has, but they may print in environments where os_log is not supported.
@property (nonatomic) BOOL osLogEnabledBool;
/// A boolean indicating if log messages should be pretty printed.
/// Default true.
@property (nonatomic) BOOL prettyPrintBool;
/// A boolean indicating if log messages should be separated by new line and then printed individually.
/// Default false.  This can be used to overcome truncation issues, but it will add message prefixes to the beginning of each line.
@property (nonatomic) BOOL printLinesIndividuallyBool;
/// A prefix string to be added to the beginning of each item printed to the log.
/// Default nil.  This can be set to a value such as “KVA: “ to make filtering log messages easier.  When this is used in conjunction with var <code>printLinesIndividuallyBool</code> this prefix will be printed at the beginning of each line.
@property (nonatomic, copy) NSString * _Nullable printPrefixString;
@end


@interface KVALog (SWIFT_EXTENSION(KochavaNetworking))
@end


/// A class for providing diagnostic messages in a format which has been standardized across all Kochava SDK platforms.
SWIFT_CLASS_NAMED("Diagnostic")
@interface KVADiagnostic : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end



@interface KVALog (SWIFT_EXTENSION(KochavaNetworking))
@end



@interface NSArray<ObjectType> (SWIFT_EXTENSION(KochavaNetworking))
+ (nullable instancetype)kva_from:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
@end


@interface NSData (SWIFT_EXTENSION(KochavaNetworking))
+ (nullable instancetype)kva_from:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
@end


@interface NSDate (SWIFT_EXTENSION(KochavaNetworking))
+ (nullable instancetype)kva_from:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
@end



@interface NSDictionary<KeyType, ObjectType> (SWIFT_EXTENSION(KochavaNetworking))
+ (nullable instancetype)kva_from:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
/// This is a wrapper function which exists for the Objective-C-based wrappers.  See function from(…) in Swit Dictionary class extension for more details.
+ (nullable instancetype)kva_from:(id _Nullable)object identifier:(NSString * _Nullable)identifier method:(NSString * _Nullable)method guardNotOmittedBool:(BOOL)guardNotOmittedBool guardNotEmptyBool:(BOOL)guardNotEmptyBool SWIFT_WARN_UNUSED_RESULT;
@end




@interface NSNumber (SWIFT_EXTENSION(KochavaNetworking))
+ (nullable instancetype)kva_from:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
/// This is a wrapper function which exists for the Objective-C-based wrappers.  See function from(…) in Swit Dictionary class extension for more details.
+ (nullable instancetype)kva_bool_from:(id _Nullable)object identifier:(NSString * _Nullable)identifier method:(NSString * _Nullable)method guardNotOmittedBool:(BOOL)guardNotOmittedBool SWIFT_WARN_UNUSED_RESULT;
/// This is a wrapper function which exists for the Objective-C-based wrappers.  See function from(…) in Swit Dictionary class extension for more details.
+ (nullable instancetype)kva_timeInterval_from:(id _Nullable)object identifier:(NSString * _Nullable)identifier method:(NSString * _Nullable)method guardNotOmittedBool:(BOOL)guardNotOmittedBool SWIFT_WARN_UNUSED_RESULT;
@end


@interface NSString (SWIFT_EXTENSION(KochavaNetworking))
/// Return a json string serialized from a json object.
/// \param prettyPrintBool A boolean indicating whether you want the json to be pretty printed.  Pretty printing involves adding carriage returns, indentation, etc.  It generally makes it more human readable but increases the total bytes.
///
///
/// returns:
/// A formatted string.
+ (NSString * _Nullable)kva_stringFromJSONObject:(id _Nullable)jsonObject prettyPrintBool:(BOOL)prettyPrintBool SWIFT_WARN_UNUSED_RESULT;
+ (nullable instancetype)kva_from:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
/// This is a wrapper function which exists for the Objective-C-based wrappers.  See function from(…) in Swit Dictionary class extension for more details.
+ (nullable instancetype)kva_from:(id _Nullable)object identifier:(NSString * _Nullable)identifier method:(NSString * _Nullable)method guardNotOmittedBool:(BOOL)guardNotOmittedBool guardNotEmptyBool:(BOOL)guardNotEmptyBool SWIFT_WARN_UNUSED_RESULT;
/// Return a JSON object, assuming that the string represents JSON.
- (id _Nullable)kva_serializedJSONObjectWithPrintErrorsBool:(BOOL)printErrorsBool SWIFT_WARN_UNUSED_RESULT;
@end


@interface NSURL (SWIFT_EXTENSION(KochavaNetworking))
/// This is a wrapper function which exists for the Objective-C-based wrappers.  See function from(…) in Swit Dictionary class extension for more details.
+ (nullable instancetype)kva_from:(id _Nullable)object identifier:(NSString * _Nullable)identifier method:(NSString * _Nullable)method guardNotOmittedBool:(BOOL)guardNotOmittedBool guardNotEmptyBool:(BOOL)guardNotEmptyBool SWIFT_WARN_UNUSED_RESULT;
@end

@protocol KVAPrivacyProfile_Registrar;

SWIFT_PROTOCOL_NAMED("PrivacyProfile_RegistrarProvider")
@protocol KVAPrivacyProfile_RegistrarProvider
/// A property which conforms to protocol PrivacyProfile_Registrar.
@property (nonatomic, readonly, strong) id <KVAPrivacyProfile_Registrar> _Nonnull privacyProfile_registrar;
@end

@class KVANetworking_Config;
@class KVANetworking_General;
@class KVANetworking_Linking;
@class KVANetworking_Privacy;
@class KVANetworking_Tasks;
@class KVANetworking_Transactions;
@class KVANetworking_ValueSources;

/// The class Networking provides advanced networking support.
SWIFT_CLASS_NAMED("Networking")
@interface KVANetworking : NSObject <KVAPrivacyProfile_RegistrarProvider>
/// Return a description of the instance.
@property (nonatomic, readonly, copy) NSString * _Nonnull description;
/// Execute an advanced instruction.
/// \param universalIdentifier A universal identifier for the advanced instruction.
///
/// \param parameter A parameter object for the advanced instruction.  This parameter is optional depending on the universalIdentifier specified.
///
/// \param prerequisiteTaskIdentifierArray An optional array of task identifiers to use as prerequisites.
///
- (void)executeAdvancedInstructionWithUniversalIdentifier:(NSObject * _Nonnull)universalIdentifier parameter:(id _Nullable)parameter prerequisiteTaskIdentifierArray:(NSArray<NSString *> * _Nullable)prerequisiteTaskIdentifierArray;
/// A feature which is responsible for controlling and updating the configuration of the networking instance.  This includes any clients, parent or linked.
/// <h1>See</h1>
/// Class <code>Networking/Config-swift.class</code>.
@property (nonatomic, readonly, strong) KVANetworking_Config * _Nonnull config;
/// A feature which encapsulates all of the general aspects of a networking instance not belonging to any other feature components.
/// <h1>See</h1>
/// Class <code>Networking/General</code>.
@property (nonatomic, readonly, strong) KVANetworking_General * _Nonnull general;
/// A feature which is responsible for linking networking instances together.  This extends to include their associated clients, parent or linked.  The shared instances of products containing a networking instance are generally designed to automatically link themselves with other similar shared instances.  Once linked, resources such as tasks, value sources, and transactions become shared through their networking instance.  Functions such as configure(with:) and start() may also be configured to pass along to linked products.  When not using a shared instance, products can still be linked but must be linked manually.
/// <h1>See</h1>
/// Class <code>Networking/Linking-swift.class</code>.
@property (nonatomic, readonly, strong) KVANetworking_Linking * _Nonnull linking;
/// A feature which is responsible for privacy, including intelligent consent.  Privacy profiles are automatically registered from the server.  Alternatively create and register a privacy profile locally by calling class <code>PrivacyProfile</code> func <code>PrivacyProfile/register(name:datapointKeyArray:)</code>.  Enable (or explicitly disable) a profile by calling class <code>Networking/Privacy</code> func <code>Networking/Privacy/setEnabledBool(forProfileName:enabledBool:)</code>.
/// <h1>See</h1>
/// Class <code>Networking/Privacy-swift.class</code>.
@property (nonatomic, readonly, strong) KVANetworking_Privacy * _Nonnull privacy;
/// A feature which is responsible for providing support for tasks.  Tasks are registered here prior to starting the networking instance, and then used when other tasks specify that the first tasks are required to complete as prerequisites.  This includes adapters and transactions which wrap tasks to provide their functionality.
/// <h1>See</h1>
/// Class <code>Networking/Tasks-swift.class</code>.
@property (nonatomic, readonly, strong) KVANetworking_Tasks * _Nonnull tasks;
/// A feature which is responsible for providing support for network transactions.  Transactions are registered here prior to starting the networking instance, and then used when other transactions specify to inherit their parameters as a base through their baseIdentifier.
/// <h1>See</h1>
/// Class <code>Networking/Transactions-swift.class</code>.
@property (nonatomic, readonly, strong) KVANetworking_Transactions * _Nonnull transactions;
/// A feature which is responsible for providing support for value sources.  Value sources are registered here prior to starting the networking instance, and then used when other components reference them.  Notably this includes network transactions, which may specify to source values from these value sources in their request url, headers, and/or body.
/// <h1>See</h1>
/// Class <code>Networking/ValueSources-swift.class</code>.
@property (nonatomic, readonly, strong) KVANetworking_ValueSources * _Nonnull valueSources;
@property (nonatomic, readonly, strong) id <KVAPrivacyProfile_Registrar> _Nonnull privacyProfile_registrar;
/// A boolean indicating if the shared instance’s networking should link automatically.
/// Default true.  If overridden to false, it is imperative that this value be consistently set prior to accessing the shared instance for the first time.  You must make accommodations to set this as early as possible, where it would be prior to any access to var <code>shared</code> throughout all of your code.  Keep in mind that you should expect to need to do the same with any client(s) which would normally automatically link to this client, setting their own boolean to false as well, as those clients could attempt to link as well when their shared instances are accessed for the first time.
/// The presumption is that if you use this feature to disable automatic linking that you would then go on to perform your own linking, making a call to Networking func link(…) as the first interaction(s) you have with the shared instance.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class) BOOL sharedLinkAutomaticallyBool;)
+ (BOOL)sharedLinkAutomaticallyBool SWIFT_WARN_UNUSED_RESULT;
+ (void)setSharedLinkAutomaticallyBool:(BOOL)sharedLinkAutomaticallyBool;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end




@interface KVANetworking (SWIFT_EXTENSION(KochavaNetworking))
@end


/// A feature which is responsible for providing support for network transactions.
SWIFT_CLASS_NAMED("Transactions")
@interface KVANetworking_Transactions : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end


@interface KVANetworking (SWIFT_EXTENSION(KochavaNetworking))
@end


/// A feature which is responsible for providing support for value sources.
SWIFT_CLASS_NAMED("ValueSources")
@interface KVANetworking_ValueSources : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end


@interface KVANetworking (SWIFT_EXTENSION(KochavaNetworking))
@end

@class KVAPrivacyProfile;

SWIFT_PROTOCOL_NAMED("PrivacyProfile_Registrar")
@protocol KVAPrivacyProfile_Registrar
- (void)registerProfile:(KVAPrivacyProfile * _Nonnull)profile;
@end


/// A feature which is responsible for privacy, including intelligent consent.
SWIFT_CLASS_NAMED("Privacy")
@interface KVANetworking_Privacy : NSObject <KVANetworking_Provider, KVAPrivacyProfile_Registrar>
/// Register a profile.
/// \param profile The profile to register.
///
- (void)registerProfile:(KVAPrivacyProfile * _Nonnull)profile;
/// Set a boolean indicating if the specified profile name is enabled.
/// See func <code>register(profile:)</code>.
/// \param profileName The name of a profile.
///
/// \param enabledBool A boolean indicating if enabled.
///
- (void)setEnabledBoolForProfileName:(NSString * _Nonnull)profileName enabledBool:(BOOL)enabledBool;
/// A feature which serves as an authority related to consent for the sharing of personal data.
/// Data sharing privacy laws such as GDPR require consent to be obtained before certain kinds of personal data may be collected, kept in memory, persisted or retained in persistent storage, and/or shared with partners.  During the natural lifecycle, there are times where partners may be added and cause the consent status to fall back to an unknown state.  Later the user may again be prompted and the consent status may (or may not) again come to be known.  All of this is predicated upon whether or not consent is required, which is governed by a variety of factors such as location.
@property (nonatomic, readonly, strong) KVAConsent * _Nonnull intelligentConsent;
/// An instance of networking.
@property (nonatomic, weak) KVANetworking * _Nullable networking;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


@interface KVANetworking (SWIFT_EXTENSION(KochavaNetworking))
@end


@interface KVANetworking (SWIFT_EXTENSION(KochavaNetworking))
@end


/// A feature which is responsible for providing support for tasks.
SWIFT_CLASS_NAMED("Tasks")
@interface KVANetworking_Tasks : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end


@interface KVANetworking (SWIFT_EXTENSION(KochavaNetworking))
@end


/// A feature which is responsible for controlling and updating the configuration of the networking instance.  This includes any clients, parent or linked.
SWIFT_CLASS_NAMED("Config")
@interface KVANetworking_Config : NSObject
/// Get the config dictionary with a completion handler.
/// \param closure_didComplete A completion handler to call once the result has been retrieved.
///
- (void)retrieveWithClosure_didComplete:(void (^ _Nonnull)(KVANetworking_Config * _Nonnull))closure_didComplete;
/// A closure which is called when the config is retrieved.
@property (nonatomic, copy) void (^ _Nullable closure_didComplete)(KVANetworking_Config * _Nonnull);
@property (nonatomic, readonly) BOOL consentGDPRAppliesBool;
/// A boolean indicating if this feature is enabled.
/// Default: false.
@property (nonatomic) BOOL enabledBool;
/// A boolean indicating if the configuration has been collected from the server at least one time.
@property (nonatomic, readonly) BOOL collectedBool;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end



@interface KVANetworking (SWIFT_EXTENSION(KochavaNetworking))
@end


/// A feature which is responsible for linking networking instances together.  This extends to include their associated clients, parent or linked.
SWIFT_CLASS_NAMED("Linking")
@interface KVANetworking_Linking : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end


@interface KVANetworking (SWIFT_EXTENSION(KochavaNetworking))
@end


/// A feature which encapsulates all of the general aspects of a networking instance not belonging to any other feature components.
SWIFT_CLASS_NAMED("General")
@interface KVANetworking_General : NSObject
/// A string containing the partner name, when applicable.
/// An example would be “Moloco”.
@property (nonatomic, copy) NSString * _Nullable partnerNameString;
/// A unique identifier for an app, resolved.
/// This value is a resolved value when taking into consideration both the hostAppGUIDString as well as the serverAppGUIDString.  This is the app GUID that is ultimately sent to the server to identify the app in general contexts.  When set, this defaults to setting the hostAppGUIDString.
@property (nonatomic, copy) NSString * _Nullable appGUIDString;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end




/// A privacy profile.
SWIFT_CLASS_NAMED("PrivacyProfile")
@interface KVAPrivacyProfile : NSObject <KVANetworking_Provider>
/// Create a privacy profile and then register it.
/// \param name The name of the privacy profile.
///
/// \param datapointKeyArray An array of payload keys (datapoint identifiers).
///
+ (void)registerWithName:(NSString * _Nonnull)name datapointKeyArray:(NSArray<NSObject *> * _Nullable)datapointKeyArray;
/// Create a privacy profile and then register it.
/// \param name The name of the privacy profile.
///
/// \param datapointKeyArray An array of payload keys (datapoint identifiers).
///
/// \param registrarArray An array of PrivacyProfile_RegistrarProvider to which to register the privacy profile.
///
+ (void)registerWithName:(NSString * _Nonnull)name datapointKeyArray:(NSArray<NSObject *> * _Nullable)datapointKeyArray registrarArray:(NSArray<id <KVAPrivacyProfile_RegistrarProvider>> * _Nullable)registrarArray;
/// Create a privacy profile and then register it.
/// \param name The name of the privacyProfile.
///
/// \param datapointKeyArray An array of datapoint identifiers.
///
/// \param transactionUniversalIdentifierArray An array of payload identifiers.
///
/// \param registrarArray An array of PrivacyProfile_RegistrarProvider to which to register the PrivacyProfile.
///
+ (void)registerWithName:(NSString * _Nonnull)name datapointKeyArray:(NSArray<NSObject *> * _Nullable)datapointKeyArray transactionUniversalIdentifierArray:(NSArray<NSString *> * _Nullable)transactionUniversalIdentifierArray registrarArray:(NSArray<id <KVAPrivacyProfile_RegistrarProvider>> * _Nullable)registrarArray;
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
/// A unique name for the profile.
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
/// An instance of networking.
/// This exists here related to the conformance to Executable and then Networking_Provider.  When this instance is constructed and then executed as an executable from within the the networking class, the networking class will also when possible stamp itself here as an indication of where it originated, so that this instance can properly default where it should be sent to be executed.  This can be derived from the networking.execution.parentExecutor when cast to whatever it may be expected to be.  Because it’s weak it may disappear at some point, but if it’s there it’s a better default than a shared instance.
@property (nonatomic, weak) KVANetworking * _Nullable networking;
/// An array of payload keys (datapoint identifiers).
@property (nonatomic, readonly, copy) NSArray<NSObject *> * _Nullable datapointKeyArray;
/// An array of payload identifiers (network transaction types).
@property (nonatomic, readonly, copy) NSArray<NSString *> * _Nullable transactionUniversalIdentifierArray;
/// A boolean indicating if the sdk should sleep if this profile is active.
@property (nonatomic, readonly) BOOL sleepBool;
/// A dictionary containing url overrides.
/// The keys of the dictionary corresponds to elements within Transaction.universalIdentifierArray.  The values may either be of type String or Dictionary.  When they are type String they are URL strings.  When they are type Dictionary they contain an array of key/value pairs where the corresponds to Transaction.subIdentifier and the values are URL strings.
@property (nonatomic, readonly, copy) NSDictionary<NSString *, id> * _Nullable urlsDictionary;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end





/// A class which defines a product.
/// A product in this context generally refers to the result of a build.  A product can be used to represent a framework, application, or application extension.
SWIFT_CLASS_NAMED("Product")
@interface KochavaNetworking_Product : NSObject
/// The singleton shared instance.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KochavaNetworking_Product * _Nonnull shared;)
+ (KochavaNetworking_Product * _Nonnull)shared SWIFT_WARN_UNUSED_RESULT;
/// Resets the product.
/// This involves resetting variables to their original states.  This may include releasing shared instances.  When parameter deleteLocalDataBool is passed true it also includes erasing any keys from persistent storage which are associated with the product.  This method will complete asynchronously.  Before working with this product again you should wait until the reset has completed.  See method reset(deleteLocalDataBool:closure_didComplete:).
/// \param deleteLocalDataBool A boolean indicating whether or not local data should be deleted.
///
- (void)resetWithDeleteLocalDataBool:(BOOL)deleteLocalDataBool;
/// Resets the product.
/// This involves resetting variables to their original states.  This may include releasing shared instances.  When parameter deleteLocalDataBool is passed true it also includes erasing any keys from persistent storage which are associated with the product.  This method will complete asynchronously.  Before working with this product again you should wait until the reset has completed.
/// \param deleteLocalDataBool A boolean indicating whether or not local data should be deleted.
///
/// \param closure_didComplete A closure which is called upon completion.
///
- (void)resetWithDeleteLocalDataBool:(BOOL)deleteLocalDataBool closure_didComplete:(void (^ _Nullable)(void))closure_didComplete;
/// Resets the product.
/// This involves resetting variables to their original states.  This may include releasing shared instances.  When parameter deleteLocalDataBool is passed true it also includes erasing any keys from persistent storage which are associated with the product.  When parameter includeExternalVariablesBool is passed true it includes additional variables which are bearing on the functionality of the product but otherwise external to it.  This refers to third party variables.
/// \param deleteLocalDataBool A boolean indicating whether or not local data should be deleted.
///
/// \param includeExternalBool A boolean indicating whether or not external variables should be deleted.  This is intended for testing purposes.
///
/// \param includeGeneralAppGroupBool A boolean indicating whether or not the generalAppGroup user defaults should be deleted.  This is where App Clip data is stored.
///
/// \param logMessagePrintBool A boolean indicating if a log messages consistent with this being a call to a public entry point should be printed.
///
/// \param closure_didComplete A closure which is called upon completion.
///
- (void)resetWithDeleteLocalDataBool:(BOOL)deleteLocalDataBool includeExternalBool:(BOOL)includeExternalBool includeGeneralAppGroupBool:(BOOL)includeGeneralAppGroupBool logMessagePrintBool:(BOOL)logMessagePrintBool closure_didComplete:(void (^ _Nullable)(void))closure_didComplete;
/// Return a description of the instance.
@property (nonatomic, readonly, copy) NSString * _Nonnull description;
/// Shut down the product.
/// This can be regarded as being equivalent to performing a reset, but may also include hints to avoid performing automatic behavior consistent with being freshly initialized.   This method will complete asynchronously.  Before working with this product again you should wait until the shutdown has completed.  See method shutdown(deleteLocalDataBool:closure_didComplete:).
/// \param deleteLocalDataBool A boolean indicating whether or not local data should be deleted.
///
- (void)shutdownWithDeleteLocalDataBool:(BOOL)deleteLocalDataBool;
/// Shut down the product.
/// This can be regarded as being equivalent to performing a reset, but may also include hints to avoid performing automatic behavior consistent with being freshly initialized.  This method will complete asynchronously.  Before working with this product again you should wait until the shutdown has completed.
/// \param deleteLocalDataBool A boolean indicating whether or not local data should be deleted.
///
/// \param closure_didComplete A closure which is called upon completion.
///
- (void)shutdownWithDeleteLocalDataBool:(BOOL)deleteLocalDataBool closure_didComplete:(void (^ _Nullable)(void))closure_didComplete;
/// A boolean indicating if the shared instance’s networking should link automatically.
/// Default true.  If toggled to false any existing links will be discarded.  If toggled back to true it will link automatically again any relationships which are not linked.
/// The presumption is that if you use this feature to disable automatic linking that you would then go on to perform your own linking, making a call to Product func link(…) as the first/next interaction(s) you have with the shared instance.
@property (nonatomic) BOOL linkAutomaticallyBool;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// A controller for working with products.
SWIFT_CLASS_NAMED("ProductController")
@interface KochavaNetworking_ProductController : NSObject
/// The singleton shared instance.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KochavaNetworking_ProductController * _Nonnull shared;)
+ (KochavaNetworking_ProductController * _Nonnull)shared SWIFT_WARN_UNUSED_RESULT;
/// Resets product(s).
/// \param deleteLocalDataBool A boolean indicating whether or not local data should be deleted.
///
/// \param closure_didComplete A closure which is called upon completion.
///
- (void)products_resetWithDeleteLocalDataBool:(BOOL)deleteLocalDataBool closure_didComplete:(void (^ _Nullable)(void))closure_didComplete;
/// Resets product(s).
/// \param deleteLocalDataBool A boolean indicating whether or not local data should be deleted.
///
/// \param includeExternalBool A boolean indicating whether or not external variables should be deleted.  This is intended for testing purposes.
///
/// \param includeGeneralAppGroupBool A boolean indicating whether or not the generalAppGroup user defaults should be deleted.  This is where App Clip data is stored.
///
/// \param logMessagePrintBool A boolean indicating if a log messages consistent with this being a call to a public entry point should be printed.
///
/// \param includeHostBool A boolean indicating if you want to include the host.  The host requires an explicit authorization through this boolean.
///
/// \param includeUIBool A boolean indicating if you want to include module KochavaUI.  Module KochavaUI requires an explicit authorization through this boolean.
///
/// \param includeNetworkingBool A boolean indicating if you want to include module KochavaNetworking.  Module KochavaNetworking requires an explicit authorization through this boolean.
///
/// \param nameArray An array of product names to include.  Optional.  If this array is not set then all products are allowed.  If this is set then only those products whose names are in this array will be included.  If you set an ‘include’ parameter and also set any value in this array, the name of that ‘include’ parameter must still also be in this array to be included.
///
/// \param closure_didComplete A closure which is called upon completion.
///
- (void)products_resetWithDeleteLocalDataBool:(BOOL)deleteLocalDataBool includeExternalBool:(BOOL)includeExternalBool includeGeneralAppGroupBool:(BOOL)includeGeneralAppGroupBool logMessagePrintBool:(BOOL)logMessagePrintBool includeHostBool:(BOOL)includeHostBool includeUIBool:(BOOL)includeUIBool includeNetworkingBool:(BOOL)includeNetworkingBool nameArray:(NSArray<NSString *> * _Nullable)nameArray closure_didComplete:(void (^ _Nullable)(void))closure_didComplete;
/// Shuts down product(s).
/// \param deleteLocalDataBool A boolean indicating whether or not local data should be deleted.
///
/// \param closure_didComplete A closure which is called upon completion.
///
- (void)products_shutdownWithDeleteLocalDataBool:(BOOL)deleteLocalDataBool closure_didComplete:(void (^ _Nullable)(void))closure_didComplete;
/// Shuts down product(s).
/// \param deleteLocalDataBool A boolean indicating whether or not local data should be deleted.
///
/// \param includeHostBool A boolean indicating if you want to include the host.  The host requires an explicit authorization through this boolean.
///
/// \param includeUIBool A boolean indicating if you want to include module KochavaUI.  Module KochavaUI requires an explicit authorization through this boolean.
///
/// \param includeNetworkingBool A boolean indicating if you want to include module KochavaNetworking.  Module KochavaNetworking requires an explicit authorization through this boolean.
///
/// \param nameArray An array of product names to include.  Optional.  If this array is not set then all products are allowed.  If this is set then only those products whose names are in this array will be included.  If you set an ‘include’ parameter and also set any value in this array, the name of that ‘include’ parameter must still also be in this array to be included.
///
/// \param closure_didComplete A closure which is called upon completion.
///
- (void)products_shutdownWithDeleteLocalDataBool:(BOOL)deleteLocalDataBool includeHostBool:(BOOL)includeHostBool includeUIBool:(BOOL)includeUIBool includeNetworkingBool:(BOOL)includeNetworkingBool nameArray:(NSArray<NSString *> * _Nullable)nameArray closure_didComplete:(void (^ _Nullable)(void))closure_didComplete;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end


/// A class for working with system-level properties.
SWIFT_CLASS_NAMED("System")
@interface KVASystem : NSObject
/// The singleton shared instance.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVASystem * _Nonnull shared;)
+ (KVASystem * _Nonnull)shared SWIFT_WARN_UNUSED_RESULT;
/// A shared instance, for convenience— optional.
/// See var <code>shared</code>.  This variable will be nil prior to the shared instance being defaulted.  This may be used to optionally invalidate any existing shared instance without causing it to first be defaulted in the process.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVASystem * _Nullable shared_optional;)
+ (KVASystem * _Nullable)shared_optional SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
/// A boolean indicating if the current host is an app clip.
/// This property will return a default value based on whether or not it can be detected that the host is an app clip.  It uses the bundle identifier and looks for the default suffix of “.Clip” (case insensitive).  If it finds that suffix then this value will default to true, otherwise false.  If this assumption is not accurate for the host, this value can be set explicitly.
@property (nonatomic) BOOL appClipBool;
/// A method which can be called to report that the active state should become true.
/// Calling this method is generally redundant when the host is an application, as this change is observed automatically.  But this method can and should be called in app extensions, such as iMessage apps, to notify when the state is reported to have become active.
- (void)stateActiveDidBecome;
/// A method which can be called to report that the active state should become true.
/// Calling this method is generally redundant when the host is an application, as this change is observed automatically.  But this method can and should be called in app extensions, such as iMessage apps, to notify when the state is reported to have become active.
/// \param sourceIdentifier An identifier which describes the source that is originating the state change.
///
- (void)stateActiveDidBecomeWithSourceIdentifier:(NSString * _Nonnull)sourceIdentifier;
/// A method which can be called to report that the active state should resign true.
/// Calling this method is generally redundant when the host is an application, as this change is observed automatically.  But this method can and should be called in app extensions, such as iMessage apps, to notify when the state is reported to have resigned active.
- (void)stateActiveWillResign;
/// A method which can be called to report that the active state should resign true.
/// Calling this method is generally redundant when the host is an application, as this change is observed automatically.  But this method can and should be called in app extensions, such as iMessage apps, to notify when the state is reported to have resigned active.
/// \param sourceIdentifier An identifier which describes the source that is originating the state change.
///
- (void)stateActiveWillResignWithSourceIdentifier:(NSString * _Nonnull)sourceIdentifier;
/// A constant to use as the source when reporting that a MessagesAppViewController did become active.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull messagesAppViewControllerDidBecomeActiveSourceIdentifier;)
+ (NSString * _Nonnull)messagesAppViewControllerDidBecomeActiveSourceIdentifier SWIFT_WARN_UNUSED_RESULT;
/// A constant to use as the source when reporting that a MessagesAppViewController did resign active.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull messagesAppViewControllerDidResignActiveSourceIdentifier;)
+ (NSString * _Nonnull)messagesAppViewControllerDidResignActiveSourceIdentifier SWIFT_WARN_UNUSED_RESULT;
@end



/// A class which defines a series of time intervals, which express a waterfall pattern.
SWIFT_CLASS_NAMED("TimeIntervalSeries")
@interface KVATimeIntervalSeries : NSObject <NSCopying>
- (id _Nonnull)copyWithZone:(struct _NSZone * _Nullable)zone SWIFT_WARN_UNUSED_RESULT;
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end




@interface NSUserDefaults (SWIFT_EXTENSION(KochavaNetworking))
/// Return a properly formatted key name.
/// This will take an identifierString such as “someIdentifierString” and with a storageIdentifier such as “someStorageIdentifier”, turn it into something like the following:  com.kochava.KochavaMeasurement.someIdentifierString.someStorageIdentifier.  The reason why we are placing the storage id at the end, as opposed to before the identifierString, is because our legacy persisted values never had this key segment.  Inserting one at that location would cause the keys to be sorted inconsistently when compared against a nil value.  By placing it at the end, the order will be consistent, although interlaced.
/// \param prefixString A prefix for the key.  Example: “com.kochava.KochavaMeasurement”.
///
/// \param identifierString An identifier string.  Example: “ClassName.fieldName”.
///
/// \param storageIdentifier An optional storage identifier.  Example: “Two”, or nil.
///
+ (NSString * _Nullable)kva_keyNameStringWithPrefixString:(NSString * _Nullable)prefixString identifierString:(NSString * _Nullable)identifierString storageIdentifier:(NSString * _Nullable)storageIdentifier SWIFT_WARN_UNUSED_RESULT;
@end



#endif
#if __has_attribute(external_source_symbol)
# pragma clang attribute pop
#endif
#if defined(__cplusplus)
#endif
#pragma clang diagnostic pop
#endif

#elif defined(__x86_64__) && __x86_64__
// Generated by Apple Swift version 5.10 (swiftlang-5.10.0.13 clang-1500.3.9.4)
#ifndef KOCHAVANETWORKING_SWIFT_H
#define KOCHAVANETWORKING_SWIFT_H
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wgcc-compat"

#if !defined(__has_include)
# define __has_include(x) 0
#endif
#if !defined(__has_attribute)
# define __has_attribute(x) 0
#endif
#if !defined(__has_feature)
# define __has_feature(x) 0
#endif
#if !defined(__has_warning)
# define __has_warning(x) 0
#endif

#if __has_include(<swift/objc-prologue.h>)
# include <swift/objc-prologue.h>
#endif

#pragma clang diagnostic ignored "-Wauto-import"
#if defined(__OBJC__)
#include <Foundation/Foundation.h>
#endif
#if defined(__cplusplus)
#include <cstdint>
#include <cstddef>
#include <cstdbool>
#include <cstring>
#include <stdlib.h>
#include <new>
#include <type_traits>
#else
#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>
#include <string.h>
#endif
#if defined(__cplusplus)
#if defined(__arm64e__) && __has_include(<ptrauth.h>)
# include <ptrauth.h>
#else
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wreserved-macro-identifier"
# ifndef __ptrauth_swift_value_witness_function_pointer
#  define __ptrauth_swift_value_witness_function_pointer(x)
# endif
# ifndef __ptrauth_swift_class_method_pointer
#  define __ptrauth_swift_class_method_pointer(x)
# endif
#pragma clang diagnostic pop
#endif
#endif

#if !defined(SWIFT_TYPEDEFS)
# define SWIFT_TYPEDEFS 1
# if __has_include(<uchar.h>)
#  include <uchar.h>
# elif !defined(__cplusplus)
typedef uint_least16_t char16_t;
typedef uint_least32_t char32_t;
# endif
typedef float swift_float2  __attribute__((__ext_vector_type__(2)));
typedef float swift_float3  __attribute__((__ext_vector_type__(3)));
typedef float swift_float4  __attribute__((__ext_vector_type__(4)));
typedef double swift_double2  __attribute__((__ext_vector_type__(2)));
typedef double swift_double3  __attribute__((__ext_vector_type__(3)));
typedef double swift_double4  __attribute__((__ext_vector_type__(4)));
typedef int swift_int2  __attribute__((__ext_vector_type__(2)));
typedef int swift_int3  __attribute__((__ext_vector_type__(3)));
typedef int swift_int4  __attribute__((__ext_vector_type__(4)));
typedef unsigned int swift_uint2  __attribute__((__ext_vector_type__(2)));
typedef unsigned int swift_uint3  __attribute__((__ext_vector_type__(3)));
typedef unsigned int swift_uint4  __attribute__((__ext_vector_type__(4)));
#endif

#if !defined(SWIFT_PASTE)
# define SWIFT_PASTE_HELPER(x, y) x##y
# define SWIFT_PASTE(x, y) SWIFT_PASTE_HELPER(x, y)
#endif
#if !defined(SWIFT_METATYPE)
# define SWIFT_METATYPE(X) Class
#endif
#if !defined(SWIFT_CLASS_PROPERTY)
# if __has_feature(objc_class_property)
#  define SWIFT_CLASS_PROPERTY(...) __VA_ARGS__
# else
#  define SWIFT_CLASS_PROPERTY(...) 
# endif
#endif
#if !defined(SWIFT_RUNTIME_NAME)
# if __has_attribute(objc_runtime_name)
#  define SWIFT_RUNTIME_NAME(X) __attribute__((objc_runtime_name(X)))
# else
#  define SWIFT_RUNTIME_NAME(X) 
# endif
#endif
#if !defined(SWIFT_COMPILE_NAME)
# if __has_attribute(swift_name)
#  define SWIFT_COMPILE_NAME(X) __attribute__((swift_name(X)))
# else
#  define SWIFT_COMPILE_NAME(X) 
# endif
#endif
#if !defined(SWIFT_METHOD_FAMILY)
# if __has_attribute(objc_method_family)
#  define SWIFT_METHOD_FAMILY(X) __attribute__((objc_method_family(X)))
# else
#  define SWIFT_METHOD_FAMILY(X) 
# endif
#endif
#if !defined(SWIFT_NOESCAPE)
# if __has_attribute(noescape)
#  define SWIFT_NOESCAPE __attribute__((noescape))
# else
#  define SWIFT_NOESCAPE 
# endif
#endif
#if !defined(SWIFT_RELEASES_ARGUMENT)
# if __has_attribute(ns_consumed)
#  define SWIFT_RELEASES_ARGUMENT __attribute__((ns_consumed))
# else
#  define SWIFT_RELEASES_ARGUMENT 
# endif
#endif
#if !defined(SWIFT_WARN_UNUSED_RESULT)
# if __has_attribute(warn_unused_result)
#  define SWIFT_WARN_UNUSED_RESULT __attribute__((warn_unused_result))
# else
#  define SWIFT_WARN_UNUSED_RESULT 
# endif
#endif
#if !defined(SWIFT_NORETURN)
# if __has_attribute(noreturn)
#  define SWIFT_NORETURN __attribute__((noreturn))
# else
#  define SWIFT_NORETURN 
# endif
#endif
#if !defined(SWIFT_CLASS_EXTRA)
# define SWIFT_CLASS_EXTRA 
#endif
#if !defined(SWIFT_PROTOCOL_EXTRA)
# define SWIFT_PROTOCOL_EXTRA 
#endif
#if !defined(SWIFT_ENUM_EXTRA)
# define SWIFT_ENUM_EXTRA 
#endif
#if !defined(SWIFT_CLASS)
# if __has_attribute(objc_subclassing_restricted)
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# else
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# endif
#endif
#if !defined(SWIFT_RESILIENT_CLASS)
# if __has_attribute(objc_class_stub)
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME) __attribute__((objc_class_stub))
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_class_stub)) SWIFT_CLASS_NAMED(SWIFT_NAME)
# else
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME)
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) SWIFT_CLASS_NAMED(SWIFT_NAME)
# endif
#endif
#if !defined(SWIFT_PROTOCOL)
# define SWIFT_PROTOCOL(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
# define SWIFT_PROTOCOL_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
#endif
#if !defined(SWIFT_EXTENSION)
# define SWIFT_EXTENSION(M) SWIFT_PASTE(M##_Swift_, __LINE__)
#endif
#if !defined(OBJC_DESIGNATED_INITIALIZER)
# if __has_attribute(objc_designated_initializer)
#  define OBJC_DESIGNATED_INITIALIZER __attribute__((objc_designated_initializer))
# else
#  define OBJC_DESIGNATED_INITIALIZER 
# endif
#endif
#if !defined(SWIFT_ENUM_ATTR)
# if __has_attribute(enum_extensibility)
#  define SWIFT_ENUM_ATTR(_extensibility) __attribute__((enum_extensibility(_extensibility)))
# else
#  define SWIFT_ENUM_ATTR(_extensibility) 
# endif
#endif
#if !defined(SWIFT_ENUM)
# define SWIFT_ENUM(_type, _name, _extensibility) enum _name : _type _name; enum SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# if __has_feature(generalized_swift_name)
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) enum _name : _type _name SWIFT_COMPILE_NAME(SWIFT_NAME); enum SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# else
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) SWIFT_ENUM(_type, _name, _extensibility)
# endif
#endif
#if !defined(SWIFT_UNAVAILABLE)
# define SWIFT_UNAVAILABLE __attribute__((unavailable))
#endif
#if !defined(SWIFT_UNAVAILABLE_MSG)
# define SWIFT_UNAVAILABLE_MSG(msg) __attribute__((unavailable(msg)))
#endif
#if !defined(SWIFT_AVAILABILITY)
# define SWIFT_AVAILABILITY(plat, ...) __attribute__((availability(plat, __VA_ARGS__)))
#endif
#if !defined(SWIFT_WEAK_IMPORT)
# define SWIFT_WEAK_IMPORT __attribute__((weak_import))
#endif
#if !defined(SWIFT_DEPRECATED)
# define SWIFT_DEPRECATED __attribute__((deprecated))
#endif
#if !defined(SWIFT_DEPRECATED_MSG)
# define SWIFT_DEPRECATED_MSG(...) __attribute__((deprecated(__VA_ARGS__)))
#endif
#if !defined(SWIFT_DEPRECATED_OBJC)
# if __has_feature(attribute_diagnose_if_objc)
#  define SWIFT_DEPRECATED_OBJC(Msg) __attribute__((diagnose_if(1, Msg, "warning")))
# else
#  define SWIFT_DEPRECATED_OBJC(Msg) SWIFT_DEPRECATED_MSG(Msg)
# endif
#endif
#if defined(__OBJC__)
#if !defined(IBSegueAction)
# define IBSegueAction 
#endif
#endif
#if !defined(SWIFT_EXTERN)
# if defined(__cplusplus)
#  define SWIFT_EXTERN extern "C"
# else
#  define SWIFT_EXTERN extern
# endif
#endif
#if !defined(SWIFT_CALL)
# define SWIFT_CALL __attribute__((swiftcall))
#endif
#if !defined(SWIFT_INDIRECT_RESULT)
# define SWIFT_INDIRECT_RESULT __attribute__((swift_indirect_result))
#endif
#if !defined(SWIFT_CONTEXT)
# define SWIFT_CONTEXT __attribute__((swift_context))
#endif
#if !defined(SWIFT_ERROR_RESULT)
# define SWIFT_ERROR_RESULT __attribute__((swift_error_result))
#endif
#if defined(__cplusplus)
# define SWIFT_NOEXCEPT noexcept
#else
# define SWIFT_NOEXCEPT 
#endif
#if !defined(SWIFT_C_INLINE_THUNK)
# if __has_attribute(always_inline)
# if __has_attribute(nodebug)
#  define SWIFT_C_INLINE_THUNK inline __attribute__((always_inline)) __attribute__((nodebug))
# else
#  define SWIFT_C_INLINE_THUNK inline __attribute__((always_inline))
# endif
# else
#  define SWIFT_C_INLINE_THUNK inline
# endif
#endif
#if defined(_WIN32)
#if !defined(SWIFT_IMPORT_STDLIB_SYMBOL)
# define SWIFT_IMPORT_STDLIB_SYMBOL __declspec(dllimport)
#endif
#else
#if !defined(SWIFT_IMPORT_STDLIB_SYMBOL)
# define SWIFT_IMPORT_STDLIB_SYMBOL 
#endif
#endif
#if defined(__OBJC__)
#if __has_feature(objc_modules)
#if __has_warning("-Watimport-in-framework-header")
#pragma clang diagnostic ignored "-Watimport-in-framework-header"
#endif
@import Foundation;
@import ObjectiveC;
#endif

#endif
#pragma clang diagnostic ignored "-Wproperty-attribute-mismatch"
#pragma clang diagnostic ignored "-Wduplicate-method-arg"
#if __has_warning("-Wpragma-clang-attribute")
# pragma clang diagnostic ignored "-Wpragma-clang-attribute"
#endif
#pragma clang diagnostic ignored "-Wunknown-pragmas"
#pragma clang diagnostic ignored "-Wnullability"
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"

#if __has_attribute(external_source_symbol)
# pragma push_macro("any")
# undef any
# pragma clang attribute push(__attribute__((external_source_symbol(language="Swift", defined_in="KochavaNetworking",generated_declaration))), apply_to=any(function,enum,objc_interface,objc_category,objc_protocol))
# pragma pop_macro("any")
#endif

#if defined(__OBJC__)
@class NSString;

/// A class combines a dispatch queue and a lock into a unified actor.
SWIFT_CLASS_NAMED("Actor")
@interface KVAActor : NSObject
/// A global concurrent default-qos actor, which can be used generically to ensure that code can wait and not block execution.
/// Any sub-system which wishes to ensure execution can wait and not block execution in a global sense may use this queue.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAActor * _Nonnull globalConcurrent;)
+ (KVAActor * _Nonnull)globalConcurrent SWIFT_WARN_UNUSED_RESULT;
/// A global serial default-qos actor, which can be used generically to ensure that code execution is synchronized.
/// Any sub-system which wishes to synchronize code execution in a global sense may use this queue.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAActor * _Nonnull globalSerial;)
+ (KVAActor * _Nonnull)globalSerial SWIFT_WARN_UNUSED_RESULT;
/// The main dispatch queue.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAActor * _Nonnull main;)
+ (KVAActor * _Nonnull)main SWIFT_WARN_UNUSED_RESULT;
/// Return a description of the instance.
@property (nonatomic, readonly, copy) NSString * _Nonnull description;
/// Asynchronously dispatch and execute the provided closure.
/// \param sourceIdentifier A unique identifier for the location in code from which this originated.  It may be a universally unique identifier (UUID) or a friendly name such as “func someFunc()”.  It is generally preferrable to use a friendly name for public methods, whereas a UUID may be more appropriate for internal methods.
///
/// \param closure The closure to execute (conditionally).
///
- (void)asyncWithSourceIdentifier:(NSString * _Nullable)sourceIdentifier closure:(void (^ _Nullable)(void))closure;
/// Asynchronously dispatch after a given timeInterval and execute the provided closure.
/// \param sourceIdentifier A unique identifier for the location in code from which this originated.  It may be a universally unique identifier (UUID) or a friendly name such as “func someFunc()”.  It is generally preferrable to use a friendly name for public methods, whereas a UUID may be more appropriate for internal methods.
///
/// \param timeInterval The TimeInterval to async after.
///
/// \param closure The closure to execute (conditionally).
///
- (void)asyncAfterWithSourceIdentifier:(NSString * _Nullable)sourceIdentifier timeInterval:(NSTimeInterval)timeInterval closure:(void (^ _Nullable)(void))closure;
/// Asynchronously dispatch after a stepped-settling dispatch.
/// The purpose of this dispatch recognizes that when we receive some form of wrapping trigger that really what we’re looking for is the moment in which that trigger’s entire body of work has completed.  Our goal is to move forward after the work associated with punctuated moments has settled.  The use of a stepped-settling dispatch provides a general form of assurance which minimizes the need for other forms of waits downstream.
/// \param sourceIdentifier A unique identifier for the location in code from which this originated.  It may be a universally unique identifier (UUID) or a friendly name such as “func someFunc()”.  It is generally preferrable to use a friendly name for public methods, whereas a UUID may be more appropriate for internal methods.
///
/// \param count A count for the number of dispatch steps.  Default 24.
///
/// \param closure The closure to execute (conditionally).
///
+ (void)asyncAfterSteppedSettlingDispatchWithSourceIdentifier:(NSString * _Nullable)sourceIdentifier count:(NSInteger)count closure:(void (^ _Nullable)(void))closure;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// A class for working with the App Groups capability.
SWIFT_CLASS_NAMED("AppGroups")
@interface KVAAppGroups : NSObject
/// The singleton shared instance.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAAppGroups * _Nonnull shared;)
+ (KVAAppGroups * _Nonnull)shared SWIFT_WARN_UNUSED_RESULT;
/// A shared instance, for convenience— optional.
/// See var <code>shared</code>.  This variable will be nil prior to the shared instance being defaulted.  This may be used to optionally invalidate any existing shared instance without causing it to first be defaulted in the process.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAAppGroups * _Nullable shared_optional;)
+ (KVAAppGroups * _Nullable)shared_optional SWIFT_WARN_UNUSED_RESULT;
/// A string which corresponds to an app group identifier to be used as a shared container for the Kochava SDK.
@property (nonatomic, copy) NSString * _Nullable generalAppGroupIdentifier;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class KVANetworking;

SWIFT_PROTOCOL_NAMED("Networking_Provider")
@protocol KVANetworking_Provider
@property (nonatomic, strong) KVANetworking * _Nullable networking;
@end

@class KVAContext;
@class NSNumber;
@class NSDate;

/// A feature which serves as an authority related to consent for the sharing of personal data.
/// Data sharing privacy laws such as GDPR require consent to be obtained before certain kinds of personal data may be shared with partners.
SWIFT_CLASS_NAMED("Consent")
@interface KVAConsent : NSObject <NSCopying, KVANetworking_Provider>
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
- (id _Nonnull)copyWithZone:(struct _NSZone * _Nullable)zone SWIFT_WARN_UNUSED_RESULT;
- (id _Nullable)kva_toContext:(KVAContext * _Nullable)context SWIFT_WARN_UNUSED_RESULT;
/// Return a boolean indicating if the app may collect (or calculate) data which may be subject to consent.
/// Return true if consent is not required or else is granted.  This will immediately return false if the consent requirement(s) have been updated but not an updated consent response has not yet been given from the user.  Compare with mayKeepBool, mayPersistBool, and mayShareBool.
- (BOOL)mayCollectBool SWIFT_WARN_UNUSED_RESULT;
/// Return a boolean indicating if the app may persist (or retain in persistent storage) data which may be subject to consent.
/// Return true if consent is not required or else is granted.  This will immediately return false if the consent requirement(s) have been updated but not an updated consent response has not yet been given from the user.  Compare with mayCollectBool, mayKeepBool, and mayShareBool.
- (BOOL)mayPersistBool SWIFT_WARN_UNUSED_RESULT;
/// Return a boolean indicating if the app may share (or export) data which may be subject to consent.
/// Return true if consent is not required or else is granted.  This will immediately return false if the consent requirement(s) have been updated but not an updated consent response has not yet been given from the user.  Compare with mayCollectBool, mayKeepBool, and mayPersistBool.
- (BOOL)mayShareBool SWIFT_WARN_UNUSED_RESULT;
/// Return a boolean indicating if the app may keep (or retain in memory) data which may be subject to consent.
/// Return true if consent is not required or else the user did not otherwise previously deny consent.  This will return true while consent is not known, as long as the previous response did not deny consent.  This includes when the definition for consent has changed and the user previously granted consent.  Compare with mayCollectBool, mayPersistBool, and mayShareBool.
- (BOOL)mayKeepBool SWIFT_WARN_UNUSED_RESULT;
@property (nonatomic, weak) KVANetworking * _Nullable networking;
/// A boolean indicating if GDPR applies to this user.
@property (nonatomic, readonly) BOOL gdprAppliesBool;
/// A boolean indicating if GDPR is enabled.
@property (nonatomic, readonly) BOOL gdprEnabledBool;
/// A boolean wrapped in an NSNumber which indicates if consent has been granted.
/// A value of true indicates consent was granted.  A value of false indicates consent was denied.  A value of nil exists when the user has not provided a response.
/// This API is provided for Objective-C support.  In Swift use var <code>Consent/grantedBool</code>.
@property (nonatomic, strong) NSNumber * _Nullable grantedBoolNumber;
/// Return a date for when consent was granted.
/// If grantedBool == true, then this returns responseDate.  If not, then this returns nil.
@property (nonatomic, readonly, copy) NSDate * _Nullable grantedDate;
/// A boolean indicating if consent is required.
/// This is expected to be true when the user is taken to be under the scope of consent gathering requirements such as GDPR.  This is expected to be the case for EU citizens within EU territory or abroad, and non-EU citizens within EU territory.  When requiredBool is undefined this will return a default of true.  It will also be overridden to false when intelligentManagementBool is false.  This variable may also be set when Manual Managed Requirements is turned on.  See also gdprAppliesBool.
@property (nonatomic, readonly) BOOL requiredBool;
/// A date representing the last time the user did respond concerning consent.
/// This includes both positive and negative responses.  This value is nil when the user has not provided a response.
@property (nonatomic, readonly, copy) NSDate * _Nullable responseDate;
@end


/// A class which defines a context.
/// This class provides the means of defining the context for something that is being done.  It is generally used to identify a target or provider.
SWIFT_CLASS_NAMED("Context")
@interface KVAContext : NSObject
/// A context which represents the host app.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAContext * _Nonnull host;)
+ (KVAContext * _Nonnull)host SWIFT_WARN_UNUSED_RESULT;
/// A context which represents the log.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAContext * _Nonnull log;)
+ (KVAContext * _Nonnull)log SWIFT_WARN_UNUSED_RESULT;
/// A context which represents persistentStorage.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAContext * _Nonnull persistentStorage;)
+ (KVAContext * _Nonnull)persistentStorage SWIFT_WARN_UNUSED_RESULT;
/// A context which represents the SDK.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAContext * _Nonnull sdk;)
+ (KVAContext * _Nonnull)sdk SWIFT_WARN_UNUSED_RESULT;
/// A context which represents the Server.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAContext * _Nonnull server;)
+ (KVAContext * _Nonnull)server SWIFT_WARN_UNUSED_RESULT;
/// A context which represents the Server, and is un-restricted by considerations such as allowed and denied identifiers.
/// This is of particular relevance with Transaction(s) where allowed and/or denied identifiers may not (or not yet) be known, such as config retrievals.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVAContext * _Nonnull serverUnrestricted;)
+ (KVAContext * _Nonnull)serverUnrestricted SWIFT_WARN_UNUSED_RESULT;
/// Return a description of the instance.
@property (nonatomic, readonly, copy) NSString * _Nonnull description;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// A class which defines the structure of a dictionary.
/// This class provides the means of defining how a dictionary should be formatted.
SWIFT_CLASS("_TtC17KochavaNetworking16DictionaryFormat")
@interface DictionaryFormat : NSObject <KVANetworking_Provider>
/// An instance of networking.
@property (nonatomic, weak) KVANetworking * _Nullable networking;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end



/// A class which defines a log level, with enumerated values.
SWIFT_CLASS_NAMED("Level")
@interface KVALog_Level : NSObject
/// A log level which never prints visibly in the log.
/// When Log.Message(s) are not printed visibly to the log, they are still posted as notifications.  This enables all Log.Message(s) to be observed, regardless of their current visibility.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level * _Nonnull never;)
+ (KVALog_Level * _Nonnull)never SWIFT_WARN_UNUSED_RESULT;
/// A log level for errors which are to some extent fatal.
/// This does not mean that a crash will necessarily follow, but that something failed unrecoverably.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level * _Nonnull error;)
+ (KVALog_Level * _Nonnull)error SWIFT_WARN_UNUSED_RESULT;
/// A log level for warnings which are not fatal.
/// A warning is generally anything that behaved unexpectedly and should be brought to a developer’s attention.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level * _Nonnull warn;)
+ (KVALog_Level * _Nonnull)warn SWIFT_WARN_UNUSED_RESULT;
/// A log level for general information, such as basic initialization and api calls.
/// This level should be viewed as to be used sparingly, as it is the default log level.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level * _Nonnull info;)
+ (KVALog_Level * _Nonnull)info SWIFT_WARN_UNUSED_RESULT;
/// A log level for low-level messages intended for verifying (or debugging) an integration.  Includes transaction payloads.
/// note:
/// We previously used osLevel .debug here, but the result was that for some time log levels higher than info weren’t showing in Xamarin apps- even in the simulator.  We were able to see log messages in the “Console” app, but only for info or below.  From my research there seem to be known Apple bug(s) associated with this.  So, for a time we switched the osLevel here to .info.  As of Xcode 15.2 it appears to be working at osLevel .debug and so we’ve switched it back to there.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level * _Nonnull debug;)
+ (KVALog_Level * _Nonnull)debug SWIFT_WARN_UNUSED_RESULT;
/// A log level for very low-level messages intended for tracing the origin of an issue.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level * _Nonnull trace;)
+ (KVALog_Level * _Nonnull)trace SWIFT_WARN_UNUSED_RESULT;
/// A log level which always prints visibly in the log.
/// When the logLevel is .always and the visibleMaximumLevel resolves to .never, the visibleMaximumLevel will win, resulting in no visibility.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level * _Nonnull always;)
+ (KVALog_Level * _Nonnull)always SWIFT_WARN_UNUSED_RESULT;
+ (nullable instancetype)from:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
/// Return a description of the instance.
@property (nonatomic, readonly, copy) NSString * _Nonnull description;
/// The identifier for the instance.
/// This identifier is used when displaying log messages related to this instance.  Assuming that the property identifier is reasonable, this should be set to the class identifier of that property, but it can be something else that would make sense to the host app developer.  If the class has a two or three digit alphanumeric prefix it is recommended that the class prefix be omitted.
/// Examples:  “Log.Level.never”, “Log.Level.error”, “Log.Level.warn”, “Log.Level.info”, “Log.Level.debug”, “Log.Level.trace”, “Log.Level.always”.
@property (nonatomic, readonly, copy) NSString * _Nonnull identifier;
/// The universal identifier.
/// Examples:  “never”, “error”, “warn”, “info”, “debug”, “trace”, “always”.
@property (nonatomic, readonly, copy) NSString * _Nonnull universalIdentifier;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


@interface KVALog_Level (SWIFT_EXTENSION(KochavaNetworking))
@end


/// A class which defines an os log level, with enumerated values.
SWIFT_CLASS_NAMED("OSLevel")
@interface KVALog_Level_OSLevel : NSObject
/// An os log level which is used to write messages to the log about a critical event in your app’s execution.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level_OSLevel * _Nonnull critical;)
+ (KVALog_Level_OSLevel * _Nonnull)critical SWIFT_WARN_UNUSED_RESULT;
/// An os log level which is used to write messages to the log about a bug that occurs when your app executes.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level_OSLevel * _Nonnull fault;)
+ (KVALog_Level_OSLevel * _Nonnull)fault SWIFT_WARN_UNUSED_RESULT;
/// An os log level which is used to write information about errors to the log.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level_OSLevel * _Nonnull error;)
+ (KVALog_Level_OSLevel * _Nonnull)error SWIFT_WARN_UNUSED_RESULT;
/// An os log level which is used to write information about warnings to the log.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level_OSLevel * _Nonnull warn;)
+ (KVALog_Level_OSLevel * _Nonnull)warn SWIFT_WARN_UNUSED_RESULT;
/// An os log level which is used to write informative messages to the log.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level_OSLevel * _Nonnull info;)
+ (KVALog_Level_OSLevel * _Nonnull)info SWIFT_WARN_UNUSED_RESULT;
/// An os log level which is used to write debug messages to the log.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level_OSLevel * _Nonnull debug;)
+ (KVALog_Level_OSLevel * _Nonnull)debug SWIFT_WARN_UNUSED_RESULT;
/// An os log level which is used to write trace messages to the log.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level_OSLevel * _Nonnull trace;)
+ (KVALog_Level_OSLevel * _Nonnull)trace SWIFT_WARN_UNUSED_RESULT;
/// An os log level which is the default level.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog_Level_OSLevel * _Nonnull notice;)
+ (KVALog_Level_OSLevel * _Nonnull)notice SWIFT_WARN_UNUSED_RESULT;
+ (nullable instancetype)from:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
/// Return a description of the instance.
@property (nonatomic, readonly, copy) NSString * _Nonnull description;
/// The identifier for the instance.
/// Examples:  “OSLevel.critical”, “OSLevel.fault”, “OSLevel.error”, “OSLevel.warn”, “OSLevel.info”, “OSLevel.debug”, “OSLevel.trace”, “OSLevel.notice”.
@property (nonatomic, readonly, copy) NSString * _Nonnull identifier;
/// The universal identifier.
/// Examples:  “critical”, “fault”, “error”, “warn”, “info”, “debug”, “trace”, “notice”.
@property (nonatomic, readonly, copy) NSString * _Nonnull universalIdentifier;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// A class which constitutes a log, which is a collection of log messages.
SWIFT_CLASS_NAMED("Log")
@interface KVALog : NSObject
/// The singleton shared instance.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVALog * _Nonnull shared;)
+ (KVALog * _Nonnull)shared SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
/// The visible maximum log level for log messages.
@property (nonatomic, strong) KVALog_Level * _Nullable level;
/// A boolean indicating if log messages may be printed using Logger(s).
/// Default true.  When disabled, log messages will fall back to raw os_log or NSLog.  Raw os_log and NSLog lack certain features which Logger has, but they may print in environments where Logger is not supported.
@property (nonatomic) BOOL loggerEnabledBool;
/// A boolean indicating if log messages may be printed using os_log.
/// Default true.  When disabled, log messages will fall back to NSLog.  NSLog lacks certain features which os_log has, but they may print in environments where os_log is not supported.
@property (nonatomic) BOOL osLogEnabledBool;
/// A boolean indicating if log messages should be pretty printed.
/// Default true.
@property (nonatomic) BOOL prettyPrintBool;
/// A boolean indicating if log messages should be separated by new line and then printed individually.
/// Default false.  This can be used to overcome truncation issues, but it will add message prefixes to the beginning of each line.
@property (nonatomic) BOOL printLinesIndividuallyBool;
/// A prefix string to be added to the beginning of each item printed to the log.
/// Default nil.  This can be set to a value such as “KVA: “ to make filtering log messages easier.  When this is used in conjunction with var <code>printLinesIndividuallyBool</code> this prefix will be printed at the beginning of each line.
@property (nonatomic, copy) NSString * _Nullable printPrefixString;
@end


@interface KVALog (SWIFT_EXTENSION(KochavaNetworking))
@end


/// A class for providing diagnostic messages in a format which has been standardized across all Kochava SDK platforms.
SWIFT_CLASS_NAMED("Diagnostic")
@interface KVADiagnostic : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end



@interface KVALog (SWIFT_EXTENSION(KochavaNetworking))
@end



@interface NSArray<ObjectType> (SWIFT_EXTENSION(KochavaNetworking))
+ (nullable instancetype)kva_from:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
@end


@interface NSData (SWIFT_EXTENSION(KochavaNetworking))
+ (nullable instancetype)kva_from:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
@end


@interface NSDate (SWIFT_EXTENSION(KochavaNetworking))
+ (nullable instancetype)kva_from:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
@end



@interface NSDictionary<KeyType, ObjectType> (SWIFT_EXTENSION(KochavaNetworking))
+ (nullable instancetype)kva_from:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
/// This is a wrapper function which exists for the Objective-C-based wrappers.  See function from(…) in Swit Dictionary class extension for more details.
+ (nullable instancetype)kva_from:(id _Nullable)object identifier:(NSString * _Nullable)identifier method:(NSString * _Nullable)method guardNotOmittedBool:(BOOL)guardNotOmittedBool guardNotEmptyBool:(BOOL)guardNotEmptyBool SWIFT_WARN_UNUSED_RESULT;
@end




@interface NSNumber (SWIFT_EXTENSION(KochavaNetworking))
+ (nullable instancetype)kva_from:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
/// This is a wrapper function which exists for the Objective-C-based wrappers.  See function from(…) in Swit Dictionary class extension for more details.
+ (nullable instancetype)kva_bool_from:(id _Nullable)object identifier:(NSString * _Nullable)identifier method:(NSString * _Nullable)method guardNotOmittedBool:(BOOL)guardNotOmittedBool SWIFT_WARN_UNUSED_RESULT;
/// This is a wrapper function which exists for the Objective-C-based wrappers.  See function from(…) in Swit Dictionary class extension for more details.
+ (nullable instancetype)kva_timeInterval_from:(id _Nullable)object identifier:(NSString * _Nullable)identifier method:(NSString * _Nullable)method guardNotOmittedBool:(BOOL)guardNotOmittedBool SWIFT_WARN_UNUSED_RESULT;
@end


@interface NSString (SWIFT_EXTENSION(KochavaNetworking))
/// Return a json string serialized from a json object.
/// \param prettyPrintBool A boolean indicating whether you want the json to be pretty printed.  Pretty printing involves adding carriage returns, indentation, etc.  It generally makes it more human readable but increases the total bytes.
///
///
/// returns:
/// A formatted string.
+ (NSString * _Nullable)kva_stringFromJSONObject:(id _Nullable)jsonObject prettyPrintBool:(BOOL)prettyPrintBool SWIFT_WARN_UNUSED_RESULT;
+ (nullable instancetype)kva_from:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
/// This is a wrapper function which exists for the Objective-C-based wrappers.  See function from(…) in Swit Dictionary class extension for more details.
+ (nullable instancetype)kva_from:(id _Nullable)object identifier:(NSString * _Nullable)identifier method:(NSString * _Nullable)method guardNotOmittedBool:(BOOL)guardNotOmittedBool guardNotEmptyBool:(BOOL)guardNotEmptyBool SWIFT_WARN_UNUSED_RESULT;
/// Return a JSON object, assuming that the string represents JSON.
- (id _Nullable)kva_serializedJSONObjectWithPrintErrorsBool:(BOOL)printErrorsBool SWIFT_WARN_UNUSED_RESULT;
@end


@interface NSURL (SWIFT_EXTENSION(KochavaNetworking))
/// This is a wrapper function which exists for the Objective-C-based wrappers.  See function from(…) in Swit Dictionary class extension for more details.
+ (nullable instancetype)kva_from:(id _Nullable)object identifier:(NSString * _Nullable)identifier method:(NSString * _Nullable)method guardNotOmittedBool:(BOOL)guardNotOmittedBool guardNotEmptyBool:(BOOL)guardNotEmptyBool SWIFT_WARN_UNUSED_RESULT;
@end

@protocol KVAPrivacyProfile_Registrar;

SWIFT_PROTOCOL_NAMED("PrivacyProfile_RegistrarProvider")
@protocol KVAPrivacyProfile_RegistrarProvider
/// A property which conforms to protocol PrivacyProfile_Registrar.
@property (nonatomic, readonly, strong) id <KVAPrivacyProfile_Registrar> _Nonnull privacyProfile_registrar;
@end

@class KVANetworking_Config;
@class KVANetworking_General;
@class KVANetworking_Linking;
@class KVANetworking_Privacy;
@class KVANetworking_Tasks;
@class KVANetworking_Transactions;
@class KVANetworking_ValueSources;

/// The class Networking provides advanced networking support.
SWIFT_CLASS_NAMED("Networking")
@interface KVANetworking : NSObject <KVAPrivacyProfile_RegistrarProvider>
/// Return a description of the instance.
@property (nonatomic, readonly, copy) NSString * _Nonnull description;
/// Execute an advanced instruction.
/// \param universalIdentifier A universal identifier for the advanced instruction.
///
/// \param parameter A parameter object for the advanced instruction.  This parameter is optional depending on the universalIdentifier specified.
///
/// \param prerequisiteTaskIdentifierArray An optional array of task identifiers to use as prerequisites.
///
- (void)executeAdvancedInstructionWithUniversalIdentifier:(NSObject * _Nonnull)universalIdentifier parameter:(id _Nullable)parameter prerequisiteTaskIdentifierArray:(NSArray<NSString *> * _Nullable)prerequisiteTaskIdentifierArray;
/// A feature which is responsible for controlling and updating the configuration of the networking instance.  This includes any clients, parent or linked.
/// <h1>See</h1>
/// Class <code>Networking/Config-swift.class</code>.
@property (nonatomic, readonly, strong) KVANetworking_Config * _Nonnull config;
/// A feature which encapsulates all of the general aspects of a networking instance not belonging to any other feature components.
/// <h1>See</h1>
/// Class <code>Networking/General</code>.
@property (nonatomic, readonly, strong) KVANetworking_General * _Nonnull general;
/// A feature which is responsible for linking networking instances together.  This extends to include their associated clients, parent or linked.  The shared instances of products containing a networking instance are generally designed to automatically link themselves with other similar shared instances.  Once linked, resources such as tasks, value sources, and transactions become shared through their networking instance.  Functions such as configure(with:) and start() may also be configured to pass along to linked products.  When not using a shared instance, products can still be linked but must be linked manually.
/// <h1>See</h1>
/// Class <code>Networking/Linking-swift.class</code>.
@property (nonatomic, readonly, strong) KVANetworking_Linking * _Nonnull linking;
/// A feature which is responsible for privacy, including intelligent consent.  Privacy profiles are automatically registered from the server.  Alternatively create and register a privacy profile locally by calling class <code>PrivacyProfile</code> func <code>PrivacyProfile/register(name:datapointKeyArray:)</code>.  Enable (or explicitly disable) a profile by calling class <code>Networking/Privacy</code> func <code>Networking/Privacy/setEnabledBool(forProfileName:enabledBool:)</code>.
/// <h1>See</h1>
/// Class <code>Networking/Privacy-swift.class</code>.
@property (nonatomic, readonly, strong) KVANetworking_Privacy * _Nonnull privacy;
/// A feature which is responsible for providing support for tasks.  Tasks are registered here prior to starting the networking instance, and then used when other tasks specify that the first tasks are required to complete as prerequisites.  This includes adapters and transactions which wrap tasks to provide their functionality.
/// <h1>See</h1>
/// Class <code>Networking/Tasks-swift.class</code>.
@property (nonatomic, readonly, strong) KVANetworking_Tasks * _Nonnull tasks;
/// A feature which is responsible for providing support for network transactions.  Transactions are registered here prior to starting the networking instance, and then used when other transactions specify to inherit their parameters as a base through their baseIdentifier.
/// <h1>See</h1>
/// Class <code>Networking/Transactions-swift.class</code>.
@property (nonatomic, readonly, strong) KVANetworking_Transactions * _Nonnull transactions;
/// A feature which is responsible for providing support for value sources.  Value sources are registered here prior to starting the networking instance, and then used when other components reference them.  Notably this includes network transactions, which may specify to source values from these value sources in their request url, headers, and/or body.
/// <h1>See</h1>
/// Class <code>Networking/ValueSources-swift.class</code>.
@property (nonatomic, readonly, strong) KVANetworking_ValueSources * _Nonnull valueSources;
@property (nonatomic, readonly, strong) id <KVAPrivacyProfile_Registrar> _Nonnull privacyProfile_registrar;
/// A boolean indicating if the shared instance’s networking should link automatically.
/// Default true.  If overridden to false, it is imperative that this value be consistently set prior to accessing the shared instance for the first time.  You must make accommodations to set this as early as possible, where it would be prior to any access to var <code>shared</code> throughout all of your code.  Keep in mind that you should expect to need to do the same with any client(s) which would normally automatically link to this client, setting their own boolean to false as well, as those clients could attempt to link as well when their shared instances are accessed for the first time.
/// The presumption is that if you use this feature to disable automatic linking that you would then go on to perform your own linking, making a call to Networking func link(…) as the first interaction(s) you have with the shared instance.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class) BOOL sharedLinkAutomaticallyBool;)
+ (BOOL)sharedLinkAutomaticallyBool SWIFT_WARN_UNUSED_RESULT;
+ (void)setSharedLinkAutomaticallyBool:(BOOL)sharedLinkAutomaticallyBool;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end




@interface KVANetworking (SWIFT_EXTENSION(KochavaNetworking))
@end


/// A feature which is responsible for providing support for network transactions.
SWIFT_CLASS_NAMED("Transactions")
@interface KVANetworking_Transactions : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end


@interface KVANetworking (SWIFT_EXTENSION(KochavaNetworking))
@end


/// A feature which is responsible for providing support for value sources.
SWIFT_CLASS_NAMED("ValueSources")
@interface KVANetworking_ValueSources : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end


@interface KVANetworking (SWIFT_EXTENSION(KochavaNetworking))
@end

@class KVAPrivacyProfile;

SWIFT_PROTOCOL_NAMED("PrivacyProfile_Registrar")
@protocol KVAPrivacyProfile_Registrar
- (void)registerProfile:(KVAPrivacyProfile * _Nonnull)profile;
@end


/// A feature which is responsible for privacy, including intelligent consent.
SWIFT_CLASS_NAMED("Privacy")
@interface KVANetworking_Privacy : NSObject <KVANetworking_Provider, KVAPrivacyProfile_Registrar>
/// Register a profile.
/// \param profile The profile to register.
///
- (void)registerProfile:(KVAPrivacyProfile * _Nonnull)profile;
/// Set a boolean indicating if the specified profile name is enabled.
/// See func <code>register(profile:)</code>.
/// \param profileName The name of a profile.
///
/// \param enabledBool A boolean indicating if enabled.
///
- (void)setEnabledBoolForProfileName:(NSString * _Nonnull)profileName enabledBool:(BOOL)enabledBool;
/// A feature which serves as an authority related to consent for the sharing of personal data.
/// Data sharing privacy laws such as GDPR require consent to be obtained before certain kinds of personal data may be collected, kept in memory, persisted or retained in persistent storage, and/or shared with partners.  During the natural lifecycle, there are times where partners may be added and cause the consent status to fall back to an unknown state.  Later the user may again be prompted and the consent status may (or may not) again come to be known.  All of this is predicated upon whether or not consent is required, which is governed by a variety of factors such as location.
@property (nonatomic, readonly, strong) KVAConsent * _Nonnull intelligentConsent;
/// An instance of networking.
@property (nonatomic, weak) KVANetworking * _Nullable networking;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


@interface KVANetworking (SWIFT_EXTENSION(KochavaNetworking))
@end


@interface KVANetworking (SWIFT_EXTENSION(KochavaNetworking))
@end


/// A feature which is responsible for providing support for tasks.
SWIFT_CLASS_NAMED("Tasks")
@interface KVANetworking_Tasks : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end


@interface KVANetworking (SWIFT_EXTENSION(KochavaNetworking))
@end


/// A feature which is responsible for controlling and updating the configuration of the networking instance.  This includes any clients, parent or linked.
SWIFT_CLASS_NAMED("Config")
@interface KVANetworking_Config : NSObject
/// Get the config dictionary with a completion handler.
/// \param closure_didComplete A completion handler to call once the result has been retrieved.
///
- (void)retrieveWithClosure_didComplete:(void (^ _Nonnull)(KVANetworking_Config * _Nonnull))closure_didComplete;
/// A closure which is called when the config is retrieved.
@property (nonatomic, copy) void (^ _Nullable closure_didComplete)(KVANetworking_Config * _Nonnull);
@property (nonatomic, readonly) BOOL consentGDPRAppliesBool;
/// A boolean indicating if this feature is enabled.
/// Default: false.
@property (nonatomic) BOOL enabledBool;
/// A boolean indicating if the configuration has been collected from the server at least one time.
@property (nonatomic, readonly) BOOL collectedBool;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end



@interface KVANetworking (SWIFT_EXTENSION(KochavaNetworking))
@end


/// A feature which is responsible for linking networking instances together.  This extends to include their associated clients, parent or linked.
SWIFT_CLASS_NAMED("Linking")
@interface KVANetworking_Linking : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end


@interface KVANetworking (SWIFT_EXTENSION(KochavaNetworking))
@end


/// A feature which encapsulates all of the general aspects of a networking instance not belonging to any other feature components.
SWIFT_CLASS_NAMED("General")
@interface KVANetworking_General : NSObject
/// A string containing the partner name, when applicable.
/// An example would be “Moloco”.
@property (nonatomic, copy) NSString * _Nullable partnerNameString;
/// A unique identifier for an app, resolved.
/// This value is a resolved value when taking into consideration both the hostAppGUIDString as well as the serverAppGUIDString.  This is the app GUID that is ultimately sent to the server to identify the app in general contexts.  When set, this defaults to setting the hostAppGUIDString.
@property (nonatomic, copy) NSString * _Nullable appGUIDString;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end




/// A privacy profile.
SWIFT_CLASS_NAMED("PrivacyProfile")
@interface KVAPrivacyProfile : NSObject <KVANetworking_Provider>
/// Create a privacy profile and then register it.
/// \param name The name of the privacy profile.
///
/// \param datapointKeyArray An array of payload keys (datapoint identifiers).
///
+ (void)registerWithName:(NSString * _Nonnull)name datapointKeyArray:(NSArray<NSObject *> * _Nullable)datapointKeyArray;
/// Create a privacy profile and then register it.
/// \param name The name of the privacy profile.
///
/// \param datapointKeyArray An array of payload keys (datapoint identifiers).
///
/// \param registrarArray An array of PrivacyProfile_RegistrarProvider to which to register the privacy profile.
///
+ (void)registerWithName:(NSString * _Nonnull)name datapointKeyArray:(NSArray<NSObject *> * _Nullable)datapointKeyArray registrarArray:(NSArray<id <KVAPrivacyProfile_RegistrarProvider>> * _Nullable)registrarArray;
/// Create a privacy profile and then register it.
/// \param name The name of the privacyProfile.
///
/// \param datapointKeyArray An array of datapoint identifiers.
///
/// \param transactionUniversalIdentifierArray An array of payload identifiers.
///
/// \param registrarArray An array of PrivacyProfile_RegistrarProvider to which to register the PrivacyProfile.
///
+ (void)registerWithName:(NSString * _Nonnull)name datapointKeyArray:(NSArray<NSObject *> * _Nullable)datapointKeyArray transactionUniversalIdentifierArray:(NSArray<NSString *> * _Nullable)transactionUniversalIdentifierArray registrarArray:(NSArray<id <KVAPrivacyProfile_RegistrarProvider>> * _Nullable)registrarArray;
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
/// A unique name for the profile.
@property (nonatomic, readonly, copy) NSString * _Nonnull name;
/// An instance of networking.
/// This exists here related to the conformance to Executable and then Networking_Provider.  When this instance is constructed and then executed as an executable from within the the networking class, the networking class will also when possible stamp itself here as an indication of where it originated, so that this instance can properly default where it should be sent to be executed.  This can be derived from the networking.execution.parentExecutor when cast to whatever it may be expected to be.  Because it’s weak it may disappear at some point, but if it’s there it’s a better default than a shared instance.
@property (nonatomic, weak) KVANetworking * _Nullable networking;
/// An array of payload keys (datapoint identifiers).
@property (nonatomic, readonly, copy) NSArray<NSObject *> * _Nullable datapointKeyArray;
/// An array of payload identifiers (network transaction types).
@property (nonatomic, readonly, copy) NSArray<NSString *> * _Nullable transactionUniversalIdentifierArray;
/// A boolean indicating if the sdk should sleep if this profile is active.
@property (nonatomic, readonly) BOOL sleepBool;
/// A dictionary containing url overrides.
/// The keys of the dictionary corresponds to elements within Transaction.universalIdentifierArray.  The values may either be of type String or Dictionary.  When they are type String they are URL strings.  When they are type Dictionary they contain an array of key/value pairs where the corresponds to Transaction.subIdentifier and the values are URL strings.
@property (nonatomic, readonly, copy) NSDictionary<NSString *, id> * _Nullable urlsDictionary;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end





/// A class which defines a product.
/// A product in this context generally refers to the result of a build.  A product can be used to represent a framework, application, or application extension.
SWIFT_CLASS_NAMED("Product")
@interface KochavaNetworking_Product : NSObject
/// The singleton shared instance.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KochavaNetworking_Product * _Nonnull shared;)
+ (KochavaNetworking_Product * _Nonnull)shared SWIFT_WARN_UNUSED_RESULT;
/// Resets the product.
/// This involves resetting variables to their original states.  This may include releasing shared instances.  When parameter deleteLocalDataBool is passed true it also includes erasing any keys from persistent storage which are associated with the product.  This method will complete asynchronously.  Before working with this product again you should wait until the reset has completed.  See method reset(deleteLocalDataBool:closure_didComplete:).
/// \param deleteLocalDataBool A boolean indicating whether or not local data should be deleted.
///
- (void)resetWithDeleteLocalDataBool:(BOOL)deleteLocalDataBool;
/// Resets the product.
/// This involves resetting variables to their original states.  This may include releasing shared instances.  When parameter deleteLocalDataBool is passed true it also includes erasing any keys from persistent storage which are associated with the product.  This method will complete asynchronously.  Before working with this product again you should wait until the reset has completed.
/// \param deleteLocalDataBool A boolean indicating whether or not local data should be deleted.
///
/// \param closure_didComplete A closure which is called upon completion.
///
- (void)resetWithDeleteLocalDataBool:(BOOL)deleteLocalDataBool closure_didComplete:(void (^ _Nullable)(void))closure_didComplete;
/// Resets the product.
/// This involves resetting variables to their original states.  This may include releasing shared instances.  When parameter deleteLocalDataBool is passed true it also includes erasing any keys from persistent storage which are associated with the product.  When parameter includeExternalVariablesBool is passed true it includes additional variables which are bearing on the functionality of the product but otherwise external to it.  This refers to third party variables.
/// \param deleteLocalDataBool A boolean indicating whether or not local data should be deleted.
///
/// \param includeExternalBool A boolean indicating whether or not external variables should be deleted.  This is intended for testing purposes.
///
/// \param includeGeneralAppGroupBool A boolean indicating whether or not the generalAppGroup user defaults should be deleted.  This is where App Clip data is stored.
///
/// \param logMessagePrintBool A boolean indicating if a log messages consistent with this being a call to a public entry point should be printed.
///
/// \param closure_didComplete A closure which is called upon completion.
///
- (void)resetWithDeleteLocalDataBool:(BOOL)deleteLocalDataBool includeExternalBool:(BOOL)includeExternalBool includeGeneralAppGroupBool:(BOOL)includeGeneralAppGroupBool logMessagePrintBool:(BOOL)logMessagePrintBool closure_didComplete:(void (^ _Nullable)(void))closure_didComplete;
/// Return a description of the instance.
@property (nonatomic, readonly, copy) NSString * _Nonnull description;
/// Shut down the product.
/// This can be regarded as being equivalent to performing a reset, but may also include hints to avoid performing automatic behavior consistent with being freshly initialized.   This method will complete asynchronously.  Before working with this product again you should wait until the shutdown has completed.  See method shutdown(deleteLocalDataBool:closure_didComplete:).
/// \param deleteLocalDataBool A boolean indicating whether or not local data should be deleted.
///
- (void)shutdownWithDeleteLocalDataBool:(BOOL)deleteLocalDataBool;
/// Shut down the product.
/// This can be regarded as being equivalent to performing a reset, but may also include hints to avoid performing automatic behavior consistent with being freshly initialized.  This method will complete asynchronously.  Before working with this product again you should wait until the shutdown has completed.
/// \param deleteLocalDataBool A boolean indicating whether or not local data should be deleted.
///
/// \param closure_didComplete A closure which is called upon completion.
///
- (void)shutdownWithDeleteLocalDataBool:(BOOL)deleteLocalDataBool closure_didComplete:(void (^ _Nullable)(void))closure_didComplete;
/// A boolean indicating if the shared instance’s networking should link automatically.
/// Default true.  If toggled to false any existing links will be discarded.  If toggled back to true it will link automatically again any relationships which are not linked.
/// The presumption is that if you use this feature to disable automatic linking that you would then go on to perform your own linking, making a call to Product func link(…) as the first/next interaction(s) you have with the shared instance.
@property (nonatomic) BOOL linkAutomaticallyBool;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// A controller for working with products.
SWIFT_CLASS_NAMED("ProductController")
@interface KochavaNetworking_ProductController : NSObject
/// The singleton shared instance.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KochavaNetworking_ProductController * _Nonnull shared;)
+ (KochavaNetworking_ProductController * _Nonnull)shared SWIFT_WARN_UNUSED_RESULT;
/// Resets product(s).
/// \param deleteLocalDataBool A boolean indicating whether or not local data should be deleted.
///
/// \param closure_didComplete A closure which is called upon completion.
///
- (void)products_resetWithDeleteLocalDataBool:(BOOL)deleteLocalDataBool closure_didComplete:(void (^ _Nullable)(void))closure_didComplete;
/// Resets product(s).
/// \param deleteLocalDataBool A boolean indicating whether or not local data should be deleted.
///
/// \param includeExternalBool A boolean indicating whether or not external variables should be deleted.  This is intended for testing purposes.
///
/// \param includeGeneralAppGroupBool A boolean indicating whether or not the generalAppGroup user defaults should be deleted.  This is where App Clip data is stored.
///
/// \param logMessagePrintBool A boolean indicating if a log messages consistent with this being a call to a public entry point should be printed.
///
/// \param includeHostBool A boolean indicating if you want to include the host.  The host requires an explicit authorization through this boolean.
///
/// \param includeUIBool A boolean indicating if you want to include module KochavaUI.  Module KochavaUI requires an explicit authorization through this boolean.
///
/// \param includeNetworkingBool A boolean indicating if you want to include module KochavaNetworking.  Module KochavaNetworking requires an explicit authorization through this boolean.
///
/// \param nameArray An array of product names to include.  Optional.  If this array is not set then all products are allowed.  If this is set then only those products whose names are in this array will be included.  If you set an ‘include’ parameter and also set any value in this array, the name of that ‘include’ parameter must still also be in this array to be included.
///
/// \param closure_didComplete A closure which is called upon completion.
///
- (void)products_resetWithDeleteLocalDataBool:(BOOL)deleteLocalDataBool includeExternalBool:(BOOL)includeExternalBool includeGeneralAppGroupBool:(BOOL)includeGeneralAppGroupBool logMessagePrintBool:(BOOL)logMessagePrintBool includeHostBool:(BOOL)includeHostBool includeUIBool:(BOOL)includeUIBool includeNetworkingBool:(BOOL)includeNetworkingBool nameArray:(NSArray<NSString *> * _Nullable)nameArray closure_didComplete:(void (^ _Nullable)(void))closure_didComplete;
/// Shuts down product(s).
/// \param deleteLocalDataBool A boolean indicating whether or not local data should be deleted.
///
/// \param closure_didComplete A closure which is called upon completion.
///
- (void)products_shutdownWithDeleteLocalDataBool:(BOOL)deleteLocalDataBool closure_didComplete:(void (^ _Nullable)(void))closure_didComplete;
/// Shuts down product(s).
/// \param deleteLocalDataBool A boolean indicating whether or not local data should be deleted.
///
/// \param includeHostBool A boolean indicating if you want to include the host.  The host requires an explicit authorization through this boolean.
///
/// \param includeUIBool A boolean indicating if you want to include module KochavaUI.  Module KochavaUI requires an explicit authorization through this boolean.
///
/// \param includeNetworkingBool A boolean indicating if you want to include module KochavaNetworking.  Module KochavaNetworking requires an explicit authorization through this boolean.
///
/// \param nameArray An array of product names to include.  Optional.  If this array is not set then all products are allowed.  If this is set then only those products whose names are in this array will be included.  If you set an ‘include’ parameter and also set any value in this array, the name of that ‘include’ parameter must still also be in this array to be included.
///
/// \param closure_didComplete A closure which is called upon completion.
///
- (void)products_shutdownWithDeleteLocalDataBool:(BOOL)deleteLocalDataBool includeHostBool:(BOOL)includeHostBool includeUIBool:(BOOL)includeUIBool includeNetworkingBool:(BOOL)includeNetworkingBool nameArray:(NSArray<NSString *> * _Nullable)nameArray closure_didComplete:(void (^ _Nullable)(void))closure_didComplete;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end


/// A class for working with system-level properties.
SWIFT_CLASS_NAMED("System")
@interface KVASystem : NSObject
/// The singleton shared instance.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVASystem * _Nonnull shared;)
+ (KVASystem * _Nonnull)shared SWIFT_WARN_UNUSED_RESULT;
/// A shared instance, for convenience— optional.
/// See var <code>shared</code>.  This variable will be nil prior to the shared instance being defaulted.  This may be used to optionally invalidate any existing shared instance without causing it to first be defaulted in the process.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, strong) KVASystem * _Nullable shared_optional;)
+ (KVASystem * _Nullable)shared_optional SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
/// A boolean indicating if the current host is an app clip.
/// This property will return a default value based on whether or not it can be detected that the host is an app clip.  It uses the bundle identifier and looks for the default suffix of “.Clip” (case insensitive).  If it finds that suffix then this value will default to true, otherwise false.  If this assumption is not accurate for the host, this value can be set explicitly.
@property (nonatomic) BOOL appClipBool;
/// A method which can be called to report that the active state should become true.
/// Calling this method is generally redundant when the host is an application, as this change is observed automatically.  But this method can and should be called in app extensions, such as iMessage apps, to notify when the state is reported to have become active.
- (void)stateActiveDidBecome;
/// A method which can be called to report that the active state should become true.
/// Calling this method is generally redundant when the host is an application, as this change is observed automatically.  But this method can and should be called in app extensions, such as iMessage apps, to notify when the state is reported to have become active.
/// \param sourceIdentifier An identifier which describes the source that is originating the state change.
///
- (void)stateActiveDidBecomeWithSourceIdentifier:(NSString * _Nonnull)sourceIdentifier;
/// A method which can be called to report that the active state should resign true.
/// Calling this method is generally redundant when the host is an application, as this change is observed automatically.  But this method can and should be called in app extensions, such as iMessage apps, to notify when the state is reported to have resigned active.
- (void)stateActiveWillResign;
/// A method which can be called to report that the active state should resign true.
/// Calling this method is generally redundant when the host is an application, as this change is observed automatically.  But this method can and should be called in app extensions, such as iMessage apps, to notify when the state is reported to have resigned active.
/// \param sourceIdentifier An identifier which describes the source that is originating the state change.
///
- (void)stateActiveWillResignWithSourceIdentifier:(NSString * _Nonnull)sourceIdentifier;
/// A constant to use as the source when reporting that a MessagesAppViewController did become active.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull messagesAppViewControllerDidBecomeActiveSourceIdentifier;)
+ (NSString * _Nonnull)messagesAppViewControllerDidBecomeActiveSourceIdentifier SWIFT_WARN_UNUSED_RESULT;
/// A constant to use as the source when reporting that a MessagesAppViewController did resign active.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly, copy) NSString * _Nonnull messagesAppViewControllerDidResignActiveSourceIdentifier;)
+ (NSString * _Nonnull)messagesAppViewControllerDidResignActiveSourceIdentifier SWIFT_WARN_UNUSED_RESULT;
@end



/// A class which defines a series of time intervals, which express a waterfall pattern.
SWIFT_CLASS_NAMED("TimeIntervalSeries")
@interface KVATimeIntervalSeries : NSObject <NSCopying>
- (id _Nonnull)copyWithZone:(struct _NSZone * _Nullable)zone SWIFT_WARN_UNUSED_RESULT;
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end




@interface NSUserDefaults (SWIFT_EXTENSION(KochavaNetworking))
/// Return a properly formatted key name.
/// This will take an identifierString such as “someIdentifierString” and with a storageIdentifier such as “someStorageIdentifier”, turn it into something like the following:  com.kochava.KochavaMeasurement.someIdentifierString.someStorageIdentifier.  The reason why we are placing the storage id at the end, as opposed to before the identifierString, is because our legacy persisted values never had this key segment.  Inserting one at that location would cause the keys to be sorted inconsistently when compared against a nil value.  By placing it at the end, the order will be consistent, although interlaced.
/// \param prefixString A prefix for the key.  Example: “com.kochava.KochavaMeasurement”.
///
/// \param identifierString An identifier string.  Example: “ClassName.fieldName”.
///
/// \param storageIdentifier An optional storage identifier.  Example: “Two”, or nil.
///
+ (NSString * _Nullable)kva_keyNameStringWithPrefixString:(NSString * _Nullable)prefixString identifierString:(NSString * _Nullable)identifierString storageIdentifier:(NSString * _Nullable)storageIdentifier SWIFT_WARN_UNUSED_RESULT;
@end



#endif
#if __has_attribute(external_source_symbol)
# pragma clang attribute pop
#endif
#if defined(__cplusplus)
#endif
#pragma clang diagnostic pop
#endif

#else
#error unsupported Swift architecture
#endif
