//
//  Campaign.h
//  iosAppiceSDK
//
//  Created by Ajith Pepi Anbu Selvan on 07/09/24.
//  Copyright © 2024 Semusi. All rights reserved.
//

#import "Action.h"
#import <UserNotifications/UserNotifications.h>

@interface Campaign : NSObject

//Properties for all campaign types

@property (nonatomic, strong) NSString *campId;
@property (nonatomic, strong) NSString *actionType;
@property (nonatomic, strong) NSString *actionUrl;
@property (nonatomic, strong) NSMutableDictionary *customData;

@property (strong, nonatomic) NSString *expandedImage;
@property (strong, nonatomic) NSString *expandedDescription;

@property (nonatomic, strong) NSNumber *allDay;
@property (nonatomic, strong) NSNumber *allWeek;
@property (nonatomic, strong) NSDictionary *audiSegment;
@property (nonatomic, strong) NSNumber *ceventTime;
@property (nonatomic, strong) NSNumber *count;
@property (nonatomic, strong) NSNumber *cstate;
@property (nonatomic, strong) NSDictionary *data;
@property (nonatomic, strong) NSString *days;
@property (nonatomic, strong) NSNumber *delayi;
@property (nonatomic, strong) NSString *delayu;
@property (nonatomic, strong) NSNumber *delays;
@property (nonatomic, strong) NSString *eventname;
@property (nonatomic, strong) NSDictionary *frequency;
@property (nonatomic, strong) NSNumber *startDate;
@property (nonatomic, strong) NSString *timerange;
@property (nonatomic, strong) NSString *type;
@property (nonatomic, strong) NSString *typeId;

@property (nonatomic, strong) NSArray<Action *> *actions; // Array of Action objects
@property (nonatomic,assign) NSInteger selectedActionIndex;

@property (nonatomic, strong) NSString *title;
@property (nonatomic, strong) NSString *descriptions;//To avoid conflicts with NSObject's 'description' property, unlike the other platform 'description' field.
@property (nonatomic, strong) NSString *icon;

// Method to return an array of notification actions
- (NSArray<UNNotificationAction *> *)generateNotificationActions;

- (instancetype)initWithDictionary:(NSDictionary *)dict forType:(NSString *)type;
- (NSDictionary *)toDictionary;
- (NSString*)toJson;
@end


