//
//  Action.h
//  iosAppiceSDK
//
//  Created by Ajith Pepi Anbu Selvan on 30/09/24.
//  Copyright © 2024 Semusi. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger, ActionType) {
    DeepLink,      // Represents "dl" (deep link)
    LandingPage,   // Represents "lp" (landing page)
    RemindLater,   // Represents "rml" (remind me later)
    Reply,         // Represents "rly" (reply text based)
    Dismiss,       // Represents "dismiss" (dismiss button)
    Copy,          // Represents "cp" (copy text)
    Share,         // Represents "sh" (share content)
    Custom         // Unknown or other action types
};

@interface Action : NSObject

@property (nonatomic, assign) NSString *actionType;
@property (nonatomic, strong) NSString *actionTitle;
@property (nonatomic, strong) NSString *actionUrl;
@property (nonatomic, strong) NSString *actionContent;
@property (nonatomic, strong) NSString *replyText;

- (instancetype)initWithDictionary:(NSDictionary *)dict;

ActionType ActionTypeFromString(NSString *actionTypeString);

- (NSDictionary *)toDictionary;

@end
