//
//  appICEUserDetails.h
//  appICETestApp
//
//  Created by MacBook on 29/08/17.
//  Copyright © 2017 InnovationBox. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface CustomUserPropertyConstants : NSObject

@property (class, nonatomic, readonly) NSString *FIRST_SEEN;
@property (class, nonatomic, readonly) NSString *LAST_SEEN;
@property (class, nonatomic, readonly) NSString *TOP_N_PRODUCTS_VIEWED;
@property (class, nonatomic, readonly) NSString *N_COMPLAINTS_RAISED;
@property (class, nonatomic, readonly) NSString *PREF_LOGIN_DEVICE ;
@property (class, nonatomic, readonly) NSString *REFERRAL_CAMPAIGN;

@end

@interface Ecommerce : CustomUserPropertyConstants

@property (class, nonatomic, readonly) NSString *TOTAL_ORDER_VALUE;
@property (class, nonatomic, readonly) NSString *ADD_TO_CART_N_DAYS;

@end

@interface FinancialServices : CustomUserPropertyConstants

@property (class, nonatomic, readonly) NSString *CREDIT_SCORE;
@property (class, nonatomic, readonly) NSString *DEBT_TO_INCOME_RATIO;
@property (class, nonatomic, readonly) NSString *SAVINGS_BALANCE;
@property (class, nonatomic, readonly) NSString *CHECKING_BALANCE;
@property (class, nonatomic, readonly) NSString *AVERAGE_TRANSACTION_AMOUNT;
@property (class, nonatomic, readonly) NSString *FREQUENCY_OF_TRANSACTION;
@property (class, nonatomic, readonly) NSString *TYPE_OF_TRANSACTION;

@end


@interface appICEUserDetails : NSObject


extern NSString* const kAIUserName;
extern NSString* const kAIUserUsername;
extern NSString* const kAIUserEmail;
extern NSString* const kAIUserOrganization;
extern NSString* const kAIUserPhone;
extern NSString* const kAIUserGender;
extern NSString* const kAIUserBirthYear;
extern NSString* const kAIUserIsUserEmployed;
extern NSString* const kAIUserEmploymentType;
extern NSString* const kAIUserEducationType;
extern NSString* const kAIUserIsUserMarried;
extern NSString* const kAIUserAge;
extern NSString* const kAIUserPicture;
extern NSString* const kAIUserPicturePath;
extern NSString* const kAIUserCustom;
extern NSString* const kAIAlias;

@property (nonatomic, assign) int age;
@property (nonatomic, assign) BOOL is_user_married;
@property (nonatomic, assign) BOOL is_user_employed;
@property (nonatomic, assign) long dob;
@property (strong, nonatomic) NSString *name;
@property (strong, nonatomic) NSString * email;
@property (strong, nonatomic) NSString * phone;
@property (strong, nonatomic) NSString * gender;

@property (strong, nonatomic) NSString * employment_type;
@property (strong, nonatomic) NSString * education_type;


@property (nonatomic, strong) NSDictionary *customProperties;

+(appICEUserDetails*)sharedUserDetails;

// GET USER DETAIL IN AppICE
-(appICEUserDetails *) getUserDetail;

// SET USER DETAIL IN AppICE
-(void) setUserDetail:(appICEUserDetails*) userdetail;

//conversion code toDictionary for GetUser
- (NSDictionary *)toDictionary;
- (NSString*)toJson;

- (NSMutableArray *)getUser:(NSArray *)userIds;
@end
