#import "allincludes.h"
#import <JavaScriptCore/JavaScriptCore.h>
void loadNFICoreLocationModules(JSContext* context)
{
	load_CoreLocation_CLLocation_symbols(context);
	load_CoreLocation_CLRegion_symbols(context);
	load_CoreLocation_CLCircularRegion_symbols(context);
	load_CoreLocation_CLBeaconIdentityConstraint_symbols(context);
	load_CoreLocation_CLBeaconRegion_symbols(context);
	load_CoreLocation_CLHeading_symbols(context);
	load_CoreLocation_CLLocationManager_symbols(context);
	load_CoreLocation_CLVisit_symbols(context);
	load_CoreLocation_CLLocationManager_CLVisitExtensions_symbols(context);
	load_CoreLocation_CLPlacemark_symbols(context);
	load_CoreLocation_CLGeocoder_symbols(context);
	load_CoreLocation_CLLocationManagerDelegate_symbols(context);
	load_CoreLocation_CLLocationPushServiceExtension_symbols(context);
	load_CoreLocation_CLError_symbols(context);
	load_CoreLocation_CLLocationPushServiceError_symbols(context);
	load_CoreLocation_CLErrorDomain_symbols(context);
}

JSValue* extractNFICoreLocationStructArgument(const char* type, NSInvocation* invocation, NSUInteger index, JSContext* context)
{
	if (strcmp(type, @encode(CLLocationCoordinate2D)) == 0) {
		CLLocationCoordinate2D argument;
		[invocation getArgument: &argument atIndex: index];
		return [JSValue valueWithCLLocationCoordinate2D: argument inContext: context];
	}    
    return nil;
}

BOOL setNFICoreLocationStructReturnValue(const char* type, JSValue* value, NSInvocation* invocation)
{
	if (strcmp(type, @encode(CLLocationCoordinate2D)) == 0) {
		CLLocationCoordinate2D returnValue = value.toCLLocationCoordinate2D;
		[invocation setReturnValue: &returnValue];
		return YES;
	}    
    return NO;
}

