#import <objc/runtime.h>
#import "allincludes.h"
#import <NFIUtility/CallbackSupport.h>
#import <NFIUtility/PointerSupport.h>
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wformat-security"
#pragma clang diagnostic ignored "-Wdeprecated-declarations"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#pragma clang diagnostic ignored "-Wnullability-completeness"
@implementation JSValue (CoreLocation_CLLocation)
+(JSValue*) valueWithCLLocationCoordinate2D: (CLLocationCoordinate2D) s inContext: (JSContext*) context {
	return [JSValue valueWithObject: @{
		@"latitude": @(s.latitude),
		@"longitude": @(s.longitude),
	} inContext: context];
}
-(CLLocationCoordinate2D) toCLLocationCoordinate2D {
	return (CLLocationCoordinate2D) {
		(CLLocationDegrees) [self[@"latitude"] toDouble],
		(CLLocationDegrees) [self[@"longitude"] toDouble],
	};
}
@end
@implementation CLFloor (Exports)
-(id) jsinitWithCoder: (NSCoder *) coder 
{
	id resultVal__;
	resultVal__ = [[self initWithCoder: coder ] autorelease];
	return resultVal__;
}
@end
@implementation CLLocationSourceInformation (Exports)
-(id) jsinitWithSoftwareSimulationState: (BOOL) isSoftware andExternalAccessoryState: (BOOL) isAccessory 
{
	id resultVal__;
	resultVal__ = [[self initWithSoftwareSimulationState: isSoftware andExternalAccessoryState: isAccessory ] autorelease];
	return resultVal__;
}
-(id) jsinitWithCoder: (NSCoder *) coder 
{
	id resultVal__;
	resultVal__ = [[self initWithCoder: coder ] autorelease];
	return resultVal__;
}
@end
@implementation CLLocation (Exports)
-(id) jsinitWithLatitude: (CLLocationDegrees) latitude longitude: (CLLocationDegrees) longitude 
{
	id resultVal__;
	resultVal__ = [[self initWithLatitude: latitude longitude: longitude ] autorelease];
	return resultVal__;
}
-(id) jsinitWithCoordinate: (CLLocationCoordinate2D) coordinate altitude: (CLLocationDistance) altitude horizontalAccuracy: (CLLocationAccuracy) hAccuracy verticalAccuracy: (CLLocationAccuracy) vAccuracy timestamp: (NSDate *) timestamp 
{
	id resultVal__;
	resultVal__ = [[self initWithCoordinate: coordinate altitude: altitude horizontalAccuracy: hAccuracy verticalAccuracy: vAccuracy timestamp: timestamp ] autorelease];
	return resultVal__;
}
-(id) jsinitWithCoordinate: (CLLocationCoordinate2D) coordinate altitude: (CLLocationDistance) altitude horizontalAccuracy: (CLLocationAccuracy) hAccuracy verticalAccuracy: (CLLocationAccuracy) vAccuracy course: (CLLocationDirection) course speed: (CLLocationSpeed) speed timestamp: (NSDate *) timestamp 
{
	id resultVal__;
	resultVal__ = [[self initWithCoordinate: coordinate altitude: altitude horizontalAccuracy: hAccuracy verticalAccuracy: vAccuracy course: course speed: speed timestamp: timestamp ] autorelease];
	return resultVal__;
}
-(id) jsinitWithCoordinate: (CLLocationCoordinate2D) coordinate altitude: (CLLocationDistance) altitude horizontalAccuracy: (CLLocationAccuracy) hAccuracy verticalAccuracy: (CLLocationAccuracy) vAccuracy course: (CLLocationDirection) course courseAccuracy: (CLLocationDirectionAccuracy) courseAccuracy speed: (CLLocationSpeed) speed speedAccuracy: (CLLocationSpeedAccuracy) speedAccuracy timestamp: (NSDate *) timestamp 
{
	id resultVal__;
	resultVal__ = [[self initWithCoordinate: coordinate altitude: altitude horizontalAccuracy: hAccuracy verticalAccuracy: vAccuracy course: course courseAccuracy: courseAccuracy speed: speed speedAccuracy: speedAccuracy timestamp: timestamp ] autorelease];
	return resultVal__;
}
-(id) jsinitWithCoordinate: (CLLocationCoordinate2D) coordinate altitude: (CLLocationDistance) altitude horizontalAccuracy: (CLLocationAccuracy) hAccuracy verticalAccuracy: (CLLocationAccuracy) vAccuracy course: (CLLocationDirection) course courseAccuracy: (CLLocationDirectionAccuracy) courseAccuracy speed: (CLLocationSpeed) speed speedAccuracy: (CLLocationSpeedAccuracy) speedAccuracy timestamp: (NSDate *) timestamp sourceInfo: (CLLocationSourceInformation *) sourceInfo 
{
	id resultVal__;
	resultVal__ = [[self initWithCoordinate: coordinate altitude: altitude horizontalAccuracy: hAccuracy verticalAccuracy: vAccuracy course: course courseAccuracy: courseAccuracy speed: speed speedAccuracy: speedAccuracy timestamp: timestamp sourceInfo: sourceInfo ] autorelease];
	return resultVal__;
}
-(id) jsinitWithCoder: (NSCoder *) coder 
{
	id resultVal__;
	resultVal__ = [[self initWithCoder: coder ] autorelease];
	return resultVal__;
}
@end
static void addProtocols()
{
	class_addProtocol([CLFloor class], @protocol(CLFloorInstanceExports));
	class_addProtocol([CLFloor class], @protocol(CLFloorClassExports));
	class_addProtocol([CLLocationSourceInformation class], @protocol(CLLocationSourceInformationInstanceExports));
	class_addProtocol([CLLocationSourceInformation class], @protocol(CLLocationSourceInformationClassExports));
	class_addProtocol([CLLocation class], @protocol(CLLocationInstanceExports));
	class_addProtocol([CLLocation class], @protocol(CLLocationClassExports));
}
static void registerCFunctions(JSContext* context)
{
	context[@"CLLocationCoordinate2DIsValid"] = ^BOOL(CLLocationCoordinate2D arg0) {
		return CLLocationCoordinate2DIsValid(arg0);
	};
	context[@"CLLocationCoordinate2DMake"] = ^CLLocationCoordinate2D(CLLocationDegrees arg0, CLLocationDegrees arg1) {
		return CLLocationCoordinate2DMake(arg0, arg1);
	};
}
static void registerEnumConstants(JSContext* context)
{
}
static void registerGlobalConstants(JSContext* context)
{
	void* p; p = NULL;
	p = (void*) &kCLDistanceFilterNone;
	if (p != NULL) context[@"kCLDistanceFilterNone"] = @(kCLDistanceFilterNone);
	p = (void*) &kCLLocationAccuracyBestForNavigation;
	if (p != NULL) context[@"kCLLocationAccuracyBestForNavigation"] = @(kCLLocationAccuracyBestForNavigation);
	p = (void*) &kCLLocationAccuracyBest;
	if (p != NULL) context[@"kCLLocationAccuracyBest"] = @(kCLLocationAccuracyBest);
	p = (void*) &kCLLocationAccuracyNearestTenMeters;
	if (p != NULL) context[@"kCLLocationAccuracyNearestTenMeters"] = @(kCLLocationAccuracyNearestTenMeters);
	p = (void*) &kCLLocationAccuracyHundredMeters;
	if (p != NULL) context[@"kCLLocationAccuracyHundredMeters"] = @(kCLLocationAccuracyHundredMeters);
	p = (void*) &kCLLocationAccuracyKilometer;
	if (p != NULL) context[@"kCLLocationAccuracyKilometer"] = @(kCLLocationAccuracyKilometer);
	p = (void*) &kCLLocationAccuracyThreeKilometers;
	if (p != NULL) context[@"kCLLocationAccuracyThreeKilometers"] = @(kCLLocationAccuracyThreeKilometers);
	p = (void*) &kCLLocationAccuracyReduced;
	if (p != NULL) context[@"kCLLocationAccuracyReduced"] = @(kCLLocationAccuracyReduced);
	p = (void*) &CLLocationDistanceMax;
	if (p != NULL) context[@"CLLocationDistanceMax"] = @(CLLocationDistanceMax);
	p = (void*) &CLTimeIntervalMax;
	if (p != NULL) context[@"CLTimeIntervalMax"] = @(CLTimeIntervalMax);
	p = (void*) &kCLLocationCoordinate2DInvalid;
	if (p != NULL) context[@"kCLLocationCoordinate2DInvalid"] = [JSValue valueWithCLLocationCoordinate2D: kCLLocationCoordinate2DInvalid inContext: context];
}
void load_CoreLocation_CLLocation_symbols(JSContext* context)
{
    addProtocols();
    registerEnumConstants(context);
    registerCFunctions(context);
    registerGlobalConstants(context);
}
#pragma clang diagnostic pop
